/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalInspectionTool;
import com.intellij.codeInspection.GlobalSimpleInspectionTool;
import com.intellij.codeInspection.InspectionEP;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.JobDescriptor;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.codeInspection.ex.StdJobDescriptors;
import com.intellij.codeInspection.reference.RefGraphAnnotator;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefManagerImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GlobalInspectionToolWrapper
extends InspectionToolWrapper<GlobalInspectionTool, InspectionEP> {
    private static final Logger LOG = Logger.getInstance(GlobalInspectionToolWrapper.class);

    public GlobalInspectionToolWrapper(@NotNull GlobalInspectionTool globalInspectionTool) {
        super((InspectionProfileEntry)globalInspectionTool, null);
    }

    public GlobalInspectionToolWrapper(@NotNull GlobalInspectionTool tool, @NotNull InspectionEP ep2) {
        super((InspectionProfileEntry)tool, ep2);
    }

    public GlobalInspectionToolWrapper(@NotNull InspectionEP ep2) {
        super(null, ep2);
    }

    private GlobalInspectionToolWrapper(@NotNull GlobalInspectionToolWrapper other) {
        super((InspectionToolWrapper)other);
    }

    @NotNull
    public GlobalInspectionToolWrapper createCopy() {
        return new GlobalInspectionToolWrapper(this);
    }

    public void initialize(@NotNull GlobalInspectionContext context) {
        RefManagerImpl refManager = (RefManagerImpl)context.getRefManager();
        RefGraphAnnotator annotator = ((GlobalInspectionTool)this.getTool()).getAnnotator((RefManager)refManager);
        if (annotator != null) {
            refManager.registerGraphAnnotator(annotator);
        }
        super.initialize(context);
    }

    public JobDescriptor @NotNull [] getJobDescriptors(@NotNull GlobalInspectionContext context) {
        GlobalInspectionTool tool = (GlobalInspectionTool)this.getTool();
        Object[] additionalJobs = (JobDescriptor[])ObjectUtils.notNull((Object)tool.getAdditionalJobs(context), (Object)JobDescriptor.EMPTY_ARRAY);
        StdJobDescriptors stdJobDescriptors = context.getStdJobDescriptors();
        if (tool.isGraphNeeded()) {
            Object[] objectArray = additionalJobs = additionalJobs.length == 0 ? stdJobDescriptors.BUILD_GRAPH_ONLY : (JobDescriptor[])ArrayUtil.append((Object[])additionalJobs, (Object)stdJobDescriptors.BUILD_GRAPH);
        }
        if (tool instanceof GlobalSimpleInspectionTool) {
            additionalJobs = additionalJobs.length == 0 ? stdJobDescriptors.LOCAL_ANALYSIS_ARRAY : (ArrayUtil.contains((Object)stdJobDescriptors.LOCAL_ANALYSIS, (Object[])additionalJobs) ? additionalJobs : (JobDescriptor[])ArrayUtil.append((Object[])additionalJobs, (Object)stdJobDescriptors.LOCAL_ANALYSIS));
        }
        return additionalJobs;
    }

    public boolean worksInBatchModeOnly() {
        return ((GlobalInspectionTool)this.getTool()).worksInBatchModeOnly();
    }

    @Nullable
    public LocalInspectionToolWrapper getSharedLocalInspectionToolWrapper() {
        LocalInspectionTool sharedTool = ((GlobalInspectionTool)this.getTool()).getSharedLocalInspectionTool();
        if (sharedTool == null) {
            LOG.assertTrue(!this.isCleanupTool(), (Object)("Global cleanup tool MUST have shared local tool. The tool short name: " + this.getShortName()));
            return null;
        }
        return new LocalInspectionToolWrapper(sharedTool){

            @NotNull
            public String getDisplayName() {
                return GlobalInspectionToolWrapper.this.getDisplayName();
            }

            @Nullable
            public String getLanguage() {
                return GlobalInspectionToolWrapper.this.getLanguage();
            }
        };
    }
}

