/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.InspectionToolResultExporter;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.SuppressionUtil;
import com.intellij.codeInspection.ex.GlobalInspectionContextUtil;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefManagerImpl;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiNamedElement;
import com.intellij.util.ArrayFactory;
import com.intellij.util.TripleFunction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BatchModeDescriptorsUtil {
    private static final TripleFunction<LocalInspectionTool, PsiElement, GlobalInspectionContext, RefElement> CONVERT = (tool, element2, context) -> {
        PsiLanguageInjectionHost injectionHost = InjectedLanguageManager.getInstance((Project)context.getProject()).getInjectionHost(element2);
        if (injectionHost != null) {
            element2 = injectionHost;
        }
        PsiNamedElement problemElement = BatchModeDescriptorsUtil.getContainerElement(element2, tool, context);
        RefElement refElement = context.getRefManager().getReference((PsiElement)problemElement);
        if (refElement == null && problemElement != null) {
            refElement = GlobalInspectionContextUtil.retrieveRefElement(element2, context);
        }
        return refElement;
    };

    static void addProblemDescriptors(@NotNull List<? extends ProblemDescriptor> descriptors, boolean filterSuppressed, @NotNull GlobalInspectionContext context, @Nullable LocalInspectionTool tool, @NotNull TripleFunction<? super LocalInspectionTool, ? super PsiElement, ? super GlobalInspectionContext, ? extends RefElement> getProblemElementFunction, @NotNull InspectionToolResultExporter dpi) {
        RefElement refElement;
        if (descriptors.isEmpty()) {
            return;
        }
        HashMap<RefElement, List> problems2 = new HashMap<RefElement, List>();
        RefManagerImpl refManager = (RefManagerImpl)context.getRefManager();
        for (ProblemDescriptor problemDescriptor : descriptors) {
            String alternativeId;
            String id2;
            PsiElement element2 = problemDescriptor.getPsiElement();
            if (element2 == null || filterSuppressed && (refManager.isDeclarationsFound() && (context.isSuppressed(element2, id2 = tool.getID()) || (alternativeId = tool.getAlternativeID()) != null && !alternativeId.equals(id2) && context.isSuppressed(element2, alternativeId)) || SuppressionUtil.inspectionResultSuppressed(element2, tool))) continue;
            refElement = (RefElement)getProblemElementFunction.fun((Object)tool, (Object)element2, (Object)context);
            List elementProblems = problems2.computeIfAbsent(refElement, __ -> new ArrayList());
            elementProblems.add(problemDescriptor);
        }
        for (Map.Entry entry : problems2.entrySet()) {
            List problemDescriptors = (List)entry.getValue();
            refElement = (RefElement)entry.getKey();
            CommonProblemDescriptor[] descriptions = problemDescriptors.toArray(CommonProblemDescriptor.EMPTY_ARRAY);
            dpi.addProblemElement((RefEntity)refElement, filterSuppressed, descriptions);
        }
    }

    public static void addProblemDescriptors(@NotNull List<? extends ProblemDescriptor> descriptors, @NotNull InspectionToolResultExporter dpi, boolean filterSuppressed, @NotNull GlobalInspectionContext inspectionContext, @NotNull LocalInspectionTool tool) {
        BatchModeDescriptorsUtil.addProblemDescriptors(descriptors, filterSuppressed, inspectionContext, tool, CONVERT, dpi);
    }

    public static PsiNamedElement getContainerElement(@Nullable PsiElement element2, @NotNull LocalInspectionTool tool, @NotNull GlobalInspectionContext context) {
        if (element2 == null) {
            return null;
        }
        PsiNamedElement containerFromTool = tool.getProblemElement(element2);
        if (containerFromTool != null && !(containerFromTool instanceof PsiFile)) {
            return containerFromTool;
        }
        PsiNamedElement container2 = context.getRefManager().getContainerElement(element2);
        return container2 != null ? container2 : containerFromTool;
    }

    public static CommonProblemDescriptor @NotNull [] flattenDescriptors(@NotNull List<CommonProblemDescriptor[]> descriptors) {
        return (CommonProblemDescriptor[])descriptors.stream().flatMap(ds -> Arrays.stream(ds)).toArray(arg_0 -> ((ArrayFactory)CommonProblemDescriptor.ARRAY_FACTORY).create(arg_0));
    }
}

