/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.actions;

import com.intellij.analysis.AnalysisScope;
import com.intellij.analysis.AnalysisUIOptions;
import com.intellij.analysis.BaseAnalysisActionDialog;
import com.intellij.analysis.dialog.ModelScopeItem;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.InspectionManagerEx;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.InspectionToolsSupplier;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RunInspectionIntention
implements IntentionAction,
HighPriorityAction {
    private static final Logger LOG = Logger.getInstance(RunInspectionIntention.class);
    private final String myShortName;

    public RunInspectionIntention(@NotNull HighlightDisplayKey key) {
        this.myShortName = key.toString();
    }

    @NotNull
    public String getText() {
        return InspectionsBundle.message((String)"run.inspection.on.file.intention.text", (Object[])new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
        return LocalInspectionToolWrapper.findTool2RunInBatch(project, (PsiElement)file2, this.myShortName) != null;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file2) throws IncorrectOperationException {
        Module module = file2 != null ? ModuleUtilCore.findModuleForPsiElement((PsiElement)file2) : null;
        AnalysisScope analysisScope = new AnalysisScope(project);
        if (file2 != null) {
            PsiFile topLevelFile = InjectedLanguageManager.getInstance((Project)project).getTopLevelFile((PsiElement)file2);
            VirtualFile virtualFile = topLevelFile.getVirtualFile();
            if (file2.isPhysical() && virtualFile != null && virtualFile.isInLocalFileSystem()) {
                analysisScope = new AnalysisScope(topLevelFile);
            }
        }
        RunInspectionIntention.selectScopeAndRunInspection(this.myShortName, analysisScope, module, (PsiElement)file2, project);
    }

    public static void selectScopeAndRunInspection(@NotNull String toolShortName, @NotNull AnalysisScope customScope, @Nullable Module module, @Nullable PsiElement context, @NotNull Project project) {
        List<ModelScopeItem> items = BaseAnalysisActionDialog.standardItems(project, customScope, module, context);
        BaseAnalysisActionDialog dlg = new BaseAnalysisActionDialog(CodeInsightBundle.message((String)"specify.analysis.scope", (Object[])new Object[]{InspectionsBundle.message((String)"inspection.action.title", (Object[])new Object[0])}), CodeInsightBundle.message((String)"analysis.scope.title", (Object[])new Object[]{InspectionsBundle.message((String)"inspection.action.noun", (Object[])new Object[0])}), project, items, AnalysisUIOptions.getInstance(project), true);
        if (!dlg.showAndGet()) {
            return;
        }
        customScope = dlg.getScope(customScope);
        InspectionToolWrapper<?, ?> wrapper2 = LocalInspectionToolWrapper.findTool2RunInBatch(project, context, toolShortName);
        LOG.assertTrue(wrapper2 != null, (Object)("Can't find tool with name = \"" + toolShortName + "\""));
        RunInspectionIntention.rerunInspection(wrapper2, (InspectionManagerEx)InspectionManager.getInstance((Project)project), customScope, context);
    }

    public static void rerunInspection(@NotNull InspectionToolWrapper toolWrapper, @NotNull InspectionManagerEx managerEx, @NotNull AnalysisScope scope, @Nullable PsiElement psiElement) {
        GlobalInspectionContextImpl inspectionContext = RunInspectionIntention.createContext(toolWrapper, managerEx, psiElement);
        inspectionContext.doInspections(scope);
    }

    @NotNull
    public static GlobalInspectionContextImpl createContext(@NotNull InspectionToolWrapper toolWrapper, @NotNull InspectionManagerEx managerEx, @Nullable PsiElement psiElement) {
        InspectionProfileImpl model = RunInspectionIntention.createProfile(toolWrapper, managerEx, psiElement);
        GlobalInspectionContextImpl inspectionContext = managerEx.createNewGlobalContext();
        inspectionContext.setExternalProfile(model);
        return inspectionContext;
    }

    @NotNull
    public static InspectionProfileImpl createProfile(@NotNull InspectionToolWrapper toolWrapper, @NotNull InspectionManagerEx managerEx, @Nullable PsiElement psiElement) {
        Project project = managerEx.getProject();
        InspectionProfileImpl rootProfile = InspectionProfileManager.getInstance(project).getCurrentProfile();
        LinkedHashSet<InspectionToolWrapper> allWrappers = new LinkedHashSet<InspectionToolWrapper>();
        allWrappers.add(toolWrapper);
        rootProfile.collectDependentInspections(toolWrapper, allWrappers, project);
        ArrayList<InspectionToolWrapper<?, ?>> toolWrappers = allWrappers.size() == 1 ? Collections.singletonList(allWrappers.iterator().next()) : new ArrayList(allWrappers);
        InspectionProfileImpl model = new InspectionProfileImpl(toolWrapper.getDisplayName(), (InspectionToolsSupplier)new InspectionToolsSupplier.Simple(toolWrappers), rootProfile);
        for (InspectionToolWrapper inspectionToolWrapper : toolWrappers) {
            model.enableTool(inspectionToolWrapper.getShortName(), project);
        }
        try {
            Element element2 = new Element("toCopy");
            for (InspectionToolWrapper inspectionToolWrapper : toolWrappers) {
                InspectionToolWrapper tw;
                inspectionToolWrapper.getTool().writeSettings(element2);
                InspectionToolWrapper inspectionToolWrapper2 = tw = psiElement == null ? model.getInspectionTool(inspectionToolWrapper.getShortName(), project) : model.getInspectionTool(inspectionToolWrapper.getShortName(), psiElement);
                assert (tw != null);
                tw.getTool().readSettings(element2);
            }
        }
        catch (InvalidDataException | WriteExternalException throwable) {
            // empty catch block
        }
        model.setSingleTool(toolWrapper.getShortName());
        return model;
    }

    public boolean startInWriteAction() {
        return false;
    }
}

