/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.unwrap;

import com.intellij.codeInsight.unwrap.UnwrapDescriptor;
import com.intellij.codeInsight.unwrap.Unwrapper;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class UnwrapDescriptorBase
implements UnwrapDescriptor {
    private Unwrapper[] myUnwrappers;

    public final Unwrapper @NotNull [] getUnwrappers() {
        if (this.myUnwrappers == null) {
            this.myUnwrappers = this.createUnwrappers();
        }
        return this.myUnwrappers;
    }

    @Override
    @NotNull
    public List<Pair<PsiElement, Unwrapper>> collectUnwrappers(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2) {
        ArrayList<Pair<PsiElement, Unwrapper>> result2 = new ArrayList<Pair<PsiElement, Unwrapper>>();
        HashSet<PsiElement> ignored = new HashSet<PsiElement>();
        for (PsiElement e = this.findTargetElement(editor, file2); e != null; e = e.getParent()) {
            for (Unwrapper u : this.getUnwrappers()) {
                if (!u.isApplicableTo(e) || ignored.contains(e)) continue;
                result2.add((Pair<PsiElement, Unwrapper>)Pair.create((Object)e, (Object)u));
                u.collectElementsToIgnore(e, ignored);
            }
        }
        return result2;
    }

    protected abstract Unwrapper[] createUnwrappers();

    @Nullable
    protected PsiElement findTargetElement(Editor editor, PsiFile file2) {
        PsiElement startElement;
        int offset = editor.getCaretModel().getOffset();
        PsiElement endElement = file2.findElementAt(offset);
        SelectionModel selectionModel = editor.getSelectionModel();
        if (selectionModel.hasSelection() && selectionModel.getSelectionStart() < offset && (startElement = file2.findElementAt(selectionModel.getSelectionStart())) != null && startElement != endElement && startElement.getTextRange().getEndOffset() == offset) {
            return startElement;
        }
        return endElement;
    }

    @Override
    public boolean showOptionsDialog() {
        return true;
    }

    @Override
    public boolean shouldTryToRestoreCaretPosition() {
        return true;
    }
}

