/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.postfix.settings;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplate;
import com.intellij.codeInsight.template.postfix.templates.editable.PostfixTemplateEditor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.ui.FormBuilder;
import java.awt.Component;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PostfixEditTemplateDialog
extends DialogWrapper {
    private final JBTextField myTemplateNameTextField;
    private final PostfixTemplateEditor myEditor;

    public PostfixEditTemplateDialog(@NotNull Component parentComponent, @NotNull PostfixTemplateEditor editor, @NotNull String templateType, @Nullable PostfixTemplate template) {
        super(null, parentComponent, true, DialogWrapper.IdeModalityType.IDE);
        this.myEditor = editor;
        Disposer.register((Disposable)this.getDisposable(), (Disposable)editor);
        String initialName = template != null ? StringUtil.trimStart((String)template.getKey(), (String)".") : "";
        this.myTemplateNameTextField = new JBTextField(initialName);
        this.setTitle(template != null ? CodeInsightBundle.message((String)"dialog.title.edit.0.template", (Object[])new Object[]{initialName}) : CodeInsightBundle.message((String)"dialog.title.create.new.0.template", (Object[])new Object[]{templateType}));
        this.init();
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myTemplateNameTextField;
    }

    @NotNull
    protected List<ValidationInfo> doValidateAll() {
        String templateName = this.myTemplateNameTextField.getText();
        if (!StringUtil.isJavaIdentifier((String)templateName)) {
            return Collections.singletonList(new ValidationInfo(CodeInsightBundle.message((String)"message.template.key.must.be.an.identifier", (Object[])new Object[0]), (JComponent)this.myTemplateNameTextField));
        }
        return super.doValidateAll();
    }

    @NotNull
    public String getTemplateName() {
        return this.myTemplateNameTextField.getText();
    }

    protected JComponent createCenterPanel() {
        return FormBuilder.createFormBuilder().addLabeledComponent(CodeInsightBundle.message((String)"label.template.key", (Object[])new Object[0]), (JComponent)this.myTemplateNameTextField).addComponentFillVertically(this.myEditor.getComponent(), 4).getPanel();
    }

    @Nullable
    protected String getHelpId() {
        return this.myEditor.getHelpId();
    }
}

