/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.macro;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.codeInsight.template.macro.MacroBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.text.NameUtilCore;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConvertToCamelCaseMacro
extends MacroBase {
    public ConvertToCamelCaseMacro() {
        super("camelCase", "camelCase(String)");
    }

    private ConvertToCamelCaseMacro(String name, String description) {
        super(name, description);
    }

    @Override
    @Nullable
    protected Result calculateResult(Expression @NotNull [] params, ExpressionContext context, boolean quick) {
        String text = ConvertToCamelCaseMacro.getTextResult(params, context, true);
        return text != null ? this.convertString(text) : null;
    }

    @NotNull
    @VisibleForTesting
    public Result convertString(@NotNull String text) {
        String[] strings = this.splitWords(text);
        if (strings.length > 0) {
            StringBuilder buf = new StringBuilder();
            buf.append(StringUtil.toLowerCase((String)strings[0]));
            for (int i2 = 1; i2 < strings.length; ++i2) {
                String string = strings[i2];
                if (!Character.isLetterOrDigit(string.charAt(0))) continue;
                buf.append(StringUtil.capitalize((String)StringUtil.toLowerCase((String)string)));
            }
            return new TextResult(buf.toString());
        }
        return new TextResult("");
    }

    protected String @NotNull [] splitWords(String text) {
        return NameUtilCore.nameToWords((String)text);
    }

    public static class ReplaceUnderscoresToCamelCaseMacro
    extends ConvertToCamelCaseMacro {
        public ReplaceUnderscoresToCamelCaseMacro() {
            super("underscoresToCamelCase", CodeInsightBundle.message((String)"macro.underscoresToCamelCase.string", (Object[])new Object[0]));
        }

        @Override
        protected String @NotNull [] splitWords(String text) {
            return text.split("_");
        }
    }
}

