/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.impl;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.generation.surroundWith.SurroundWithHandler;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.template.CustomLiveTemplate;
import com.intellij.codeInsight.template.TemplateActionContext;
import com.intellij.codeInsight.template.impl.InvokeTemplateAction;
import com.intellij.codeInsight.template.impl.SurroundWithLogger;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.WrapWithCustomTemplateAction;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.psi.PsiFile;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class SurroundWithTemplateHandler
implements CodeInsightActionHandler {
    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2) {
        List<AnAction> group;
        if (!EditorModificationUtil.checkModificationAllowed((Editor)editor)) {
            return;
        }
        if (!editor.getSelectionModel().hasSelection()) {
            SurroundWithHandler.selectLogicalLineContentsAtCaret(editor);
            if (!editor.getSelectionModel().hasSelection()) {
                return;
            }
        }
        if ((group = SurroundWithTemplateHandler.createActionGroup(editor, file2, new HashSet<Character>())).isEmpty()) {
            HintManager.getInstance().showErrorHint(editor, CodeInsightBundle.message((String)"templates.surround.no.defined", (Object[])new Object[0]));
            return;
        }
        ListPopup popup2 = JBPopupFactory.getInstance().createActionGroupPopup(CodeInsightBundle.message((String)"templates.select.template.chooser.title", (Object[])new Object[0]), (ActionGroup)new DefaultActionGroup(group), DataManager.getInstance().getDataContext((Component)editor.getContentComponent()), JBPopupFactory.ActionSelectionAid.MNEMONICS, false);
        popup2.showInBestPositionFor(editor);
    }

    @NotNull
    public static List<AnAction> createActionGroup(@NotNull Editor editor, @NotNull PsiFile file2, @NotNull Set<Character> usedMnemonicsSet) {
        TemplateActionContext templateActionContext = TemplateActionContext.surrounding((PsiFile)file2, (Editor)editor);
        List<CustomLiveTemplate> customTemplates = TemplateManagerImpl.listApplicableCustomTemplates(templateActionContext);
        List<TemplateImpl> templates = TemplateManagerImpl.listApplicableTemplateWithInsertingDummyIdentifier(templateActionContext);
        if (templates.isEmpty() && customTemplates.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<AnAction> group = new ArrayList<AnAction>();
        for (TemplateImpl template : templates) {
            group.add(new InvokeTemplateAction(template, editor, file2.getProject(), usedMnemonicsSet, () -> SurroundWithLogger.logTemplate(template, file2.getLanguage(), file2.getProject())));
        }
        for (CustomLiveTemplate customTemplate : customTemplates) {
            group.add(new WrapWithCustomTemplateAction(customTemplate, editor, file2, usedMnemonicsSet, () -> SurroundWithLogger.logCustomTemplate(customTemplate, file2.getLanguage(), file2.getProject())));
        }
        return group;
    }
}

