/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.impl;

import com.intellij.codeInsight.template.CustomLiveTemplate;
import com.intellij.codeInsight.template.impl.LiveTemplateRunLogger;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.FUCounterUsageLogger;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.lang.Language;
import com.intellij.lang.surroundWith.Surrounder;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;

public final class SurroundWithLogger {
    private static final String USAGE_GROUP = "surround.with";

    public static void logSurrounder(Surrounder surrounder, @NotNull Language language, @NotNull Project project) {
        SurroundWithLogger.log("surrounder", surrounder.getClass(), language, project);
    }

    private static void log(@NotNull String type, @NotNull Class<?> elementClass, @NotNull Language language, @NotNull Project project) {
        PluginInfo pluginInfo = PluginInfoDetectorKt.getPluginInfo(elementClass);
        FeatureUsageData data2 = new FeatureUsageData().addPluginInfo(pluginInfo).addLanguage(language);
        data2.addData("class", pluginInfo.getType().isDevelopedByJetBrains() ? elementClass.getName() : "third.party");
        FUCounterUsageLogger.getInstance().logEvent(project, USAGE_GROUP, type + ".executed", data2);
    }

    static void logTemplate(@NotNull TemplateImpl template, @NotNull Language language, @NotNull Project project) {
        FeatureUsageData data2 = LiveTemplateRunLogger.createTemplateData(template, language);
        if (data2 != null) {
            FUCounterUsageLogger.getInstance().logEvent(project, USAGE_GROUP, "live.template.executed", data2);
        }
    }

    static void logCustomTemplate(@NotNull CustomLiveTemplate template, @NotNull Language language, @NotNull Project project) {
        SurroundWithLogger.log("custom.template", template.getClass(), language, project);
    }
}

