/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.impl;

import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.template.CustomLiveTemplateBase;
import com.intellij.codeInsight.template.CustomTemplateCallback;
import com.intellij.codeInsight.template.impl.LiveTemplateLookupElement;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomLiveTemplateLookupElement
extends LiveTemplateLookupElement {
    @NotNull
    private final CustomLiveTemplateBase myCustomLiveTemplate;
    @NotNull
    private final String myTemplateKey;
    @NotNull
    private final String myItemText;

    public CustomLiveTemplateLookupElement(@NotNull CustomLiveTemplateBase customLiveTemplate, @NotNull String templateKey, @NotNull String itemText, @Nullable String description, boolean sudden, boolean worthShowingInAutoPopup) {
        super(templateKey, description, sudden, worthShowingInAutoPopup);
        this.myCustomLiveTemplate = customLiveTemplate;
        this.myTemplateKey = templateKey;
        this.myItemText = itemText;
    }

    @Override
    @NotNull
    protected String getItemText() {
        return this.myItemText;
    }

    @NotNull
    public CustomLiveTemplateBase getCustomLiveTemplate() {
        return this.myCustomLiveTemplate;
    }

    @Override
    public char getTemplateShortcut() {
        return this.myCustomLiveTemplate.getShortcut();
    }

    public void handleInsert(@NotNull InsertionContext context) {
        context.setAddCompletionChar(false);
        this.expandTemplate(context.getEditor(), context.getFile());
    }

    public void expandTemplate(@NotNull Editor editor, @NotNull PsiFile file2) {
        this.myCustomLiveTemplate.expand(this.myTemplateKey, new CustomTemplateCallback(editor, file2));
    }
}

