/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.navigation.actions;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.actions.BaseCodeInsightAction;
import com.intellij.codeInsight.navigation.CtrlMouseAction;
import com.intellij.codeInsight.navigation.CtrlMouseInfo;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.codeInsight.navigation.SingleTargetElementInfo;
import com.intellij.codeInsight.navigation.actions.TypeDeclarationPlaceAwareProvider;
import com.intellij.codeInsight.navigation.actions.TypeDeclarationProvider;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiUtilCore;
import gnu.trove.THashSet;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GotoTypeDeclarationAction
extends BaseCodeInsightAction
implements CodeInsightActionHandler,
DumbAware,
CtrlMouseAction {
    @NotNull
    protected CodeInsightActionHandler getHandler() {
        return this;
    }

    @Override
    protected boolean isValidForLookup() {
        return true;
    }

    @Override
    public void update(@NotNull AnActionEvent event) {
        if (TypeDeclarationProvider.EP_NAME.getExtensionList().size() == 0) {
            event.getPresentation().setVisible(false);
            return;
        }
        for (TypeDeclarationProvider provider : TypeDeclarationProvider.EP_NAME.getExtensionList()) {
            String text = provider.getActionText(event.getDataContext());
            if (text == null) continue;
            Presentation presentation2 = event.getPresentation();
            presentation2.setText(text);
            break;
        }
        super.update(event);
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2) {
        DumbService.getInstance((Project)project).runWithAlternativeResolveEnabled(() -> {
            try {
                int offset = editor.getCaretModel().getOffset();
                PsiElement[] symbolTypes = (PsiElement[])ActionUtil.underModalProgress((Project)project, (String)CodeInsightBundle.message((String)"progress.title.resolving.reference", (Object[])new Object[0]), () -> GotoTypeDeclarationAction.findSymbolTypes(editor, offset));
                if (symbolTypes == null || symbolTypes.length == 0) {
                    return;
                }
                if (symbolTypes.length == 1) {
                    GotoTypeDeclarationAction.navigate(project, symbolTypes[0]);
                } else {
                    NavigationUtil.getPsiElementPopup(symbolTypes, CodeInsightBundle.message((String)"choose.type.popup.title", (Object[])new Object[0])).showInBestPositionFor(editor);
                }
            }
            catch (IndexNotReadyException e) {
                DumbService.getInstance((Project)project).showDumbModeNotification(CodeInsightBundle.message((String)"message.navigation.is.not.available.here.during.index.update", (Object[])new Object[0]));
            }
        });
    }

    private static void navigate(@NotNull Project project, @NotNull PsiElement symbolType) {
        PsiElement element2 = symbolType.getNavigationElement();
        assert (element2 != null) : "SymbolType :" + symbolType + "; file: " + symbolType.getContainingFile();
        VirtualFile file2 = element2.getContainingFile().getVirtualFile();
        if (file2 != null) {
            OpenFileDescriptor descriptor2 = new OpenFileDescriptor(project, file2, element2.getTextOffset());
            FileEditorManager.getInstance((Project)project).openTextEditor(descriptor2, true);
        }
    }

    public boolean startInWriteAction() {
        return false;
    }

    @Nullable
    public static PsiElement findSymbolType(@NotNull Editor editor, int offset) {
        PsiElement[] psiElements = GotoTypeDeclarationAction.findSymbolTypes(editor, offset);
        if (psiElements != null && psiElements.length > 0) {
            return psiElements[0];
        }
        return null;
    }

    @VisibleForTesting
    public static PsiElement @Nullable [] findSymbolTypes(@NotNull Editor editor, int offset) {
        PsiElement targetElement = TargetElementUtil.getInstance().findTargetElement(editor, 11, offset);
        if (targetElement != null) {
            PsiElement[] symbolType = GotoTypeDeclarationAction.getSymbolTypeDeclarations(targetElement, editor, offset);
            return symbolType == null ? PsiElement.EMPTY_ARRAY : symbolType;
        }
        PsiReference psiReference = TargetElementUtil.findReference(editor, offset);
        if (psiReference instanceof PsiPolyVariantReference) {
            ResolveResult[] results = ((PsiPolyVariantReference)psiReference).multiResolve(false);
            THashSet types = new THashSet();
            for (ResolveResult r : results) {
                PsiElement[] declarations;
                PsiElement element2 = r.getElement();
                if (element2 == null || (declarations = GotoTypeDeclarationAction.getSymbolTypeDeclarations(element2, editor, offset)) == null) continue;
                for (PsiElement declaration : declarations) {
                    assert (declaration != null);
                    types.add(declaration);
                }
            }
            if (!types.isEmpty()) {
                return PsiUtilCore.toPsiElementArray((Collection)types);
            }
        }
        return null;
    }

    private static PsiElement @Nullable [] getSymbolTypeDeclarations(@NotNull PsiElement targetElement, Editor editor, int offset) {
        for (TypeDeclarationProvider provider : TypeDeclarationProvider.EP_NAME.getExtensionList()) {
            PsiElement[] result2 = provider instanceof TypeDeclarationPlaceAwareProvider ? ((TypeDeclarationPlaceAwareProvider)provider).getSymbolTypeDeclarations(targetElement, editor, offset) : provider.getSymbolTypeDeclarations(targetElement);
            if (result2 == null) continue;
            return result2;
        }
        return null;
    }

    @Override
    @Nullable
    public CtrlMouseInfo getCtrlMouseInfo(@NotNull Editor editor, @NotNull PsiFile file2, int offset) {
        PsiElement targetElement = GotoTypeDeclarationAction.findSymbolType(editor, offset);
        if (targetElement == null || !targetElement.isPhysical()) {
            return null;
        }
        PsiElement elementAtPointer = file2.findElementAt(offset);
        if (elementAtPointer != null) {
            return new SingleTargetElementInfo(elementAtPointer, targetElement);
        }
        return null;
    }
}

