/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.navigation.actions;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.generation.actions.PresentableActionHandlerBasedAction;
import com.intellij.lang.CodeInsightActions;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageExtension;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class GotoSuperAction
extends PresentableActionHandlerBasedAction
implements CodeInsightActionHandler,
DumbAware {
    @NonNls
    public static final String FEATURE_ID = "navigation.goto.super";

    @NotNull
    protected CodeInsightActionHandler getHandler() {
        return this;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2) {
        int offset = editor.getCaretModel().getOffset();
        Language language = PsiUtilCore.getLanguageAtOffset((PsiFile)file2, (int)offset);
        CodeInsightActionHandler codeInsightActionHandler = (CodeInsightActionHandler)CodeInsightActions.GOTO_SUPER.forLanguage(language);
        if (codeInsightActionHandler != null) {
            DumbService.getInstance((Project)project).withAlternativeResolveEnabled(() -> codeInsightActionHandler.invoke(project, editor, file2));
        }
    }

    public boolean startInWriteAction() {
        return false;
    }

    @NotNull
    protected LanguageExtension<CodeInsightActionHandler> getLanguageExtension() {
        return CodeInsightActions.GOTO_SUPER;
    }
}

