/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.navigation;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.codeInsight.navigation.CtrlMouseAction;
import com.intellij.codeInsight.navigation.CtrlMouseDocInfo;
import com.intellij.codeInsight.navigation.CtrlMouseInfo;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.codeInsight.navigation.SingleTargetElementInfo;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.MouseShortcut;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorActivityManager;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.EditorEventMulticaster;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.event.VisibleAreaListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.Consumer;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executor;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.CancellablePromise;

@ApiStatus.Internal
public final class CtrlMouseHandler {
    static final Logger LOG = Logger.getInstance(CtrlMouseHandler.class);
    private final Project myProject;
    private HighlightersSet myHighlighter;
    @JdkConstants.InputEventMask
    private int myStoredModifiers;
    private TooltipProvider myTooltipProvider;
    @Nullable
    private Point myPrevMouseLocation;
    private LightweightHint myHint;
    private final KeyListener myEditorKeyListener = new KeyAdapter(){

        @Override
        public void keyPressed(KeyEvent e) {
            this.handleKey(e);
        }

        @Override
        public void keyReleased(KeyEvent e) {
            this.handleKey(e);
        }

        private void handleKey(KeyEvent e) {
            int modifiers = e.getModifiers();
            if (modifiers == CtrlMouseHandler.this.myStoredModifiers) {
                return;
            }
            CtrlMouseAction action2 = CtrlMouseHandler.getCtrlMouseAction(modifiers);
            if (action2 == null) {
                CtrlMouseHandler.this.disposeHighlighter();
                CtrlMouseHandler.this.cancelPreviousTooltip();
            } else {
                TooltipProvider tooltipProvider = CtrlMouseHandler.this.myTooltipProvider;
                if (tooltipProvider != null) {
                    if (action2 != tooltipProvider.getAction()) {
                        CtrlMouseHandler.this.disposeHighlighter();
                    }
                    CtrlMouseHandler.this.myStoredModifiers = modifiers;
                    CtrlMouseHandler.this.cancelPreviousTooltip();
                    CtrlMouseHandler.this.myTooltipProvider = new TooltipProvider(tooltipProvider, action2);
                    CtrlMouseHandler.this.myTooltipProvider.execute();
                }
            }
        }
    };
    private final VisibleAreaListener myVisibleAreaListener = __ -> {
        this.disposeHighlighter();
        this.cancelPreviousTooltip();
    };
    private final EditorMouseListener myEditorMouseAdapter = new EditorMouseListener(){

        public void mouseReleased(@NotNull EditorMouseEvent e) {
            CtrlMouseHandler.this.disposeHighlighter();
            CtrlMouseHandler.this.cancelPreviousTooltip();
        }
    };
    private final EditorMouseMotionListener myEditorMouseMotionListener = new EditorMouseMotionListener(){

        public void mouseMoved(@NotNull EditorMouseEvent e) {
            if (e.isConsumed() || !CtrlMouseHandler.this.myProject.isInitialized() || CtrlMouseHandler.this.myProject.isDisposed()) {
                return;
            }
            MouseEvent mouseEvent = e.getMouseEvent();
            Point prevLocation = CtrlMouseHandler.this.myPrevMouseLocation;
            CtrlMouseHandler.this.myPrevMouseLocation = mouseEvent.getLocationOnScreen();
            if (CtrlMouseHandler.this.isMouseOverTooltip(mouseEvent.getLocationOnScreen()) || ScreenUtil.isMovementTowards((Point)prevLocation, (Point)mouseEvent.getLocationOnScreen(), (Rectangle)CtrlMouseHandler.this.getHintBounds())) {
                return;
            }
            CtrlMouseHandler.this.cancelPreviousTooltip();
            CtrlMouseHandler.this.myStoredModifiers = mouseEvent.getModifiers();
            CtrlMouseAction ctrlMouseAction = CtrlMouseHandler.getCtrlMouseAction(CtrlMouseHandler.this.myStoredModifiers);
            if (ctrlMouseAction == null || e.getArea() != EditorMouseEventArea.EDITING_AREA) {
                CtrlMouseHandler.this.disposeHighlighter();
                return;
            }
            Editor editor = e.getEditor();
            if (!(editor instanceof EditorEx) || editor.getProject() != null && editor.getProject() != CtrlMouseHandler.this.myProject) {
                return;
            }
            if (!e.isOverText()) {
                CtrlMouseHandler.this.disposeHighlighter();
                return;
            }
            CtrlMouseHandler.this.myTooltipProvider = new TooltipProvider((EditorEx)editor, e.getLogicalPosition(), ctrlMouseAction);
            CtrlMouseHandler.this.myTooltipProvider.execute();
        }
    };

    public CtrlMouseHandler(@NotNull Project project) {
        this.myProject = project;
        StartupManager.getInstance((Project)project).runAfterOpened(() -> {
            EditorEventMulticaster eventMulticaster = EditorFactory.getInstance().getEventMulticaster();
            eventMulticaster.addEditorMouseListener(this.myEditorMouseAdapter, (Disposable)project);
            eventMulticaster.addEditorMouseMotionListener(this.myEditorMouseMotionListener, (Disposable)project);
            eventMulticaster.addCaretListener(new CaretListener(){

                public void caretPositionChanged(@NotNull CaretEvent e) {
                    if (CtrlMouseHandler.this.myHint != null) {
                        DocumentationManager.getInstance(CtrlMouseHandler.this.myProject).updateToolwindowContext();
                    }
                }
            }, (Disposable)project);
        });
        project.getMessageBus().connect().subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerListener(){

            public void selectionChanged(@NotNull FileEditorManagerEvent event) {
                CtrlMouseHandler.this.disposeHighlighter();
                CtrlMouseHandler.this.cancelPreviousTooltip();
            }
        });
    }

    private void cancelPreviousTooltip() {
        if (this.myTooltipProvider != null) {
            this.myTooltipProvider.dispose();
            this.myTooltipProvider = null;
        }
    }

    private boolean isMouseOverTooltip(@NotNull Point mouseLocationOnScreen) {
        Rectangle bounds2 = this.getHintBounds();
        return bounds2 != null && bounds2.contains(mouseLocationOnScreen);
    }

    @Nullable
    private Rectangle getHintBounds() {
        LightweightHint hint = this.myHint;
        if (hint == null) {
            return null;
        }
        JComponent hintComponent = hint.getComponent();
        if (!hintComponent.isShowing()) {
            return null;
        }
        return new Rectangle(hintComponent.getLocationOnScreen(), hintComponent.getSize());
    }

    @Nullable
    private static CtrlMouseAction getCtrlMouseAction(@JdkConstants.InputEventMask int modifiers) {
        if (modifiers == 0) {
            return null;
        }
        KeymapManager keymapManager2 = KeymapManager.getInstance();
        if (keymapManager2 == null) {
            return null;
        }
        MouseShortcut shortcut = new MouseShortcut(1, modifiers, 1);
        List actionIds = keymapManager2.getActiveKeymap().getActionIds(shortcut);
        return (CtrlMouseAction)ContainerUtil.getOnlyItem((Collection)ContainerUtil.mapNotNull((Collection)actionIds, CtrlMouseHandler::getCtrlMouseAction));
    }

    @Nullable
    private static CtrlMouseAction getCtrlMouseAction(@NotNull String actionId) {
        AnAction action2 = ActionManager.getInstance().getAction(actionId);
        return action2 instanceof CtrlMouseAction ? (CtrlMouseAction)action2 : null;
    }

    private static boolean areSimilar(@NotNull CtrlMouseInfo info1, @NotNull CtrlMouseInfo info2) {
        return info1.getRanges().equals(info2.getRanges());
    }

    private static boolean isValidAndRangesAreCorrect(@NotNull CtrlMouseInfo info, @NotNull Document document) {
        if (!info.isValid()) {
            return false;
        }
        List<TextRange> ranges = info.getRanges();
        TextRange docRange = new TextRange(0, document.getTextLength());
        for (TextRange range2 : ranges) {
            if (docRange.contains(range2)) continue;
            return false;
        }
        return true;
    }

    private static void showDumbModeNotification(@NotNull Project project) {
        DumbService.getInstance((Project)project).showDumbModeNotification(CodeInsightBundle.message((String)"notification.element.information.is.not.available.during.index.update", (Object[])new Object[0]));
    }

    private void disposeHighlighter() {
        HighlightersSet highlighter = this.myHighlighter;
        if (highlighter != null) {
            this.myHighlighter = null;
            highlighter.uninstall();
            HintManager.getInstance().hideAllHints();
        }
    }

    private void updateText(@NotNull String updatedText, @NotNull Consumer<? super String> newTextConsumer, @NotNull LightweightHint hint, @NotNull Editor editor) {
        UIUtil.invokeLaterIfNeeded(() -> {
            JComponent component2 = hint.getComponent();
            Dimension oldSize = component2.getPreferredSize();
            newTextConsumer.consume((Object)updatedText);
            Dimension newSize = component2.getPreferredSize();
            if (newSize.width == oldSize.width) {
                return;
            }
            component2.setPreferredSize(new Dimension(newSize.width, newSize.height));
            if (hint.isRealPopup()) {
                TooltipProvider tooltipProvider = this.myTooltipProvider;
                if (tooltipProvider != null) {
                    hint.hide();
                    tooltipProvider.showHint(new LightweightHint(component2), editor);
                } else {
                    component2.setPreferredSize(new Dimension(newSize.width, oldSize.height));
                    hint.pack();
                }
                return;
            }
            Container topLevelLayeredPaneChild = null;
            boolean adjustBounds = false;
            for (Container current2 = component2.getParent(); current2 != null; current2 = current2.getParent()) {
                if (current2 instanceof JLayeredPane) {
                    adjustBounds = true;
                    break;
                }
                topLevelLayeredPaneChild = current2;
            }
            if (adjustBounds && topLevelLayeredPaneChild != null) {
                Rectangle bounds2 = topLevelLayeredPaneChild.getBounds();
                topLevelLayeredPaneChild.setBounds(bounds2.x, bounds2.y, bounds2.width + newSize.width - oldSize.width, bounds2.height);
            }
        });
    }

    @NotNull
    private HighlightersSet installHighlighterSet(@NotNull CtrlMouseInfo info, @NotNull EditorEx editor, boolean highlighterOnly) {
        editor.getContentComponent().addKeyListener(this.myEditorKeyListener);
        editor.getScrollingModel().addVisibleAreaListener(this.myVisibleAreaListener);
        if (info.isNavigatable()) {
            editor.setCustomCursor(CtrlMouseHandler.class, Cursor.getPredefinedCursor(12));
        }
        ArrayList<RangeHighlighter> highlighters = new ArrayList<RangeHighlighter>();
        if (!highlighterOnly || info.isNavigatable()) {
            TextAttributes attributes = info.isNavigatable() ? EditorColorsManager.getInstance().getGlobalScheme().getAttributes(EditorColors.REFERENCE_HYPERLINK_COLOR) : new TextAttributes(null, HintUtil.getInformationColor(), null, null, 0);
            for (TextRange range2 : info.getRanges()) {
                TextAttributes attr = NavigationUtil.patchAttributesColor(attributes, range2, editor);
                RangeHighlighter highlighter = editor.getMarkupModel().addRangeHighlighter(range2.getStartOffset(), range2.getEndOffset(), 5900, attr, HighlighterTargetArea.EXACT_RANGE);
                highlighters.add(highlighter);
            }
        }
        return new HighlightersSet(highlighters, editor, info);
    }

    public boolean isCalculationInProgress() {
        TooltipProvider provider = this.myTooltipProvider;
        if (provider == null) {
            return false;
        }
        CancellablePromise progress2 = provider.myExecutionProgress;
        if (progress2 == null) {
            return false;
        }
        return !progress2.isDone();
    }

    @Nullable
    public static String getInfo(PsiElement element2, PsiElement atPointer) {
        return SingleTargetElementInfo.generateInfo((PsiElement)element2, (PsiElement)atPointer, (boolean)true).text;
    }

    @Nullable
    public static String getGoToDeclarationOrUsagesText(@NotNull Editor editor) {
        Project project = editor.getProject();
        if (project == null) {
            return null;
        }
        PsiFile file2 = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
        if (file2 == null) {
            return null;
        }
        CtrlMouseInfo ctrlMouseInfo2 = CtrlMouseHandler.getCtrlMouseInfo("GotoDeclaration", editor, file2, editor.getCaretModel().getOffset());
        return ctrlMouseInfo2 == null ? null : ctrlMouseInfo2.getDocInfo().text;
    }

    @ApiStatus.Internal
    @Nullable
    public static CtrlMouseInfo getCtrlMouseInfo(@NotNull String actionId, @NotNull Editor editor, @NotNull PsiFile file2, int offset) {
        CtrlMouseAction action2 = CtrlMouseHandler.getCtrlMouseAction(actionId);
        if (action2 == null) {
            return null;
        }
        return action2.getCtrlMouseInfo(editor, file2, offset);
    }

    private final class QuickDocHyperlinkListener
    implements HyperlinkListener {
        @NotNull
        private final DocumentationProvider myProvider;
        @NotNull
        private final PsiElement myContext;

        QuickDocHyperlinkListener(@NotNull DocumentationProvider provider, PsiElement context) {
            this.myProvider = provider;
            this.myContext = context;
        }

        @Override
        public void hyperlinkUpdate(@NotNull HyperlinkEvent e) {
            if (e.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
                return;
            }
            String description = e.getDescription();
            if (StringUtil.isEmpty((String)description) || !description.startsWith("psi_element://")) {
                return;
            }
            String elementName = e.getDescription().substring("psi_element://".length());
            DumbService.getInstance((Project)CtrlMouseHandler.this.myProject).withAlternativeResolveEnabled(() -> {
                PsiElement targetElement = this.myProvider.getDocumentationElementForLink(PsiManager.getInstance((Project)CtrlMouseHandler.this.myProject), elementName, this.myContext);
                if (targetElement != null) {
                    LightweightHint hint = CtrlMouseHandler.this.myHint;
                    if (hint != null) {
                        hint.hide(true);
                    }
                    DocumentationManager.getInstance(CtrlMouseHandler.this.myProject).showJavaDocInfo(targetElement, this.myContext, null);
                }
            });
        }
    }

    private final class HighlightersSet {
        @NotNull
        private final List<? extends RangeHighlighter> myHighlighters;
        @NotNull
        private final EditorEx myHighlighterView;
        @NotNull
        private final CtrlMouseInfo myStoredInfo;

        private HighlightersSet(@NotNull List<? extends RangeHighlighter> highlighters, @NotNull EditorEx highlighterView, CtrlMouseInfo storedInfo) {
            this.myHighlighters = highlighters;
            this.myHighlighterView = highlighterView;
            this.myStoredInfo = storedInfo;
        }

        public void uninstall() {
            for (RangeHighlighter rangeHighlighter : this.myHighlighters) {
                rangeHighlighter.dispose();
            }
            this.myHighlighterView.setCustomCursor(CtrlMouseHandler.class, null);
            this.myHighlighterView.getContentComponent().removeKeyListener(CtrlMouseHandler.this.myEditorKeyListener);
            this.myHighlighterView.getScrollingModel().removeVisibleAreaListener(CtrlMouseHandler.this.myVisibleAreaListener);
        }

        @NotNull
        CtrlMouseInfo getStoredInfo() {
            return this.myStoredInfo;
        }
    }

    private final class TooltipProvider {
        @NotNull
        private final EditorEx myHostEditor;
        private final int myHostOffset;
        @NotNull
        private final CtrlMouseAction myAction;
        private boolean myDisposed;
        private CancellablePromise<?> myExecutionProgress;

        TooltipProvider(@NotNull EditorEx hostEditor, @NotNull LogicalPosition hostPos, CtrlMouseAction action2) {
            this.myHostEditor = hostEditor;
            this.myHostOffset = hostEditor.logicalPositionToOffset(hostPos);
            this.myAction = action2;
        }

        TooltipProvider(@NotNull TooltipProvider source, CtrlMouseAction action2) {
            this.myHostEditor = source.myHostEditor;
            this.myHostOffset = source.myHostOffset;
            this.myAction = action2;
        }

        void dispose() {
            this.myDisposed = true;
            if (this.myExecutionProgress != null) {
                this.myExecutionProgress.cancel();
            }
        }

        @NotNull
        CtrlMouseAction getAction() {
            return this.myAction;
        }

        void execute() {
            if (PsiDocumentManager.getInstance((Project)CtrlMouseHandler.this.myProject).getPsiFile((Document)this.myHostEditor.getDocument()) == null) {
                return;
            }
            int selStart = this.myHostEditor.getSelectionModel().getSelectionStart();
            int selEnd = this.myHostEditor.getSelectionModel().getSelectionEnd();
            if (this.myHostOffset >= selStart && this.myHostOffset < selEnd) {
                CtrlMouseHandler.this.disposeHighlighter();
                return;
            }
            this.myExecutionProgress = ReadAction.nonBlocking(() -> this.doExecute()).withDocumentsCommitted(CtrlMouseHandler.this.myProject).expireWhen(() -> this.isTaskOutdated(this.myHostEditor)).finishOnUiThread(ModalityState.defaultModalityState(), Runnable::run).submit((Executor)AppExecutorUtil.getAppExecutorService());
        }

        private Runnable createDisposalContinuation() {
            return () -> CtrlMouseHandler.this.disposeHighlighter();
        }

        @NotNull
        private Runnable doExecute() {
            CtrlMouseDocInfo docInfo;
            CtrlMouseInfo info;
            EditorEx editor = this.getPossiblyInjectedEditor();
            int offset = this.getOffset(editor);
            PsiFile file2 = PsiDocumentManager.getInstance((Project)CtrlMouseHandler.this.myProject).getPsiFile((Document)editor.getDocument());
            if (file2 == null) {
                return this.createDisposalContinuation();
            }
            try {
                info = this.myAction.getCtrlMouseInfo(editor, file2, offset);
                if (info == null) {
                    return this.createDisposalContinuation();
                }
                docInfo = info.getDocInfo();
            }
            catch (IndexNotReadyException e) {
                CtrlMouseHandler.showDumbModeNotification(CtrlMouseHandler.this.myProject);
                return this.createDisposalContinuation();
            }
            LOG.debug("Obtained info about element under cursor");
            return () -> this.addHighlighterAndShowHint(info, docInfo, editor);
        }

        @NotNull
        private EditorEx getPossiblyInjectedEditor() {
            DocumentEx document = this.myHostEditor.getDocument();
            if (PsiDocumentManager.getInstance((Project)CtrlMouseHandler.this.myProject).isCommitted((Document)document)) {
                PsiFile psiFile = PsiDocumentManager.getInstance((Project)CtrlMouseHandler.this.myProject).getPsiFile((Document)document);
                return (EditorEx)InjectedLanguageUtil.getEditorForInjectedLanguageNoCommit((Editor)this.myHostEditor, psiFile, this.myHostOffset);
            }
            return this.myHostEditor;
        }

        private boolean isTaskOutdated(@NotNull Editor editor) {
            return this.myDisposed || CtrlMouseHandler.this.myProject.isDisposed() || editor.isDisposed() || !ApplicationManager.getApplication().isUnitTestMode() && !EditorActivityManager.getInstance().isVisible(editor);
        }

        private int getOffset(@NotNull Editor editor) {
            return editor instanceof EditorWindow ? ((EditorWindow)editor).getDocument().hostToInjected(this.myHostOffset) : this.myHostOffset;
        }

        private void addHighlighterAndShowHint(@NotNull CtrlMouseInfo info, @NotNull CtrlMouseDocInfo docInfo, @NotNull EditorEx editor) {
            if (this.myDisposed || editor.isDisposed()) {
                return;
            }
            if (CtrlMouseHandler.this.myHighlighter != null) {
                if (!CtrlMouseHandler.areSimilar(info, CtrlMouseHandler.this.myHighlighter.getStoredInfo())) {
                    CtrlMouseHandler.this.disposeHighlighter();
                } else {
                    if (info.isNavigatable()) {
                        editor.setCustomCursor(CtrlMouseHandler.class, Cursor.getPredefinedCursor(12));
                    }
                    return;
                }
            }
            if (!CtrlMouseHandler.isValidAndRangesAreCorrect(info, editor.getDocument()) || !info.isNavigatable() && docInfo.text == null) {
                return;
            }
            boolean highlighterOnly = EditorSettingsExternalizable.getInstance().isShowQuickDocOnMouseOverElement() && DocumentationManager.getInstance(CtrlMouseHandler.this.myProject).getDocInfoHint() != null;
            CtrlMouseHandler.this.myHighlighter = CtrlMouseHandler.this.installHighlighterSet(info, editor, highlighterOnly);
            if (highlighterOnly || docInfo.text == null) {
                return;
            }
            QuickDocHyperlinkListener hyperlinkListener = docInfo.docProvider == null || docInfo.context == null ? null : new QuickDocHyperlinkListener(docInfo.docProvider, docInfo.context);
            Ref newTextConsumerRef = new Ref();
            JComponent component2 = HintUtil.createInformationLabel(docInfo.text, hyperlinkListener, null, (Ref<? super Consumer<? super String>>)newTextConsumerRef);
            component2.setBorder((Border)JBUI.Borders.empty((int)6, (int)6, (int)5, (int)6));
            LightweightHint hint = new LightweightHint(this.wrapInScrollPaneIfNeeded(component2, editor));
            CtrlMouseHandler.this.myHint = hint;
            hint.addHintListener(__ -> CtrlMouseHandler.this.myHint = null);
            this.showHint(hint, editor);
            Consumer newTextConsumer = (Consumer)newTextConsumerRef.get();
            if (newTextConsumer != null) {
                this.updateOnPsiChanges(hint, info, (Consumer<? super String>)newTextConsumer, docInfo.text, editor);
            }
        }

        @NotNull
        private JComponent wrapInScrollPaneIfNeeded(@NotNull JComponent component2, @NotNull Editor editor) {
            if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
                Dimension preferredSize = component2.getPreferredSize();
                Dimension maxSize2 = this.getMaxPopupSize(editor);
                if (preferredSize.width > maxSize2.width || preferredSize.height > maxSize2.height) {
                    JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)component2, (boolean)true);
                    scrollPane.setPreferredSize(new Dimension(Math.min(preferredSize.width, maxSize2.width), Math.min(preferredSize.height, maxSize2.height)));
                    return scrollPane;
                }
            }
            return component2;
        }

        @NotNull
        private Dimension getMaxPopupSize(@NotNull Editor editor) {
            Rectangle rectangle = ScreenUtil.getScreenRectangle((Component)editor.getContentComponent());
            return new Dimension((int)(0.9 * (double)Math.max(640, rectangle.width)), (int)(0.33 * (double)Math.max(480, rectangle.height)));
        }

        private void updateOnPsiChanges(@NotNull LightweightHint hint, @NotNull CtrlMouseInfo info, @NotNull Consumer<? super String> textConsumer, @NotNull String oldText, @NotNull Editor editor) {
            if (!hint.isVisible()) {
                return;
            }
            Disposable hintDisposable = Disposer.newDisposable((String)"CtrlMouseHandler.TooltipProvider.updateOnPsiChanges");
            hint.addHintListener(__ -> Disposer.dispose((Disposable)hintDisposable));
            CtrlMouseHandler.this.myProject.getMessageBus().connect(hintDisposable).subscribe(PsiModificationTracker.TOPIC, () -> ReadAction.nonBlocking(() -> {
                try {
                    CtrlMouseDocInfo newDocInfo = info.getDocInfo();
                    return () -> {
                        if (newDocInfo.text != null && !oldText.equals(newDocInfo.text)) {
                            CtrlMouseHandler.this.updateText(newDocInfo.text, (Consumer<? super String>)textConsumer, hint, editor);
                        }
                    };
                }
                catch (IndexNotReadyException e) {
                    CtrlMouseHandler.showDumbModeNotification(CtrlMouseHandler.this.myProject);
                    return this.createDisposalContinuation();
                }
            }).finishOnUiThread(ModalityState.defaultModalityState(), Runnable::run).withDocumentsCommitted(CtrlMouseHandler.this.myProject).expireWith(hintDisposable).expireWhen(() -> !CtrlMouseHandler.isValidAndRangesAreCorrect(info, editor.getDocument())).coalesceBy(new Object[]{CtrlMouseHandler.class, hint}).submit((Executor)AppExecutorUtil.getAppExecutorService()));
        }

        public void showHint(@NotNull LightweightHint hint, @NotNull Editor editor) {
            if (ApplicationManager.getApplication().isUnitTestMode() || editor.isDisposed()) {
                return;
            }
            HintManagerImpl hintManager = HintManagerImpl.getInstanceImpl();
            short constraint = 1;
            LogicalPosition position = editor.offsetToLogicalPosition(this.getOffset(editor));
            Point p = HintManagerImpl.getHintPosition(hint, editor, position, constraint);
            if (p.y - hint.getComponent().getPreferredSize().height < 0) {
                constraint = 2;
                p = HintManagerImpl.getHintPosition(hint, editor, position, constraint);
            }
            hintManager.showEditorHint(hint, editor, p, 42, 0, false, HintManagerImpl.createHintHint(editor, p, hint, constraint).setContentActive(false));
        }
    }
}

