/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupElementRenderer;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.codeInsight.lookup.LookupValueWithUIHint;
import com.intellij.codeInsight.lookup.PresentableLookupValue;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.ScalableIcon;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiElement;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.SizedIcon;
import com.intellij.util.PlatformIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

public class DefaultLookupItemRenderer
extends LookupElementRenderer<LookupItem<?>> {
    public static final DefaultLookupItemRenderer INSTANCE = new DefaultLookupItemRenderer();

    public void renderElement(LookupItem<?> item, LookupElementPresentation presentation2) {
        presentation2.setIcon(DefaultLookupItemRenderer.getRawIcon(item));
        presentation2.setItemText(DefaultLookupItemRenderer.getName(item));
        presentation2.setItemTextBold(item.getAttribute(LookupItem.HIGHLIGHTED_ATTR) != null);
        presentation2.setTailText(DefaultLookupItemRenderer.getText2(item), item.getAttribute(LookupItem.TAIL_TEXT_SMALL_ATTR) != null);
        presentation2.setTypeText(DefaultLookupItemRenderer.getText3(item), null);
    }

    @Deprecated
    @Nullable
    public static Icon getRawIcon(LookupElement item, boolean real) {
        return DefaultLookupItemRenderer.getRawIcon(item);
    }

    @Nullable
    public static Icon getRawIcon(LookupElement item) {
        Icon icon2 = DefaultLookupItemRenderer._getRawIcon(item);
        if (icon2 instanceof ScalableIcon) {
            icon2 = ((ScalableIcon)icon2).scale(1.0f);
        }
        if (icon2 != null && icon2.getIconHeight() > PlatformIcons.CLASS_ICON.getIconHeight()) {
            return new SizedIcon(icon2, icon2.getIconWidth(), PlatformIcons.CLASS_ICON.getIconHeight());
        }
        return icon2;
    }

    @Nullable
    private static Icon _getRawIcon(LookupElement item) {
        Icon icon2;
        if (item instanceof LookupItem && (icon2 = (Icon)((LookupItem)item).getAttribute(LookupItem.ICON_ATTR)) != null) {
            return icon2;
        }
        Object o = item.getObject();
        if (o instanceof Iconable && !(o instanceof PsiElement)) {
            return ((Iconable)o).getIcon(Registry.is((String)"ide.completion.show.visibility.icon") ? 1 : 0);
        }
        PsiElement element2 = item.getPsiElement();
        if (element2 != null && element2.isValid()) {
            return element2.getIcon(Registry.is((String)"ide.completion.show.visibility.icon") ? 1 : 0);
        }
        return null;
    }

    @Nullable
    private static String getText3(LookupItem<?> item) {
        Object o = item.getObject();
        String text = o instanceof LookupValueWithUIHint ? ((LookupValueWithUIHint)o).getTypeHint() : (String)item.getAttribute(LookupItem.TYPE_TEXT_ATTR);
        return text;
    }

    private static String getText2(LookupItem<?> item) {
        return (String)item.getAttribute(LookupItem.TAIL_TEXT_ATTR);
    }

    private static String getName(LookupItem<?> item) {
        String presentableText = item.getPresentableText();
        if (presentableText != null) {
            return presentableText;
        }
        Object o = item.getObject();
        String name = null;
        if (o instanceof PsiElement) {
            PsiElement element2 = (PsiElement)o;
            if (element2.isValid()) {
                name = PsiUtilCore.getName((PsiElement)element2);
            }
        } else {
            name = o instanceof PsiMetaData ? ((PsiMetaData)o).getName() : (o instanceof PresentableLookupValue ? ((PresentableLookupValue)o).getPresentation() : String.valueOf(o));
        }
        if (name == null) {
            name = "";
        }
        return name;
    }
}

