/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.ShowIntentionsPass;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.intention.AbstractEmptyIntentionAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.IntentionActionDelegate;
import com.intellij.codeInsight.intention.impl.CachedIntentions;
import com.intellij.codeInsight.intention.impl.IntentionActionWithTextCaching;
import com.intellij.codeInsight.intention.impl.IntentionHintComponent;
import com.intellij.codeInsight.intention.impl.ShowIntentionActionsHandler;
import com.intellij.codeInsight.intention.impl.preview.IntentionPreviewPopupUpdateProcessor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.ui.popup.MnemonicNavigationFilter;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.SpeedSearchFilter;
import com.intellij.openapi.ui.popup.StackingPopupDispatcher;
import com.intellij.openapi.util.Iconable;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilBase;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IntentionListStep
implements ListPopupStep<IntentionActionWithTextCaching>,
SpeedSearchFilter<IntentionActionWithTextCaching> {
    private static final Logger LOG = Logger.getInstance(IntentionListStep.class);
    private final CachedIntentions myCachedIntentions;
    @Nullable
    private final IntentionHintComponent myIntentionHintComponent;
    private Runnable myFinalRunnable;
    private final Project myProject;
    private final PsiFile myFile;
    @Nullable
    private final Editor myEditor;

    public IntentionListStep(@Nullable IntentionHintComponent intentionHintComponent, @Nullable Editor editor, @NotNull PsiFile file2, @NotNull Project project, CachedIntentions intentions) {
        this.myIntentionHintComponent = intentionHintComponent;
        this.myProject = project;
        this.myFile = file2;
        this.myEditor = editor;
        this.myCachedIntentions = intentions;
    }

    public String getTitle() {
        return null;
    }

    public boolean isSelectable(IntentionActionWithTextCaching action2) {
        return true;
    }

    public PopupStep<?> onChosen(IntentionActionWithTextCaching action2, boolean finalChoice) {
        IntentionAction a = IntentionActionDelegate.unwrap((IntentionAction)action2.getAction());
        if (finalChoice && !(a instanceof AbstractEmptyIntentionAction)) {
            this.applyAction(action2);
            return FINAL_CHOICE;
        }
        if (this.hasSubstep(action2)) {
            IntentionListStep.closeIntentionPreviewPopup();
            return this.getSubStep(action2, action2.getToolName());
        }
        return FINAL_CHOICE;
    }

    private static void closeIntentionPreviewPopup() {
        ApplicationManager.getApplication().invokeLater(() -> StackingPopupDispatcher.getInstance().getPopupStream().filter(popup2 -> popup2.getUserData(IntentionPreviewPopupUpdateProcessor.IntentionPreviewPopupKey.class) != null).collect(Collectors.toList()).forEach(popup2 -> popup2.cancel()));
    }

    public Runnable getFinalRunnable() {
        return this.myFinalRunnable;
    }

    private void applyAction(@NotNull IntentionActionWithTextCaching cachedAction) {
        this.myFinalRunnable = () -> {
            PsiFile file2;
            HintManager.getInstance().hideAllHints();
            if (this.myProject.isDisposed()) {
                return;
            }
            if (this.myEditor != null && (this.myEditor.isDisposed() || !this.myEditor.getComponent().isShowing() && !ApplicationManager.getApplication().isUnitTestMode())) {
                return;
            }
            if (DumbService.isDumb((Project)this.myProject) && !DumbService.isDumbAware((Object)cachedAction)) {
                DumbService.getInstance((Project)this.myProject).showDumbModeNotification(CodeInsightBundle.message((String)"notification.0.is.not.available.during.indexing", (Object[])new Object[]{cachedAction.getText()}));
                return;
            }
            PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
            PsiFile psiFile = file2 = this.myEditor != null ? PsiUtilBase.getPsiFileInEditor((Editor)this.myEditor, (Project)this.myProject) : this.myFile;
            if (file2 == null) {
                return;
            }
            ShowIntentionActionsHandler.chooseActionAndInvoke(file2, this.myEditor, cachedAction.getAction(), cachedAction.getText(), this.myProject);
        };
    }

    @NotNull
    IntentionListStep getSubStep(@NotNull IntentionActionWithTextCaching action2, final String title) {
        ShowIntentionsPass.IntentionsInfo intentions = new ShowIntentionsPass.IntentionsInfo();
        for (IntentionAction optionIntention : action2.getOptionIntentions()) {
            intentions.intentionsToShow.add(new HighlightInfo.IntentionActionDescriptor(optionIntention, IntentionListStep.getIcon(optionIntention)));
        }
        for (IntentionAction optionFix : action2.getOptionErrorFixes()) {
            intentions.errorFixesToShow.add(new HighlightInfo.IntentionActionDescriptor(optionFix, IntentionListStep.getIcon(optionFix)));
        }
        for (IntentionAction optionFix : action2.getOptionInspectionFixes()) {
            intentions.inspectionFixesToShow.add(new HighlightInfo.IntentionActionDescriptor(optionFix, IntentionListStep.getIcon(optionFix)));
        }
        return new IntentionListStep(this.myIntentionHintComponent, this.myEditor, this.myFile, this.myProject, CachedIntentions.create(this.myProject, this.myFile, this.myEditor, intentions)){

            @Override
            public String getTitle() {
                return title;
            }
        };
    }

    private static Icon getIcon(IntentionAction optionIntention) {
        return optionIntention instanceof Iconable ? ((Iconable)optionIntention).getIcon(0) : null;
    }

    public Map<IntentionAction, List<IntentionAction>> getActionsWithSubActions() {
        LinkedHashMap<IntentionAction, List<IntentionAction>> result2 = new LinkedHashMap<IntentionAction, List<IntentionAction>>();
        for (IntentionActionWithTextCaching cached : this.getValues()) {
            IntentionAction action2 = cached.getAction();
            if (ShowIntentionActionsHandler.chooseFileForAction(this.myFile, this.myEditor, action2) == null) continue;
            List<IntentionActionWithTextCaching> subActions = this.getSubStep(cached, cached.getToolName()).getValues();
            List options2 = subActions.stream().map(IntentionActionWithTextCaching::getAction).filter(option2 -> ShowIntentionActionsHandler.chooseFileForAction(this.myFile, this.myEditor, option2) != null).collect(Collectors.toList());
            result2.put(action2, options2);
        }
        return result2;
    }

    public boolean hasSubstep(IntentionActionWithTextCaching action2) {
        return action2.getOptionIntentions().size() + action2.getOptionErrorFixes().size() > 0;
    }

    @NotNull
    public List<IntentionActionWithTextCaching> getValues() {
        return this.myCachedIntentions.getAllActions();
    }

    @NotNull
    public String getTextFor(IntentionActionWithTextCaching action2) {
        String text = action2.getText();
        if (LOG.isDebugEnabled() && text.startsWith("<html>")) {
            LOG.info("IntentionAction.getText() returned HTML: action=" + action2.getAction().getClass() + " text=" + text);
        }
        return text;
    }

    public Icon getIconFor(IntentionActionWithTextCaching value2) {
        return this.myCachedIntentions.getIcon(value2);
    }

    public void canceled() {
        if (this.myIntentionHintComponent != null) {
            this.myIntentionHintComponent.canceled(this);
        }
    }

    public int getDefaultOptionIndex() {
        return 0;
    }

    public ListSeparator getSeparatorAbove(IntentionActionWithTextCaching value2) {
        List<IntentionActionWithTextCaching> values2 = this.getValues();
        int index = values2.indexOf(value2);
        if (index <= 0) {
            return null;
        }
        IntentionActionWithTextCaching prev = values2.get(index - 1);
        if (this.myCachedIntentions.getGroup(value2) != this.myCachedIntentions.getGroup(prev)) {
            return new ListSeparator();
        }
        return null;
    }

    public boolean isMnemonicsNavigationEnabled() {
        return false;
    }

    public MnemonicNavigationFilter<IntentionActionWithTextCaching> getMnemonicNavigationFilter() {
        return null;
    }

    public boolean isSpeedSearchEnabled() {
        return true;
    }

    public boolean isAutoSelectionEnabled() {
        return false;
    }

    public SpeedSearchFilter<IntentionActionWithTextCaching> getSpeedSearchFilter() {
        return this;
    }

    public String getIndexedString(IntentionActionWithTextCaching value2) {
        return this.getTextFor(value2);
    }
}

