/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints.presentation;

import com.intellij.ide.ui.AntialiasingType;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.FontInfo;
import com.intellij.util.ui.UIUtil;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import javax.swing.plaf.FontUIResource;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0000\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0005J\u0006\u0010\u001b\u001a\u00020\u0005R\u0011\u0010\n\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\fR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/codeInsight/hints/presentation/InlayTextMetrics;", "", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "fontHeight", "", "fontBaseline", "fontMetrics", "Ljava/awt/FontMetrics;", "(Lcom/intellij/openapi/editor/impl/EditorImpl;IILjava/awt/FontMetrics;)V", "ascent", "getAscent", "()I", "descent", "getDescent", "font", "Ljava/awt/Font;", "getFont", "()Ljava/awt/Font;", "getFontBaseline", "getFontHeight", "getStringWidth", "text", "", "isActual", "", "size", "offsetFromTop", "Companion", "intellij.platform.lang.impl"})
public final class InlayTextMetrics {
    private final EditorImpl editor;
    private final int fontHeight;
    private final int fontBaseline;
    private final FontMetrics fontMetrics;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final Font getFont() {
        return this.fontMetrics.getFont();
    }

    public final int getAscent() {
        return this.editor.getAscent();
    }

    public final int getDescent() {
        return this.editor.getDescent();
    }

    public final boolean isActual(int size) {
        if (size != this.getFont().getSize()) {
            return false;
        }
        return InlayTextMetrics.Companion.getCurrentContext(this.editor).equals(this.fontMetrics.getFontRenderContext());
    }

    public final int offsetFromTop() {
        return (this.editor.getLineHeight() - this.fontHeight) / 2;
    }

    public final int getStringWidth(@NotNull String text) {
        return this.fontMetrics.stringWidth(text);
    }

    public final int getFontHeight() {
        return this.fontHeight;
    }

    public final int getFontBaseline() {
        return this.fontBaseline;
    }

    public InlayTextMetrics(@NotNull EditorImpl editor, int fontHeight, int fontBaseline, @NotNull FontMetrics fontMetrics) {
        this.editor = editor;
        this.fontHeight = fontHeight;
        this.fontBaseline = fontBaseline;
        this.fontMetrics = fontMetrics;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u000bH\u0002\u00a8\u0006\f"}, d2={"Lcom/intellij/codeInsight/hints/presentation/InlayTextMetrics$Companion;", "", "()V", "create", "Lcom/intellij/codeInsight/hints/presentation/InlayTextMetrics;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "size", "", "getCurrentContext", "Ljava/awt/font/FontRenderContext;", "Lcom/intellij/openapi/editor/Editor;", "intellij.platform.lang.impl"})
    public static final class Companion {
        @NotNull
        public final InlayTextMetrics create(@NotNull EditorImpl editor, int size) {
            String familyName = UIUtil.getLabelFont().getFamily();
            FontUIResource font = UIUtil.getFontWithFallback((String)familyName, (int)0, (int)size);
            FontRenderContext context = this.getCurrentContext(editor);
            FontMetrics metrics = FontInfo.getFontMetrics(font, context);
            double d = font.createGlyphVector(context, "Albpq@").getVisualBounds().getHeight();
            boolean bl = false;
            int fontHeight = (int)Math.ceil(d);
            double d2 = font.createGlyphVector(context, "Alb").getVisualBounds().getHeight();
            boolean bl2 = false;
            int fontBaseline = (int)Math.ceil(d2);
            return new InlayTextMetrics(editor, fontHeight, fontBaseline, metrics);
        }

        private final FontRenderContext getCurrentContext(Editor editor) {
            FontRenderContext editorContext = FontInfo.getFontRenderContext(editor.getContentComponent());
            return new FontRenderContext(editorContext.getTransform(), AntialiasingType.getKeyForCurrentScope((boolean)false), editor instanceof EditorImpl ? ((EditorImpl)editor).myFractionalMetricsHintValue : RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

