/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.impl.ParameterHintsPresentationManager;
import com.intellij.codeInsight.hints.ExcludeListDialog;
import com.intellij.codeInsight.hints.HintInfo;
import com.intellij.codeInsight.hints.InlayParameterHintsExtension;
import com.intellij.codeInsight.hints.InlayParameterHintsProvider;
import com.intellij.codeInsight.hints.ParameterHintsPassFactory;
import com.intellij.codeInsight.hints.PopupActionsKt;
import com.intellij.codeInsight.hints.settings.InlayHintsConfigurable;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000R\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\"\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\b\u0010\n\u001a\u00020\u000bH\u0002\u001a$\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0014\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\u0001\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u0010\u001a\u0011\u0010\u0012\u001a\u00070\u0011\u00a2\u0006\u0002\b\u0013*\u00020\u0011H\u0002\u001a\u0011\u0010\u0014\u001a\u00070\u0011\u00a2\u0006\u0002\b\u0013*\u00020\u0011H\u0002\u001a\u001c\u0010\u0015\u001a\u00020\t*\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\n\u0010\u0019\u001a\u00020\u0011*\u00020\u001a\u00a8\u0006\u001b"}, d2={"getHintInfoFromProvider", "Lcom/intellij/codeInsight/hints/HintInfo;", "offset", "", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "hasEditorParameterHintAtOffset", "", "refreshAllOpenEditors", "", "showParameterHintsDialog", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getPattern", "Lkotlin/Function1;", "", "capitalize", "Lorg/jetbrains/annotations/NotNull;", "capitalizeFirstLetter", "hasDisabledOptionHintInfo", "Lcom/intellij/codeInsight/hints/InlayParameterHintsProvider;", "element", "Lcom/intellij/psi/PsiElement;", "toPattern", "Lcom/intellij/codeInsight/hints/HintInfo$MethodInfo;", "intellij.platform.lang.impl"})
public final class PopupActionsKt {
    public static final void showParameterHintsDialog(@NotNull AnActionEvent e, @NotNull Function1<? super HintInfo, String> getPattern) {
        HintInfo.MethodInfo methodInfo;
        PsiFile psiFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(e.getDataContext());
        if (psiFile == null) {
            return;
        }
        PsiFile file2 = psiFile;
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(e.getDataContext());
        if (editor == null) {
            return;
        }
        Editor editor2 = editor;
        Language fileLanguage = file2.getLanguage();
        if ((InlayParameterHintsProvider)InlayParameterHintsExtension.INSTANCE.forLanguage(fileLanguage) == null) {
            return;
        }
        int offset = editor2.getCaretModel().getOffset();
        HintInfo hintInfo = PopupActionsKt.getHintInfoFromProvider(offset, file2, editor2);
        if (hintInfo == null) {
            return;
        }
        HintInfo info = hintInfo;
        HintInfo hintInfo2 = info;
        if (!(hintInfo2 instanceof HintInfo.MethodInfo)) {
            hintInfo2 = null;
        }
        if ((methodInfo = (HintInfo.MethodInfo)hintInfo2) == null || (methodInfo = methodInfo.getLanguage()) == null) {
            methodInfo = fileLanguage;
        }
        HintInfo.MethodInfo selectedLanguage = methodInfo;
        String pattern = (String)getPattern.invoke((Object)info);
        if (pattern == null) {
            InlayHintsConfigurable.Companion.showSettingsDialogForLanguage(file2.getProject(), fileLanguage, showParameterHintsDialog.1.INSTANCE);
        } else {
            new ExcludeListDialog((Language)selectedLanguage, pattern).show();
        }
    }

    private static final boolean hasDisabledOptionHintInfo(InlayParameterHintsProvider $this$hasDisabledOptionHintInfo, PsiElement element2, PsiFile file2) {
        HintInfo info = $this$hasDisabledOptionHintInfo.getHintInfo(element2, file2);
        return info instanceof HintInfo.OptionInfo && !((HintInfo.OptionInfo)info).isOptionEnabled();
    }

    private static final boolean hasEditorParameterHintAtOffset(Editor editor, PsiFile file2) {
        if (editor instanceof EditorWindow) {
            return false;
        }
        int offset = editor.getCaretModel().getOffset();
        PsiElement element2 = file2.findElementAt(offset);
        PsiElement psiElement = element2;
        int startOffset = psiElement != null && (psiElement = psiElement.getTextRange()) != null ? psiElement.getStartOffset() : offset;
        PsiElement psiElement2 = element2;
        int endOffset = psiElement2 != null && (psiElement2 = psiElement2.getTextRange()) != null ? psiElement2.getEndOffset() : offset;
        Collection collection = ParameterHintsPresentationManager.getInstance().getParameterHintsInRange(editor, startOffset, endOffset);
        boolean bl = false;
        return !collection.isEmpty();
    }

    private static final void refreshAllOpenEditors() {
        ParameterHintsPassFactory.forceHintsUpdateOnNextPass();
        Project[] $this$forEach$iv = ProjectManager.getInstance().getOpenProjects();
        boolean $i$f$forEach = false;
        Project[] projectArray = $this$forEach$iv;
        int n = projectArray.length;
        for (int j = 0; j < n; ++j) {
            Project element$iv;
            Project project = element$iv = projectArray[j];
            boolean bl = false;
            PsiManager psiManager = PsiManager.getInstance((Project)project);
            DaemonCodeAnalyzer daemonCodeAnalyzer = DaemonCodeAnalyzer.getInstance((Project)project);
            FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project);
            VirtualFile[] $this$forEach$iv2 = fileEditorManager.getSelectedFiles();
            boolean $i$f$forEach2 = false;
            VirtualFile[] virtualFileArray = $this$forEach$iv2;
            int n2 = virtualFileArray.length;
            for (int k = 0; k < n2; ++k) {
                PsiFile psiFile;
                VirtualFile element$iv2;
                VirtualFile file2 = element$iv2 = virtualFileArray[k];
                boolean bl2 = false;
                if (psiManager.findFile(file2) == null) continue;
                boolean bl3 = false;
                boolean bl4 = false;
                PsiFile it = psiFile;
                boolean bl5 = false;
                daemonCodeAnalyzer.restart(it);
            }
        }
    }

    private static final HintInfo getHintInfoFromProvider(int offset, PsiFile file2, Editor editor) {
        PsiElement psiElement = file2.findElementAt(offset);
        if (psiElement == null) {
            return null;
        }
        PsiElement element2 = psiElement;
        InlayParameterHintsProvider inlayParameterHintsProvider = (InlayParameterHintsProvider)InlayParameterHintsExtension.INSTANCE.forLanguage(file2.getLanguage());
        if (inlayParameterHintsProvider == null) {
            return null;
        }
        InlayParameterHintsProvider provider = inlayParameterHintsProvider;
        PsiElement method2 = PsiTreeUtil.findFirstParent((PsiElement)element2, (Condition)((Condition)new Condition<PsiElement>(provider, file2, editor){
            final /* synthetic */ InlayParameterHintsProvider $provider;
            final /* synthetic */ PsiFile $file;
            final /* synthetic */ Editor $editor;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean value(PsiElement it) {
                if (it instanceof PsiFile) return true;
                HintInfo hintInfo = this.$provider.getHintInfo(it, this.$file);
                if (hintInfo == null) return false;
                boolean bl = hintInfo.isOwnedByPsiElement(it, this.$editor);
                if (!bl) return false;
                return true;
            }
            {
                this.$provider = inlayParameterHintsProvider;
                this.$file = psiFile;
                this.$editor = editor;
            }
        }));
        if (method2 == null || method2 instanceof PsiFile) {
            return null;
        }
        return provider.getHintInfo(method2, file2);
    }

    @NotNull
    public static final String toPattern(@NotNull HintInfo.MethodInfo $this$toPattern) {
        return $this$toPattern.getFullyQualifiedName() + '(' + CollectionsKt.joinToString$default((Iterable)$this$toPattern.getParamNames(), (CharSequence)",", null, null, (int)0, null, null, (int)62, null) + ')';
    }

    private static final String capitalize(String $this$capitalize) {
        return StringUtil.capitalizeWords((String)$this$capitalize, (boolean)true);
    }

    private static final String capitalizeFirstLetter(String $this$capitalizeFirstLetter) {
        return StringUtil.capitalize((String)$this$capitalizeFirstLetter);
    }

    public static final /* synthetic */ HintInfo access$getHintInfoFromProvider(int offset, PsiFile file2, Editor editor) {
        return PopupActionsKt.getHintInfoFromProvider(offset, file2, editor);
    }

    public static final /* synthetic */ boolean access$hasEditorParameterHintAtOffset(Editor editor, PsiFile file2) {
        return PopupActionsKt.hasEditorParameterHintAtOffset(editor, file2);
    }

    public static final /* synthetic */ void access$refreshAllOpenEditors() {
        PopupActionsKt.refreshAllOpenEditors();
    }

    public static final /* synthetic */ String access$capitalizeFirstLetter(String $this$access_u24capitalizeFirstLetter) {
        return PopupActionsKt.capitalizeFirstLetter($this$access_u24capitalizeFirstLetter);
    }

    public static final /* synthetic */ boolean access$hasDisabledOptionHintInfo(InlayParameterHintsProvider $this$access_u24hasDisabledOptionHintInfo, PsiElement element2, PsiFile file2) {
        return PopupActionsKt.hasDisabledOptionHintInfo($this$access_u24hasDisabledOptionHintInfo, element2, file2);
    }

    public static final /* synthetic */ String access$capitalize(String $this$access_u24capitalize) {
        return PopupActionsKt.capitalize($this$access_u24capitalize);
    }
}

