/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hint;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.lang.ExpressionTypeProvider;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageExpressionTypes;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.IntroduceTargetChooser;
import com.intellij.ui.LightweightHint;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.accessibility.AccessibleContextUtil;
import java.awt.Component;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class ShowExpressionTypeHandler
implements CodeInsightActionHandler {
    private final boolean myRequestFocus;

    public ShowExpressionTypeHandler(boolean requestFocus) {
        this.myRequestFocus = requestFocus;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void invoke(@NotNull Project project, final @NotNull Editor editor, @NotNull PsiFile file2) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        Language language = PsiUtilCore.getLanguageAtOffset((PsiFile)file2, (int)editor.getCaretModel().getOffset());
        Set<ExpressionTypeProvider> handlers = ShowExpressionTypeHandler.getHandlers(project, language, file2.getViewProvider().getBaseLanguage());
        if (handlers.isEmpty()) {
            return;
        }
        final Map<PsiElement, ExpressionTypeProvider> map2 = ShowExpressionTypeHandler.getExpressions(file2, editor, handlers);
        Pass<PsiElement> callback2 = new Pass<PsiElement>(){

            public void pass(@NotNull PsiElement expression) {
                ExpressionTypeProvider provider = (ExpressionTypeProvider)Objects.requireNonNull(map2.get(expression));
                String informationHint = provider.getInformationHint(expression);
                TextRange range2 = expression.getTextRange();
                editor.getSelectionModel().setSelection(range2.getStartOffset(), range2.getEndOffset());
                ShowExpressionTypeHandler.this.displayHint(new DisplayedTypeInfo(expression, provider, editor), informationHint);
            }
        };
        if (map2.isEmpty()) {
            ApplicationManager.getApplication().invokeLater(() -> {
                String errorHint = ((ExpressionTypeProvider)Objects.requireNonNull(ContainerUtil.getFirstItem((Collection)handlers))).getErrorHint();
                HintManager.getInstance().showErrorHint(editor, errorHint);
            });
        } else if (map2.size() == 1) {
            ExpressionTypeProvider provider;
            Map.Entry<PsiElement, ExpressionTypeProvider> entry = map2.entrySet().iterator().next();
            PsiElement expression = entry.getKey();
            DisplayedTypeInfo typeInfo = new DisplayedTypeInfo(expression, provider = entry.getValue(), editor);
            if (typeInfo.isRepeating() && provider.hasAdvancedInformation()) {
                String informationHint = provider.getAdvancedInformationHint(expression);
                this.displayHint(typeInfo, informationHint);
            } else {
                callback2.pass((Object)expression);
            }
        } else {
            IntroduceTargetChooser.showChooser(editor, new ArrayList<PsiElement>(map2.keySet()), callback2, PsiElement::getText);
        }
    }

    private void displayHint(@NotNull DisplayedTypeInfo typeInfo, String informationHint) {
        ApplicationManager.getApplication().invokeLater(() -> {
            HintManager.getInstance().setRequestFocusForNextHint(this.myRequestFocus);
            typeInfo.showHint(informationHint);
        });
    }

    @NotNull
    public Map<PsiElement, ExpressionTypeProvider> getExpressions(@NotNull PsiFile file2, @NotNull Editor editor) {
        Language language = PsiUtilCore.getLanguageAtOffset((PsiFile)file2, (int)editor.getCaretModel().getOffset());
        Set<ExpressionTypeProvider> handlers = ShowExpressionTypeHandler.getHandlers(file2.getProject(), language, file2.getViewProvider().getBaseLanguage());
        return ShowExpressionTypeHandler.getExpressions(file2, editor, handlers);
    }

    @NotNull
    private static Map<PsiElement, ExpressionTypeProvider> getExpressions(@NotNull PsiFile file2, @NotNull Editor editor, @NotNull Set<? extends ExpressionTypeProvider> handlers) {
        if (handlers.isEmpty()) {
            return Collections.emptyMap();
        }
        boolean exactRange = false;
        TextRange range2 = EditorUtil.getSelectionInAnyMode(editor);
        LinkedHashMap<PsiElement, ExpressionTypeProvider> map2 = new LinkedHashMap<PsiElement, ExpressionTypeProvider>();
        int offset = !range2.isEmpty() ? range2.getStartOffset() : TargetElementUtil.adjustOffset(file2, editor.getDocument(), range2.getStartOffset());
        for (int i2 = 0; i2 < 3 && map2.isEmpty() && offset >= i2; ++i2) {
            PsiElement elementAt = file2.findElementAt(offset - i2);
            if (elementAt == null) continue;
            for (ExpressionTypeProvider expressionTypeProvider : handlers) {
                for (PsiElement element2 : expressionTypeProvider.getExpressionsAt(elementAt)) {
                    TextRange r = element2.getTextRange();
                    if (exactRange && !r.equals((Object)range2) || !r.contains(range2)) continue;
                    if (!exactRange) {
                        exactRange = r.equals((Object)range2);
                    }
                    map2.put(element2, expressionTypeProvider);
                }
            }
        }
        return map2;
    }

    @NotNull
    public static Set<ExpressionTypeProvider> getHandlers(Project project, Language ... languages) {
        DumbService dumbService = DumbService.getInstance((Project)project);
        return (Set)JBIterable.of((Object[])languages).flatten(language -> dumbService.filterByDumbAwareness((Collection)LanguageExpressionTypes.INSTANCE.allForLanguage(language))).addAllTo(new LinkedHashSet());
    }

    static final class DisplayedTypeInfo {
        private static volatile DisplayedTypeInfo ourCurrentInstance;
        @NotNull
        final PsiElement myElement;
        @NotNull
        final ExpressionTypeProvider<?> myProvider;
        @NotNull
        final Editor myEditor;

        DisplayedTypeInfo(@NotNull PsiElement element2, @NotNull ExpressionTypeProvider<?> provider, @NotNull Editor editor) {
            this.myElement = element2;
            this.myProvider = provider;
            this.myEditor = editor;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DisplayedTypeInfo info = (DisplayedTypeInfo)o;
            return Objects.equals(this.myElement, info.myElement) && Objects.equals(this.myProvider, info.myProvider) && Objects.equals(this.myEditor, info.myEditor);
        }

        boolean isRepeating() {
            return this.equals(ourCurrentInstance);
        }

        void showHint(String informationHint) {
            JComponent label2 = HintUtil.createInformationLabel(informationHint);
            DisplayedTypeInfo.setInstance(this);
            AccessibleContextUtil.setName((Component)label2, (String)"Expression type hint");
            HintManagerImpl hintManager = (HintManagerImpl)HintManager.getInstance();
            LightweightHint hint = new LightweightHint(label2);
            hint.addHintListener(e -> ApplicationManager.getApplication().invokeLater(() -> DisplayedTypeInfo.setInstance(null)));
            Point p = hintManager.getHintPosition(hint, this.myEditor, (short)1);
            int flags = 42;
            hintManager.showEditorHint(hint, this.myEditor, p, flags, 0, false);
        }

        private static void setInstance(DisplayedTypeInfo typeInfo) {
            ourCurrentInstance = typeInfo;
        }
    }
}

