/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hint;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeTooltipManager;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorColorsUtil;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.ui.ColoredSideBorder;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.HintHint;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleColoredText;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.Html;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.event.HyperlinkListener;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class HintUtil {
    @Deprecated
    public static final Color INFORMATION_COLOR = new JBColor(0xF7F7F7, 0x4B4D4D);
    public static final Color INFORMATION_BORDER_COLOR = JBColor.namedColor((String)"InformationHint.borderColor", (Color)new JBColor(0xE0E0E0, 6053473));
    @Deprecated
    public static final Color ERROR_COLOR = new JBColor(0xFFDCDC, 7870258);
    public static final ColorKey INFORMATION_COLOR_KEY = ColorKey.createColorKey((String)"INFORMATION_HINT", (Color)INFORMATION_COLOR);
    public static final ColorKey QUESTION_COLOR_KEY = ColorKey.createColorKey((String)"QUESTION_HINT", (Color)new JBColor(11915515, 3632265));
    public static final ColorKey ERROR_COLOR_KEY = ColorKey.createColorKey((String)"ERROR_HINT", (Color)ERROR_COLOR);
    public static final Color QUESTION_UNDERSCORE_COLOR = JBColor.foreground();
    public static final ColorKey RECENT_LOCATIONS_SELECTION_KEY = ColorKey.createColorKey((String)"RECENT_LOCATIONS_SELECTION", (Color)new JBColor(15331061, 0x383838));
    public static final ColorKey PROMOTION_PANE_KEY = ColorKey.createColorKey((String)"PROMOTION_PANE", (Color)new JBColor(15134199, 3886167));

    private HintUtil() {
    }

    @NotNull
    public static Color getInformationColor() {
        return (Color)ObjectUtils.notNull((Object)EditorColorsUtil.getGlobalOrDefaultColor((ColorKey)INFORMATION_COLOR_KEY), (Object)INFORMATION_COLOR_KEY.getDefaultColor());
    }

    @NotNull
    public static Color getQuestionColor() {
        return (Color)ObjectUtils.notNull((Object)EditorColorsUtil.getGlobalOrDefaultColor((ColorKey)QUESTION_COLOR_KEY), (Object)QUESTION_COLOR_KEY.getDefaultColor());
    }

    @NotNull
    public static Color getErrorColor() {
        return (Color)ObjectUtils.notNull((Object)EditorColorsUtil.getGlobalOrDefaultColor((ColorKey)ERROR_COLOR_KEY), (Object)ERROR_COLOR_KEY.getDefaultColor());
    }

    @NotNull
    public static Color getRecentLocationsSelectionColor(EditorColorsScheme colorsScheme) {
        return (Color)ObjectUtils.notNull((Object)colorsScheme.getColor(RECENT_LOCATIONS_SELECTION_KEY), (Object)RECENT_LOCATIONS_SELECTION_KEY.getDefaultColor());
    }

    public static JComponent createInformationLabel(@NotNull @NlsContexts.HintText String text) {
        return HintUtil.createInformationLabel(text, null, null, null);
    }

    public static JComponent createInformationLabel(@NotNull @NlsContexts.HintText String text, @Nullable HyperlinkListener hyperlinkListener, @Nullable MouseListener mouseListener, @Nullable Ref<? super Consumer<? super String>> updatedTextConsumer) {
        HintHint hintHint = HintUtil.getInformationHint();
        HintLabel label2 = HintUtil.createLabel(text, null, hintHint.getTextBackground(), hintHint);
        HintUtil.configureLabel(label2, hyperlinkListener, mouseListener, updatedTextConsumer);
        return label2;
    }

    @NotNull
    public static HintHint getInformationHint() {
        return new HintHint().setBorderColor(INFORMATION_BORDER_COLOR).setTextBg(HintUtil.getInformationColor()).setTextFg(StartupUiUtil.isUnderDarcula() ? UIUtil.getLabelForeground() : Color.black).setFont(HintUtil.getBoldFont()).setAwtTooltip(true);
    }

    public static CompoundBorder createHintBorder() {
        return BorderFactory.createCompoundBorder((Border)new ColoredSideBorder(Color.white, Color.white, Color.gray, Color.gray, 1), BorderFactory.createEmptyBorder(2, 2, 2, 2));
    }

    @NotNull
    public static JComponent createInformationLabel(SimpleColoredText text) {
        return HintUtil.createInformationLabel(text, null);
    }

    public static JComponent createQuestionLabel(@NlsContexts.HintText String text) {
        Icon icon2 = AllIcons.General.ContextHelp;
        return HintUtil.createQuestionLabel(text, icon2);
    }

    public static JComponent createQuestionLabel(@NlsContexts.HintText String text, Icon icon2) {
        Color bg = HintUtil.getQuestionColor();
        HintHint hintHint = new HintHint().setTextBg(bg).setTextFg(JBColor.foreground()).setFont(HintUtil.getBoldFont()).setAwtTooltip(true);
        return HintUtil.createLabel(text, icon2, bg, hintHint);
    }

    @Nullable
    public static String getHintLabel(JComponent hintComponent) {
        if (hintComponent instanceof HintLabel) {
            return ((HintLabel)hintComponent).getText();
        }
        return null;
    }

    @Nullable
    public static Icon getHintIcon(JComponent hintComponent) {
        if (hintComponent instanceof HintLabel) {
            return ((HintLabel)hintComponent).getIcon();
        }
        return null;
    }

    @NotNull
    public static SimpleColoredComponent createInformationComponent() {
        SimpleColoredComponent component2 = new SimpleColoredComponent();
        component2.setBackground(HintUtil.getInformationColor());
        component2.setForeground(JBColor.foreground());
        component2.setFont(HintUtil.getBoldFont());
        return component2;
    }

    @NotNull
    public static JComponent createInformationLabel(@NotNull SimpleColoredText text, @Nullable Icon icon2) {
        SimpleColoredComponent component2 = HintUtil.createInformationComponent();
        component2.setIcon(icon2);
        text.appendToComponent((ColoredTextContainer)component2);
        return new HintLabel(component2);
    }

    public static JComponent createErrorLabel(@NotNull @NlsContexts.HintText String text, @Nullable HyperlinkListener hyperlinkListener, @Nullable MouseListener mouseListener, @Nullable Ref<? super Consumer<? super String>> updatedTextConsumer) {
        Color bg = HintUtil.getErrorColor();
        HintHint hintHint = new HintHint().setTextBg(bg).setTextFg(JBColor.foreground()).setFont(HintUtil.getBoldFont()).setAwtTooltip(true);
        HintLabel label2 = HintUtil.createLabel(text, null, bg, hintHint);
        HintUtil.configureLabel(label2, hyperlinkListener, mouseListener, updatedTextConsumer);
        return label2;
    }

    @NotNull
    public static JComponent createErrorLabel(@NotNull @NlsContexts.HintText String text) {
        return HintUtil.createErrorLabel(text, null, null, null);
    }

    @NotNull
    private static HintLabel createLabel(@NlsContexts.HintText String text, @Nullable Icon icon2, @NotNull Color color, @NotNull HintHint hintHint) {
        HintLabel label2 = new HintLabel();
        label2.setText(text, hintHint);
        label2.setIcon(icon2);
        if (!hintHint.isAwtTooltip()) {
            label2.setBorder(HintUtil.createHintBorder());
            label2.setForeground(JBColor.foreground());
            label2.setFont(HintUtil.getBoldFont());
            label2.setBackground(color);
            label2.setOpaque(true);
        }
        return label2;
    }

    private static Font getBoldFont() {
        return StartupUiUtil.getLabelFont().deriveFont(1);
    }

    @NotNull
    public static JLabel createAdComponent(String bottomText, Border border, @JdkConstants.HorizontalAlignment int alignment) {
        JLabel label2 = new JLabel();
        label2.setText(bottomText);
        label2.setHorizontalAlignment(alignment);
        label2.setForeground(JBUI.CurrentTheme.Advertiser.foreground());
        label2.setBackground(JBUI.CurrentTheme.Advertiser.background());
        label2.setOpaque(true);
        label2.setFont(label2.getFont().deriveFont((float)(label2.getFont().getSize() - 2)));
        if (bottomText != null) {
            label2.setBorder(border);
        }
        return label2;
    }

    @NotNull
    public static String prepareHintText(@NotNull @NlsContexts.HintText String text, @NotNull HintHint hintHint) {
        return HintUtil.prepareHintText(new Html(text), hintHint);
    }

    public static String prepareHintText(@NotNull Html text, @NotNull HintHint hintHint) {
        String htmlBody = UIUtil.getHtmlBody((Html)text);
        return String.format("<html><head>%s</head><body>%s</body></html>", UIUtil.getCssFontDeclaration((Font)hintHint.getTextFont(), (Color)hintHint.getTextForeground(), (Color)hintHint.getLinkForeground(), (String)hintHint.getUlImg()), htmlBody);
    }

    private static void configureLabel(@NotNull HintLabel label2, @Nullable HyperlinkListener hyperlinkListener, @Nullable MouseListener mouseListener, @Nullable Ref<? super Consumer<? super String>> updatedTextConsumer) {
        if (hyperlinkListener != null) {
            label2.myPane.addHyperlinkListener(hyperlinkListener);
        }
        if (mouseListener != null) {
            label2.myPane.addMouseListener(mouseListener);
        }
        if (updatedTextConsumer != null) {
            Consumer consumer = s -> {
                label2.myPane.setText((String)s);
                label2.setPreferredSize(null);
                label2.myPane.setPreferredSize(null);
            };
            updatedTextConsumer.set((Object)consumer);
        }
    }

    private static class HintLabel
    extends JPanel {
        private JEditorPane myPane;
        private SimpleColoredComponent myColored;
        private JLabel myIcon;

        private HintLabel() {
            this.setLayout(new BorderLayout());
        }

        private HintLabel(@NotNull SimpleColoredComponent component2) {
            this();
            this.setText(component2);
        }

        @Override
        public boolean requestFocusInWindow() {
            if (this.myPane != null) {
                return this.myPane.requestFocusInWindow();
            }
            if (this.myColored != null) {
                return this.myColored.requestFocusInWindow();
            }
            if (this.myIcon != null) {
                return this.myIcon.requestFocusInWindow();
            }
            return super.requestFocusInWindow();
        }

        public void setText(@NotNull SimpleColoredComponent colored) {
            this.clearText();
            this.myColored = colored;
            this.add((Component)this.myColored, "Center");
            this.setOpaque(true);
            this.setBackground(colored.getBackground());
            this.revalidate();
            this.repaint();
        }

        public void setText(String s, HintHint hintHint) {
            this.clearText();
            if (s != null) {
                this.myPane = IdeTooltipManager.initPane(s, hintHint, null);
                this.add((Component)this.myPane, "Center");
            }
            this.setOpaque(true);
            this.setBackground(hintHint.getTextBackground());
            this.revalidate();
            this.repaint();
        }

        private void clearText() {
            if (this.myPane != null) {
                this.remove(this.myPane);
                this.myPane = null;
            }
            if (this.myColored != null) {
                this.remove((Component)this.myColored);
                this.myColored = null;
            }
        }

        public void setIcon(Icon icon2) {
            if (this.myIcon != null) {
                this.remove(this.myIcon);
            }
            this.myIcon = new JLabel(icon2, 0);
            this.myIcon.setVerticalAlignment(1);
            this.add((Component)this.myIcon, "West");
            this.revalidate();
            this.repaint();
        }

        @Override
        public String toString() {
            return "Hint: text='" + this.getText() + "'";
        }

        public String getText() {
            return this.myPane != null ? this.myPane.getText() : "";
        }

        @Nullable
        public Icon getIcon() {
            return this.myIcon != null ? this.myIcon.getIcon() : null;
        }
    }
}

