/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hint;

import com.intellij.codeInsight.hint.DeclarationRangeHandler;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.util.MixinExtension;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DeclarationRangeUtil {
    @NotNull
    public static TextRange getDeclarationRange(@NotNull PsiElement container2) {
        TextRange textRange = DeclarationRangeUtil.getPossibleDeclarationAtRange(container2);
        assert (textRange != null) : "Declaration range is invalid for " + container2.getClass();
        return textRange;
    }

    @Nullable
    public static TextRange getPossibleDeclarationAtRange(@NotNull PsiElement container2) {
        DeclarationRangeHandler handler2 = (DeclarationRangeHandler)MixinExtension.getInstance((ExtensionPointName)DeclarationRangeHandler.EP_NAME, (Object)container2);
        return handler2 != null ? handler2.getDeclarationRange(container2) : null;
    }
}

