/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation.actions;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.generation.actions.GenerateActionPopupTemplateInjector;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionGroupUtil;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenerateAction
extends DumbAwareAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        Project project = Objects.requireNonNull(GenerateAction.getEventProject((AnActionEvent)e));
        ListPopup popup2 = JBPopupFactory.getInstance().createActionGroupPopup(CodeInsightBundle.message((String)"generate.list.popup.title", (Object[])new Object[0]), (ActionGroup)GenerateAction.wrapGroup(GenerateAction.getGroup(), dataContext, project), dataContext, JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, false);
        popup2.showInBestPositionFor(dataContext);
    }

    public void update(@NotNull AnActionEvent event) {
        Presentation presentation2 = event.getPresentation();
        if (ActionPlaces.isPopupPlace((String)event.getPlace())) {
            presentation2.setEnabledAndVisible(GenerateAction.isEnabled(event));
        } else {
            presentation2.setEnabled(GenerateAction.isEnabled(event));
        }
    }

    private static boolean isEnabled(@NotNull AnActionEvent event) {
        Project project = event.getProject();
        if (project == null) {
            return false;
        }
        Editor editor = (Editor)event.getData(CommonDataKeys.EDITOR);
        if (editor == null) {
            return false;
        }
        boolean groupEmpty = ActionGroupUtil.isGroupEmpty((ActionGroup)GenerateAction.getGroup(), (AnActionEvent)event, (boolean)LaterInvocator.isInModalContext());
        return !groupEmpty;
    }

    private static DefaultActionGroup getGroup() {
        return (DefaultActionGroup)ActionManager.getInstance().getAction("GenerateGroup");
    }

    private static DefaultActionGroup wrapGroup(DefaultActionGroup actionGroup, DataContext dataContext, @NotNull Project project) {
        DefaultActionGroup copy2 = new DefaultActionGroup();
        for (AnAction action2 : actionGroup.getChildren(null)) {
            AnAction editTemplateAction;
            if (DumbService.isDumb((Project)project) && !action2.isDumbAware()) continue;
            if (action2 instanceof GenerateActionPopupTemplateInjector && (editTemplateAction = ((GenerateActionPopupTemplateInjector)action2).createEditTemplateAction(dataContext)) != null) {
                copy2.add((AnAction)new GenerateWrappingGroup(action2, editTemplateAction));
                continue;
            }
            if (action2 instanceof DefaultActionGroup) {
                copy2.add((AnAction)GenerateAction.wrapGroup((DefaultActionGroup)action2, dataContext, project));
                continue;
            }
            copy2.add(action2);
        }
        return copy2;
    }

    private static class GenerateWrappingGroup
    extends ActionGroup {
        private final AnAction myAction;
        private final AnAction myEditTemplateAction;

        GenerateWrappingGroup(AnAction action2, AnAction editTemplateAction) {
            this.myAction = action2;
            this.myEditTemplateAction = editTemplateAction;
            this.copyFrom(action2);
            this.setPopup(true);
        }

        public boolean canBePerformed(@NotNull DataContext context) {
            return true;
        }

        public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
            return new AnAction[]{this.myEditTemplateAction};
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            DumbService.getInstance((Project)Objects.requireNonNull(GenerateWrappingGroup.getEventProject((AnActionEvent)e))).withAlternativeResolveEnabled(() -> this.myAction.actionPerformed(e));
        }

        public void update(@NotNull AnActionEvent e) {
            this.myAction.update(e);
        }
    }
}

