/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.fillParagraph;

import com.intellij.application.options.CodeStyle;
import com.intellij.formatting.FormatterTagHandler;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UnfairTextRange;
import com.intellij.openapi.util.text.CharFilter;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPlainTextFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.codeStyle.CodeFormatterFacade;
import com.intellij.psi.tree.IElementType;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParagraphFillHandler {
    protected void performOnElement(@NotNull PsiElement element2, @NotNull Editor editor) {
        Document document = editor.getDocument();
        TextRange textRange = this.getTextRange(element2, editor);
        if (textRange.isEmpty()) {
            return;
        }
        String text = textRange.substring(element2.getContainingFile().getText());
        List subStrings = StringUtil.split((String)text, (String)"\n", (boolean)true);
        String prefix = this.getPrefix(element2);
        String postfix = this.getPostfix(element2);
        StringBuilder stringBuilder = new StringBuilder();
        this.appendPrefix(element2, text, stringBuilder);
        for (String string : subStrings) {
            String startTrimmed = StringUtil.trimStart((String)string.trim(), (String)prefix.trim());
            String str = StringUtil.trimEnd((String)startTrimmed, (String)postfix.trim());
            String finalString = str.trim();
            if (StringUtil.isEmptyOrSpaces((String)finalString)) continue;
            stringBuilder.append(finalString).append(" ");
        }
        this.appendPostfix(element2, text, stringBuilder);
        String replacementText = stringBuilder.toString();
        CommandProcessor.getInstance().executeCommand(element2.getProject(), () -> {
            document.replaceString(textRange.getStartOffset(), textRange.getEndOffset(), (CharSequence)replacementText);
            PsiFile file2 = element2.getContainingFile();
            CodeFormatterFacade codeFormatter = new CodeFormatterFacade(CodeStyle.getSettings((PsiFile)file2), element2.getLanguage());
            FormatterTagHandler formatterTagHandler = new FormatterTagHandler(CodeStyle.getSettings((PsiFile)file2));
            List<TextRange> enabledRanges = formatterTagHandler.getEnabledRanges((ASTNode)file2.getNode(), TextRange.create((int)0, (int)document.getTextLength()));
            codeFormatter.doWrapLongLinesIfNecessary(editor, element2.getProject(), document, textRange.getStartOffset(), textRange.getStartOffset() + replacementText.length() + 1, enabledRanges);
        }, null, (Object)document);
    }

    protected void appendPostfix(@NotNull PsiElement element2, @NotNull String text, @NotNull StringBuilder stringBuilder) {
        String postfix = this.getPostfix(element2);
        if (text.endsWith(postfix.trim())) {
            stringBuilder.append(postfix);
        }
    }

    protected void appendPrefix(@NotNull PsiElement element2, @NotNull String text, @NotNull StringBuilder stringBuilder) {
        String prefix = this.getPrefix(element2);
        if (text.startsWith(prefix.trim())) {
            stringBuilder.append(prefix);
        }
    }

    private TextRange getTextRange(@NotNull PsiElement element2, @NotNull Editor editor) {
        int startOffset = this.getStartOffset(element2, editor);
        int endOffset = this.getEndOffset(element2, editor);
        return new UnfairTextRange(startOffset, endOffset);
    }

    private int getStartOffset(@NotNull PsiElement element2, @NotNull Editor editor) {
        int lineNumber;
        if (this.isBunchOfElement(element2)) {
            PsiElement firstElement = this.getFirstElement(element2);
            return firstElement != null ? firstElement.getTextRange().getStartOffset() : element2.getTextRange().getStartOffset();
        }
        int offset = editor.getCaretModel().getOffset();
        int elementTextOffset = element2.getTextOffset();
        Document document = editor.getDocument();
        for (lineNumber = document.getLineNumber(offset); lineNumber != document.getLineNumber(elementTextOffset); --lineNumber) {
            String text = document.getText(TextRange.create((int)document.getLineStartOffset(lineNumber), (int)document.getLineEndOffset(lineNumber)));
            if (!StringUtil.isEmptyOrSpaces((String)text)) continue;
            ++lineNumber;
            break;
        }
        int lineStartOffset = lineNumber == document.getLineNumber(elementTextOffset) ? elementTextOffset : document.getLineStartOffset(lineNumber);
        String lineText = document.getText(TextRange.create((int)lineStartOffset, (int)document.getLineEndOffset(lineNumber)));
        int shift = StringUtil.findFirst((CharSequence)lineText, (CharFilter)CharFilter.NOT_WHITESPACE_FILTER);
        return lineStartOffset + shift;
    }

    protected boolean isBunchOfElement(PsiElement element2) {
        return element2 instanceof PsiComment;
    }

    private int getEndOffset(@NotNull PsiElement element2, @NotNull Editor editor) {
        int lineNumber;
        if (this.isBunchOfElement(element2)) {
            PsiElement next = this.getLastElement(element2);
            return next != null ? next.getTextRange().getEndOffset() : element2.getTextRange().getEndOffset();
        }
        int offset = editor.getCaretModel().getOffset();
        int elementTextOffset = element2.getTextRange().getEndOffset();
        Document document = editor.getDocument();
        for (lineNumber = document.getLineNumber(offset); lineNumber != document.getLineNumber(elementTextOffset); ++lineNumber) {
            String text = document.getText(TextRange.create((int)document.getLineStartOffset(lineNumber), (int)document.getLineEndOffset(lineNumber)));
            if (!StringUtil.isEmptyOrSpaces((String)text)) continue;
            --lineNumber;
            break;
        }
        return document.getLineEndOffset(lineNumber);
    }

    @Nullable
    private PsiElement getFirstElement(@NotNull PsiElement element2) {
        IElementType elementType = element2.getNode().getElementType();
        PsiElement result2 = element2;
        for (PsiElement prevSibling = element2.getPrevSibling(); prevSibling != null && (prevSibling.getNode().getElementType().equals(elementType) || this.atWhitespaceToken(prevSibling) && StringUtil.countChars((CharSequence)prevSibling.getText(), (char)'\n') <= 1); prevSibling = prevSibling.getPrevSibling()) {
            String text = prevSibling.getText();
            String prefix = this.getPrefix(element2);
            String postfix = this.getPostfix(element2);
            text = StringUtil.trimStart((String)text.trim(), (String)prefix.trim());
            text = StringUtil.trimEnd((String)text, (String)postfix);
            if (prevSibling.getNode().getElementType().equals(elementType) && StringUtil.isEmptyOrSpaces((String)text)) break;
            if (!prevSibling.getNode().getElementType().equals(elementType)) continue;
            result2 = prevSibling;
        }
        return result2;
    }

    @Nullable
    private PsiElement getLastElement(@NotNull PsiElement element2) {
        IElementType elementType = element2.getNode().getElementType();
        PsiElement result2 = element2;
        for (PsiElement nextSibling = element2.getNextSibling(); nextSibling != null && (nextSibling.getNode().getElementType().equals(elementType) || this.atWhitespaceToken(nextSibling) && StringUtil.countChars((CharSequence)nextSibling.getText(), (char)'\n') <= 1); nextSibling = nextSibling.getNextSibling()) {
            String text = nextSibling.getText();
            String prefix = this.getPrefix(element2);
            String postfix = this.getPostfix(element2);
            text = StringUtil.trimStart((String)text.trim(), (String)prefix.trim());
            text = StringUtil.trimEnd((String)text, (String)postfix);
            if (nextSibling.getNode().getElementType().equals(elementType) && StringUtil.isEmptyOrSpaces((String)text)) break;
            if (!nextSibling.getNode().getElementType().equals(elementType)) continue;
            result2 = nextSibling;
        }
        return result2;
    }

    protected boolean atWhitespaceToken(@Nullable PsiElement element2) {
        return element2 instanceof PsiWhiteSpace;
    }

    protected boolean isAvailableForElement(@Nullable PsiElement element2) {
        return element2 != null;
    }

    protected boolean isAvailableForFile(@Nullable PsiFile psiFile) {
        return psiFile instanceof PsiPlainTextFile;
    }

    @NotNull
    protected String getPrefix(@NotNull PsiElement element2) {
        return "";
    }

    @NotNull
    protected String getPostfix(@NotNull PsiElement element2) {
        return "";
    }
}

