/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.TabOutScopesTracker;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;

public final class TypedHandlerUtil {
    private static int computeBracesBalance(@NotNull Editor editor, int offset, @NotNull IElementType lt, @NotNull IElementType gt, @NotNull TokenSet invalidInsideReference, boolean forwardDirection) {
        HighlighterIterator iterator2 = ((EditorEx)editor).getHighlighter().createIterator(offset);
        if (!forwardDirection && iterator2.getTokenType() != gt) {
            return -1;
        }
        while ((forwardDirection && iterator2.getStart() > 0 || !forwardDirection && !iterator2.atEnd()) && !invalidInsideReference.contains(iterator2.getTokenType())) {
            TypedHandlerUtil.incLookup(!forwardDirection, iterator2);
        }
        if ((forwardDirection || !iterator2.atEnd()) && invalidInsideReference.contains(iterator2.getTokenType())) {
            TypedHandlerUtil.incLookup(forwardDirection, iterator2);
        }
        int balance = 0;
        while (!iterator2.atEnd() && balance >= 0) {
            IElementType tokenType = iterator2.getTokenType();
            if (tokenType == lt) {
                balance = forwardDirection ? ++balance : --balance;
            } else if (tokenType == gt) {
                balance = forwardDirection ? --balance : ++balance;
            } else if (invalidInsideReference.contains(tokenType)) break;
            TypedHandlerUtil.incLookup(forwardDirection, iterator2);
        }
        return balance;
    }

    private static void incLookup(boolean forwardDirection, @NotNull HighlighterIterator iterator2) {
        if (forwardDirection) {
            iterator2.advance();
        } else {
            iterator2.retreat();
        }
    }

    public static boolean isAfterClassLikeIdentifierOrDot(int offset, @NotNull Editor editor, @NotNull IElementType dot, @NotNull IElementType identifier, boolean allowAfterDot) {
        HighlighterIterator iterator2 = ((EditorEx)editor).getHighlighter().createIterator(offset);
        if (iterator2.atEnd()) {
            return false;
        }
        if (offset != iterator2.getEnd() && iterator2.getStart() > 0) {
            iterator2.retreat();
        }
        IElementType tokenType = iterator2.getTokenType();
        if (allowAfterDot && tokenType == dot) {
            return true;
        }
        return TypedHandlerUtil.isClassLikeIdentifier(offset, editor, iterator2, identifier);
    }

    public static boolean isClassLikeIdentifier(int offset, @NotNull Editor editor, @NotNull HighlighterIterator iterator2, @NotNull IElementType idType) {
        if (iterator2.getTokenType() == idType && iterator2.getEnd() == offset) {
            CharSequence chars = editor.getDocument().getCharsSequence();
            char startChar = chars.charAt(iterator2.getStart());
            if (!Character.isUpperCase(startChar)) {
                return false;
            }
            CharSequence word = chars.subSequence(iterator2.getStart(), iterator2.getEnd());
            if (word.length() == 1) {
                return true;
            }
            for (int i2 = 1; i2 < word.length(); ++i2) {
                if (!Character.isLowerCase(word.charAt(i2))) continue;
                return true;
            }
        }
        return false;
    }

    public static void handleAfterGenericLT(@NotNull Editor editor, @NotNull IElementType lt, @NotNull IElementType gt, @NotNull TokenSet invalidInsideReference) {
        if (!CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET) {
            return;
        }
        int offset = editor.getCaretModel().getOffset();
        if (TypedHandlerUtil.computeBracesBalance(editor, offset, lt, gt, invalidInsideReference, true) == 1) {
            editor.getDocument().insertString(offset, (CharSequence)">");
            TabOutScopesTracker.getInstance().registerEmptyScope(editor, offset);
        }
    }

    public static boolean handleGenericGT(@NotNull Editor editor, @NotNull IElementType lt, @NotNull IElementType gt, @NotNull TokenSet invalidInsideReference) {
        if (!CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET) {
            return false;
        }
        int offset = editor.getCaretModel().getOffset();
        if (offset == editor.getDocument().getTextLength()) {
            return false;
        }
        if (TypedHandlerUtil.computeBracesBalance(editor, offset, lt, gt, invalidInsideReference, false) != 0) {
            return false;
        }
        EditorModificationUtil.moveCaretRelatively((Editor)editor, (int)1);
        return true;
    }

    public static void handleGenericLTDeletion(@NotNull Editor editor, int offset, @NotNull IElementType lt, @NotNull IElementType gt, @NotNull TokenSet invalidInsideReference) {
        if (TypedHandlerUtil.computeBracesBalance(editor, offset, lt, gt, invalidInsideReference, true) < 0) {
            editor.getDocument().deleteString(offset, offset + 1);
        }
    }
}

