/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.quickFix;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import java.io.IOException;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

@Deprecated
public class CreateFileFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    private static final int REFRESH_INTERVAL = 1000;
    private final boolean myIsDirectory;
    private final String myNewFileName;
    private final String myText;
    @PropertyKey(resourceBundle="messages.CodeInsightBundle")
    @NotNull
    private final String myKey;
    private boolean myIsAvailable;
    private long myIsAvailableTimeStamp;

    public CreateFileFix(boolean isDirectory, @NotNull String newFileName, @NotNull PsiDirectory directory, @Nullable String text, @PropertyKey(resourceBundle="messages.CodeInsightBundle") @NotNull String key) {
        super((PsiElement)directory);
        this.myIsDirectory = isDirectory;
        this.myNewFileName = newFileName;
        this.myText = text;
        this.myKey = key;
        this.myIsAvailable = isDirectory || !FileTypeManager.getInstance().getFileTypeByFileName(newFileName).isBinary();
        this.myIsAvailableTimeStamp = System.currentTimeMillis();
    }

    public CreateFileFix(@NotNull String newFileName, @NotNull PsiDirectory directory, String text) {
        this(false, newFileName, directory, text, "create.file.text");
    }

    public CreateFileFix(boolean isDirectory, @NotNull String newFileName, @NotNull PsiDirectory directory) {
        this(isDirectory, newFileName, directory, null, isDirectory ? "create.directory.text" : "create.file.text");
    }

    @Nullable
    protected String getFileText() {
        return this.myText;
    }

    @NotNull
    public String getText() {
        return CodeInsightBundle.message((String)this.myKey, (Object[])new Object[]{this.myNewFileName});
    }

    @NotNull
    public String getFamilyName() {
        return CodeInsightBundle.message((String)"create.file.family", (Object[])new Object[0]);
    }

    @Nullable
    public PsiElement getElementToMakeWritable(@NotNull PsiFile file2) {
        return null;
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file2, Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (this.isAvailable(project, null, file2)) {
            this.invoke(project, (PsiDirectory)startElement);
        }
    }

    public void applyFix() {
        this.invoke(this.myStartElement.getProject(), (PsiDirectory)this.myStartElement.getElement());
    }

    public boolean isAvailable(@NotNull Project project, @NotNull PsiFile file2, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        PsiDirectory myDirectory = (PsiDirectory)startElement;
        long current2 = System.currentTimeMillis();
        if (ApplicationManager.getApplication().isUnitTestMode() || current2 - this.myIsAvailableTimeStamp > 1000L) {
            this.myIsAvailable &= myDirectory.getVirtualFile().findChild(this.myNewFileName) == null;
            this.myIsAvailableTimeStamp = current2;
        }
        return this.myIsAvailable;
    }

    private void invoke(@NotNull Project project, PsiDirectory myDirectory) throws IncorrectOperationException {
        block9: {
            this.myIsAvailableTimeStamp = 0L;
            try {
                if (this.myIsDirectory) {
                    myDirectory.createSubdirectory(this.myNewFileName);
                    break block9;
                }
                String newFileName = this.myNewFileName;
                String newDirectories = null;
                if (this.myNewFileName.contains("/")) {
                    int pos = this.myNewFileName.lastIndexOf(47);
                    newFileName = this.myNewFileName.substring(pos + 1);
                    newDirectories = this.myNewFileName.substring(0, pos);
                }
                PsiDirectory directory = myDirectory;
                if (newDirectories != null) {
                    try {
                        VfsUtil.createDirectoryIfMissing((VirtualFile)myDirectory.getVirtualFile(), newDirectories);
                        VirtualFile vfsDir = VfsUtil.findRelativeFile((VirtualFile)myDirectory.getVirtualFile(), (String[])ArrayUtil.toStringArray((Collection)StringUtil.split(newDirectories, (String)"/")));
                        PsiDirectory psiDirectory = directory = vfsDir == null ? null : myDirectory.getManager().findDirectory(vfsDir);
                        if (directory == null) {
                            throw new IOException("Couldn't create directory '" + newDirectories + "'");
                        }
                    }
                    catch (IOException e) {
                        throw new IncorrectOperationException(e.getMessage());
                    }
                }
                PsiFile newFile = directory.createFile(newFileName);
                String text = this.getFileText();
                if (text != null) {
                    FileType type = FileTypeRegistry.getInstance().getFileTypeByFileName(newFileName);
                    PsiFile psiFile = PsiFileFactory.getInstance((Project)project).createFileFromText("_" + newFileName, type, (CharSequence)text);
                    PsiElement psiElement = CodeStyleManager.getInstance((Project)project).reformat((PsiElement)psiFile);
                    text = psiElement.getText();
                }
                this.openFile(project, directory, newFile, text);
            }
            catch (IncorrectOperationException e) {
                this.myIsAvailable = false;
            }
        }
    }

    protected void openFile(@NotNull Project project, PsiDirectory directory, PsiFile newFile, String text) {
        FileEditorManager editorManager = FileEditorManager.getInstance((Project)directory.getProject());
        FileEditor[] fileEditors = editorManager.openFile(newFile.getVirtualFile(), true);
        if (text != null) {
            for (FileEditor fileEditor : fileEditors) {
                if (!(fileEditor instanceof TextEditor)) continue;
                Document document = ((TextEditor)fileEditor).getEditor().getDocument();
                document.setText((CharSequence)text);
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    FileDocumentManager.getInstance().saveDocument(document);
                }
                PsiDocumentManager.getInstance((Project)project).commitDocument(document);
                break;
            }
        }
    }
}

