/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.actions;

import com.intellij.analysis.AnalysisBundle;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.codeInspection.SuppressionUtil;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import java.awt.Component;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated
public abstract class AbstractSuppressByNoInspectionCommentFix
extends SuppressIntentionAction {
    @NotNull
    protected final String myID;
    private final boolean myReplaceOtherSuppressionIds;

    @Nullable
    protected abstract PsiElement getContainer(PsiElement var1);

    public AbstractSuppressByNoInspectionCommentFix(@NotNull String ID2, boolean replaceOtherSuppressionIds) {
        this.myID = ID2;
        this.myReplaceOtherSuppressionIds = replaceOtherSuppressionIds;
    }

    protected final void replaceSuppressionComment(@NotNull PsiElement comment) {
        SuppressionUtil.replaceSuppressionComment(comment, this.myID, this.myReplaceOtherSuppressionIds, this.getCommentLanguage(comment));
    }

    protected void createSuppression(@NotNull Project project, @NotNull PsiElement element2, @NotNull PsiElement container2) throws IncorrectOperationException {
        SuppressionUtil.createSuppression(project, container2, this.myID, this.getCommentLanguage(element2));
    }

    @NotNull
    protected Language getCommentLanguage(@NotNull PsiElement element2) {
        return element2.getLanguage();
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement context) {
        return context.isValid() && BaseIntentionAction.canModify((PsiElement)context) && this.getContainer(context) != null;
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull PsiElement element2) throws IncorrectOperationException {
        boolean caretWasBeforeStatement;
        PsiElement container2;
        block6: {
            container2 = this.getContainer(element2);
            if (container2 == null) {
                return;
            }
            List<? extends PsiElement> comments = this.getCommentsFor(container2);
            if (comments != null) {
                for (PsiElement psiElement : comments) {
                    if (!(psiElement instanceof PsiComment) || !SuppressionUtil.isSuppressionComment(psiElement)) continue;
                    this.replaceSuppressionComment(psiElement);
                    return;
                }
            }
            caretWasBeforeStatement = editor != null && editor.getCaretModel().getOffset() == container2.getTextRange().getStartOffset();
            try {
                this.createSuppression(project, element2, container2);
            }
            catch (IncorrectOperationException incorrectOperationException) {
                if (ApplicationManager.getApplication().isUnitTestMode() || editor == null) break block6;
                Messages.showErrorDialog((Component)editor.getComponent(), (String)InspectionsBundle.message((String)"suppress.inspection.annotation.syntax.error", (Object[])new Object[]{incorrectOperationException.getMessage()}));
            }
        }
        if (caretWasBeforeStatement) {
            editor.getCaretModel().moveToOffset(container2.getTextRange().getStartOffset());
        }
        UndoUtil.markPsiFileForUndo((PsiFile)element2.getContainingFile());
    }

    @Nullable
    protected List<? extends PsiElement> getCommentsFor(@NotNull PsiElement container2) {
        PsiElement prev = PsiTreeUtil.skipWhitespacesBackward((PsiElement)container2);
        if (prev == null) {
            return null;
        }
        return Collections.singletonList(prev);
    }

    @NotNull
    public String getFamilyName() {
        return AnalysisBundle.message((String)"suppress.inspection.family", (Object[])new Object[0]);
    }
}

