/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.GutterMark;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoPostFilter;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.HighlightersRecycler;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.impl.RedBlackTree;
import com.intellij.openapi.editor.impl.SweepProcessor;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class UpdateHighlightersUtil {
    private static final ExtensionPointName<HighlightInfoPostFilter> EP_NAME = ExtensionPointName.create((String)"com.intellij.highlightInfoPostFilter");
    private static final Comparator<HighlightInfo> BY_START_OFFSET_NODUPS = (o1, o2) -> {
        int d = o1.getActualStartOffset() - o2.getActualStartOffset();
        if (d != 0) {
            return d;
        }
        d = o1.getActualEndOffset() - o2.getActualEndOffset();
        if (d != 0) {
            return d;
        }
        d = Comparing.compare((Comparable)o1.getSeverity(), (Comparable)o2.getSeverity());
        if (d != 0) {
            return -d;
        }
        if (!Comparing.equal((Object)o1.type, (Object)o2.type)) {
            return String.valueOf(o1.type).compareTo(String.valueOf(o2.type));
        }
        if (!Comparing.equal((Object)o1.getGutterIconRenderer(), (Object)o2.getGutterIconRenderer())) {
            return String.valueOf(o1.getGutterIconRenderer()).compareTo(String.valueOf(o2.getGutterIconRenderer()));
        }
        if (!Comparing.equal((Object)o1.forcedTextAttributes, (Object)o2.forcedTextAttributes)) {
            return String.valueOf(o1.getGutterIconRenderer()).compareTo(String.valueOf(o2.getGutterIconRenderer()));
        }
        if (!Comparing.equal((Object)o1.forcedTextAttributesKey, (Object)o2.forcedTextAttributesKey)) {
            return String.valueOf(o1.getGutterIconRenderer()).compareTo(String.valueOf(o2.getGutterIconRenderer()));
        }
        return Comparing.compare((Comparable)((Object)o1.getDescription()), (Comparable)((Object)o2.getDescription()));
    };
    private static final Key<Boolean> TYPING_INSIDE_HIGHLIGHTER_OCCURRED = Key.create((String)"TYPING_INSIDE_HIGHLIGHTER_OCCURRED");

    private static boolean isCoveredByOffsets(@NotNull HighlightInfo info, @NotNull HighlightInfo coveredBy) {
        return coveredBy.startOffset <= info.startOffset && info.endOffset <= coveredBy.endOffset && info.getGutterIconRenderer() == null;
    }

    static void addHighlighterToEditorIncrementally(@NotNull Project project, @NotNull Document document, @NotNull PsiFile file2, int startOffset, int endOffset, @NotNull HighlightInfo info, @Nullable EditorColorsScheme colorsScheme, int group, @NotNull Map<TextRange, RangeMarker> ranges2markersCache) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (!UpdateHighlightersUtil.accept(project, info)) {
            return;
        }
        if (UpdateHighlightersUtil.isFileLevelOrGutterAnnotation(info)) {
            return;
        }
        if (info.getStartOffset() < startOffset || info.getEndOffset() > endOffset) {
            return;
        }
        MarkupModel markup = DocumentMarkupModel.forDocument(document, project, true);
        SeverityRegistrar severityRegistrar = SeverityRegistrar.getSeverityRegistrar(project);
        boolean myInfoIsError = UpdateHighlightersUtil.isSevere(info, severityRegistrar);
        Processor otherHighlightInTheWayProcessor = oldInfo -> {
            if (!myInfoIsError && UpdateHighlightersUtil.isCovered(info, severityRegistrar, oldInfo)) {
                return false;
            }
            return oldInfo.getGroup() != group || !oldInfo.equalsByActualOffset(info);
        };
        boolean allIsClear = DaemonCodeAnalyzerEx.processHighlights(document, project, null, info.getActualStartOffset(), info.getActualEndOffset(), (Processor<? super HighlightInfo>)otherHighlightInTheWayProcessor);
        if (allIsClear) {
            UpdateHighlightersUtil.createOrReuseHighlighterFor(info, colorsScheme, document, group, file2, (MarkupModelEx)markup, null, ranges2markersCache, severityRegistrar);
            UpdateHighlightersUtil.clearWhiteSpaceOptimizationFlag(document);
            UpdateHighlightersUtil.assertMarkupConsistent(markup, project);
        }
    }

    private static boolean accept(@NotNull Project project, @NotNull HighlightInfo info) {
        for (HighlightInfoPostFilter filter2 : (HighlightInfoPostFilter[])EP_NAME.getExtensions((AreaInstance)project)) {
            if (filter2.accept(info)) continue;
            return false;
        }
        return true;
    }

    public static boolean isFileLevelOrGutterAnnotation(@NotNull HighlightInfo info) {
        return info.isFileLevelAnnotation() || info.getGutterIconRenderer() != null;
    }

    public static void setHighlightersToSingleEditor(@NotNull Project project, @NotNull Editor editor, int startOffset, int endOffset, @NotNull Collection<? extends HighlightInfo> highlights, @Nullable EditorColorsScheme colorsScheme, int group) {
        Document document = editor.getDocument();
        MarkupModelEx markup = (MarkupModelEx)editor.getMarkupModel();
        UpdateHighlightersUtil.setHighlightersToEditor(project, document, startOffset, endOffset, highlights, colorsScheme, group, markup);
    }

    public static void setHighlightersToEditor(@NotNull Project project, @NotNull Document document, int startOffset, int endOffset, @NotNull Collection<? extends HighlightInfo> highlights, @Nullable EditorColorsScheme colorsScheme, int group) {
        MarkupModelEx markup = (MarkupModelEx)DocumentMarkupModel.forDocument(document, project, true);
        UpdateHighlightersUtil.setHighlightersToEditor(project, document, startOffset, endOffset, highlights, colorsScheme, group, markup);
    }

    private static void setHighlightersToEditor(@NotNull Project project, @NotNull Document document, int startOffset, int endOffset, @NotNull Collection<? extends HighlightInfo> highlights, @Nullable EditorColorsScheme colorsScheme, int group, @NotNull MarkupModelEx markup) {
        TextRange range2 = new TextRange(startOffset, endOffset);
        ApplicationManager.getApplication().assertIsDispatchThread();
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
        DaemonCodeAnalyzerEx codeAnalyzer = DaemonCodeAnalyzerEx.getInstanceEx(project);
        codeAnalyzer.cleanFileLevelHighlights(project, group, psiFile);
        UpdateHighlightersUtil.assertMarkupConsistent(markup, project);
        UpdateHighlightersUtil.setHighlightersInRange(project, document, range2, colorsScheme, new ArrayList<HighlightInfo>(highlights), markup, group);
    }

    @NotNull
    private static List<HighlightInfo> applyPostFilter(@NotNull Project project, @NotNull List<? extends HighlightInfo> highlightInfos) {
        ArrayList<HighlightInfo> result2 = new ArrayList<HighlightInfo>(highlightInfos.size());
        for (HighlightInfo highlightInfo : highlightInfos) {
            if (!UpdateHighlightersUtil.accept(project, highlightInfo)) continue;
            result2.add(highlightInfo);
        }
        return result2;
    }

    static void setHighlightersOutsideRange(@NotNull Project project, @NotNull Document document, @NotNull PsiFile psiFile, @NotNull List<? extends HighlightInfo> infos, @Nullable EditorColorsScheme colorsScheme, int startOffset, int endOffset, @NotNull ProperTextRange priorityRange, int group) {
        List<HighlightInfo> filteredInfos = UpdateHighlightersUtil.applyPostFilter(project, infos);
        ApplicationManager.getApplication().assertIsDispatchThread();
        DaemonCodeAnalyzerEx codeAnalyzer = DaemonCodeAnalyzerEx.getInstanceEx(project);
        if (startOffset == 0 && endOffset == document.getTextLength()) {
            codeAnalyzer.cleanFileLevelHighlights(project, group, psiFile);
        }
        MarkupModel markup = DocumentMarkupModel.forDocument(document, project, true);
        UpdateHighlightersUtil.assertMarkupConsistent(markup, project);
        SeverityRegistrar severityRegistrar = SeverityRegistrar.getSeverityRegistrar(project);
        HighlightersRecycler infosToRemove = new HighlightersRecycler();
        ContainerUtil.quickSort(filteredInfos, BY_START_OFFSET_NODUPS);
        THashSet infoSet = new THashSet(filteredInfos);
        Processor processor2 = arg_0 -> UpdateHighlightersUtil.lambda$setHighlightersOutsideRange$2(group, document, startOffset, endOffset, (Set)infoSet, priorityRange, infosToRemove, arg_0);
        DaemonCodeAnalyzerEx.processHighlightsOverlappingOutside(document, project, null, priorityRange.getStartOffset(), priorityRange.getEndOffset(), (Processor<? super HighlightInfo>)processor2);
        THashMap ranges2markersCache = new THashMap(10);
        boolean[] changed2 = new boolean[]{false};
        SweepProcessor.Generator generator = proc -> ContainerUtil.process((List)filteredInfos, (Processor)proc);
        SweepProcessor.sweep(generator, (arg_0, arg_1, arg_2, arg_3) -> UpdateHighlightersUtil.lambda$setHighlightersOutsideRange$4(document, startOffset, endOffset, codeAnalyzer, project, group, psiFile, changed2, severityRegistrar, priorityRange, colorsScheme, markup, infosToRemove, (Map)ranges2markersCache, arg_0, arg_1, arg_2, arg_3));
        for (RangeHighlighter rangeHighlighter : infosToRemove.forAllInGarbageBin()) {
            rangeHighlighter.dispose();
            changed2[0] = true;
        }
        if (changed2[0]) {
            UpdateHighlightersUtil.clearWhiteSpaceOptimizationFlag(document);
        }
        UpdateHighlightersUtil.assertMarkupConsistent(markup, project);
    }

    static void setHighlightersInRange(@NotNull Project project, @NotNull Document document, @NotNull TextRange range2, @Nullable EditorColorsScheme colorsScheme, @NotNull List<? extends HighlightInfo> infos, @NotNull MarkupModelEx markup, int group) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        SeverityRegistrar severityRegistrar = SeverityRegistrar.getSeverityRegistrar(project);
        HighlightersRecycler infosToRemove = new HighlightersRecycler();
        DaemonCodeAnalyzerEx.processHighlights(markup, project, null, range2.getStartOffset(), range2.getEndOffset(), (Processor<? super HighlightInfo>)((Processor)info -> {
            if (info.getGroup() == group) {
                boolean willBeRemoved;
                RangeHighlighterEx highlighter = info.getHighlighter();
                int hiStart = highlighter.getStartOffset();
                int hiEnd = highlighter.getEndOffset();
                boolean bl = willBeRemoved = hiEnd == document.getTextLength() && range2.getEndOffset() == document.getTextLength() || range2.containsRange(hiStart, hiEnd);
                if (willBeRemoved) {
                    infosToRemove.recycleHighlighter(highlighter);
                    info.setHighlighter(null);
                }
            }
            return true;
        }));
        List<HighlightInfo> filteredInfos = UpdateHighlightersUtil.applyPostFilter(project, infos);
        ContainerUtil.quickSort(filteredInfos, BY_START_OFFSET_NODUPS);
        THashMap ranges2markersCache = new THashMap(10);
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
        DaemonCodeAnalyzerEx codeAnalyzer = DaemonCodeAnalyzerEx.getInstanceEx(project);
        boolean[] changed2 = new boolean[]{false};
        SweepProcessor.Generator generator = processor2 -> ContainerUtil.process((List)filteredInfos, (Processor)processor2);
        SweepProcessor.sweep(generator, (arg_0, arg_1, arg_2, arg_3) -> UpdateHighlightersUtil.lambda$setHighlightersInRange$7(psiFile, codeAnalyzer, project, group, changed2, severityRegistrar, range2, colorsScheme, document, markup, infosToRemove, (Map)ranges2markersCache, arg_0, arg_1, arg_2, arg_3));
        for (RangeHighlighter rangeHighlighter : infosToRemove.forAllInGarbageBin()) {
            rangeHighlighter.dispose();
            changed2[0] = true;
        }
        if (changed2[0]) {
            UpdateHighlightersUtil.clearWhiteSpaceOptimizationFlag(document);
        }
        UpdateHighlightersUtil.assertMarkupConsistent(markup, project);
    }

    private static boolean isWarningCoveredByError(@NotNull HighlightInfo info, @NotNull Collection<? extends HighlightInfo> overlappingIntervals, @NotNull SeverityRegistrar severityRegistrar) {
        if (!UpdateHighlightersUtil.isSevere(info, severityRegistrar)) {
            for (HighlightInfo highlightInfo : overlappingIntervals) {
                if (!UpdateHighlightersUtil.isCovered(info, severityRegistrar, highlightInfo)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isCovered(@NotNull HighlightInfo warning, @NotNull SeverityRegistrar severityRegistrar, @NotNull HighlightInfo candidate) {
        if (!UpdateHighlightersUtil.isCoveredByOffsets(warning, candidate)) {
            return false;
        }
        HighlightSeverity severity = candidate.getSeverity();
        if (severity == HighlightInfoType.SYMBOL_TYPE_SEVERITY) {
            return false;
        }
        return UpdateHighlightersUtil.isSevere(candidate, severityRegistrar);
    }

    private static boolean isSevere(@NotNull HighlightInfo info, @NotNull SeverityRegistrar severityRegistrar) {
        HighlightSeverity severity = info.getSeverity();
        return severityRegistrar.compare(HighlightSeverity.ERROR, severity) <= 0 || severity == HighlightInfoType.SYMBOL_TYPE_SEVERITY;
    }

    private static void createOrReuseHighlighterFor(@NotNull HighlightInfo info, @Nullable EditorColorsScheme colorsScheme, @NotNull Document document, int group, @NotNull PsiFile psiFile, @NotNull MarkupModelEx markup, @Nullable HighlightersRecycler infosToRemove, @NotNull Map<TextRange, RangeMarker> ranges2markersCache, @NotNull SeverityRegistrar severityRegistrar) {
        int infoStartOffset = info.startOffset;
        int infoEndOffset = info.endOffset;
        int docLength = document.getTextLength();
        if (infoEndOffset > docLength) {
            infoEndOffset = docLength;
            infoStartOffset = Math.min(infoStartOffset, infoEndOffset);
        }
        if (infoEndOffset == infoStartOffset && !info.isAfterEndOfLine()) {
            if (infoEndOffset == docLength) {
                return;
            }
            ++infoEndOffset;
        }
        info.setGroup(group);
        int layer = UpdateHighlightersUtil.getLayer(info, severityRegistrar);
        RangeHighlighterEx highlighter = infosToRemove == null ? null : (RangeHighlighterEx)infosToRemove.pickupHighlighterFromGarbageBin(infoStartOffset, infoEndOffset, layer);
        TextRange finalInfoRange = new TextRange(infoStartOffset, infoEndOffset);
        TextAttributes infoAttributes = info.getTextAttributes((PsiElement)psiFile, colorsScheme);
        Consumer changeAttributes = finalHighlighter -> {
            ProperTextRange fixRange;
            Color attributesErrorStripeColor;
            TextAttributesKey textAttributesKey = info.forcedTextAttributesKey == null ? info.type.getAttributesKey() : info.forcedTextAttributesKey;
            finalHighlighter.setTextAttributesKey(textAttributesKey);
            if (infoAttributes != null && !infoAttributes.equals((Object)finalHighlighter.getTextAttributes(colorsScheme)) || infoAttributes == TextAttributes.ERASE_MARKER) {
                finalHighlighter.setTextAttributes(infoAttributes);
            }
            info.setHighlighter((RangeHighlighterEx)finalHighlighter);
            finalHighlighter.setAfterEndOfLine(info.isAfterEndOfLine());
            Color infoErrorStripeColor = info.getErrorStripeMarkColor((PsiElement)psiFile, colorsScheme);
            TextAttributes attributes = finalHighlighter.getTextAttributes(colorsScheme);
            Color color = attributesErrorStripeColor = attributes != null ? attributes.getErrorStripeColor() : null;
            if (infoErrorStripeColor != null && !infoErrorStripeColor.equals(attributesErrorStripeColor)) {
                finalHighlighter.setErrorStripeMarkColor(infoErrorStripeColor);
            }
            if (info != finalHighlighter.getErrorStripeTooltip()) {
                finalHighlighter.setErrorStripeTooltip(info);
            }
            GutterMark renderer = info.getGutterIconRenderer();
            finalHighlighter.setGutterIconRenderer((GutterIconRenderer)renderer);
            ranges2markersCache.put(finalInfoRange, info.getHighlighter());
            if (info.quickFixActionRanges != null) {
                ArrayList<Pair> list2 = new ArrayList<Pair>(info.quickFixActionRanges.size());
                for (Pair<HighlightInfo.IntentionActionDescriptor, TextRange> pair : info.quickFixActionRanges) {
                    TextRange textRange = (TextRange)pair.second;
                    RangeMarker marker = UpdateHighlightersUtil.getOrCreate(document, ranges2markersCache, textRange);
                    list2.add(Pair.create((Object)pair.first, (Object)marker));
                }
                info.quickFixActionMarkers = ContainerUtil.createLockFreeCopyOnWriteList(list2);
            }
            info.fixMarker = finalInfoRange.equals((Object)(fixRange = info.getFixTextRange())) ? null : UpdateHighlightersUtil.getOrCreate(document, ranges2markersCache, (TextRange)fixRange);
        };
        if (highlighter == null) {
            highlighter = markup.addRangeHighlighterAndChangeAttributes(null, infoStartOffset, infoEndOffset, layer, HighlighterTargetArea.EXACT_RANGE, false, (Consumer<? super RangeHighlighterEx>)changeAttributes);
            if (HighlightInfoType.VISIBLE_IF_FOLDED.contains(info.type)) {
                highlighter.setVisibleIfFolded(true);
            }
        } else {
            markup.changeAttributesInBatch(highlighter, (Consumer<? super RangeHighlighterEx>)changeAttributes);
        }
        if (infoAttributes != null) {
            boolean attributesSet = Comparing.equal((Object)infoAttributes, (Object)highlighter.getTextAttributes(colorsScheme));
            assert (attributesSet) : "Info: " + infoAttributes + "; colorsScheme: " + (colorsScheme == null ? "[global]" : colorsScheme.getName()) + "; highlighter:" + highlighter.getTextAttributes(colorsScheme);
        }
    }

    private static int getLayer(@NotNull HighlightInfo info, @NotNull SeverityRegistrar severityRegistrar) {
        HighlightSeverity severity = info.getSeverity();
        int layer = severity == HighlightSeverity.WARNING ? 4000 : (severity == HighlightSeverity.WEAK_WARNING ? 3750 : (severityRegistrar.compare(severity, HighlightSeverity.ERROR) >= 0 ? 5000 : (severity == HighlightInfoType.INJECTED_FRAGMENT_SEVERITY || severity == HighlightInfoType.HIGHLIGHTED_REFERENCE_SEVERITY ? 1999 : (severity == HighlightInfoType.INJECTED_FRAGMENT_SYNTAX_SEVERITY ? 1998 : (severity == HighlightInfoType.ELEMENT_UNDER_CARET_SEVERITY ? 5500 : 3000)))));
        return layer;
    }

    @NotNull
    private static RangeMarker getOrCreate(@NotNull Document document, @NotNull Map<TextRange, RangeMarker> ranges2markersCache, @NotNull TextRange textRange) {
        return ranges2markersCache.computeIfAbsent(textRange, __ -> document.createRangeMarker(textRange));
    }

    static boolean isWhitespaceOptimizationAllowed(@NotNull Document document) {
        return document.getUserData(TYPING_INSIDE_HIGHLIGHTER_OCCURRED) == null;
    }

    private static void disableWhiteSpaceOptimization(@NotNull Document document) {
        document.putUserData(TYPING_INSIDE_HIGHLIGHTER_OCCURRED, (Object)Boolean.TRUE);
    }

    private static void clearWhiteSpaceOptimizationFlag(@NotNull Document document) {
        document.putUserData(TYPING_INSIDE_HIGHLIGHTER_OCCURRED, null);
    }

    static void updateHighlightersByTyping(@NotNull Project project, @NotNull DocumentEvent e) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        Document document = e.getDocument();
        if (document.isInBulkUpdate()) {
            return;
        }
        MarkupModel markup = DocumentMarkupModel.forDocument(document, project, true);
        UpdateHighlightersUtil.assertMarkupConsistent(markup, project);
        int start2 = e.getOffset() - 1;
        int end = start2 + e.getOldLength();
        ArrayList toRemove2 = new ArrayList();
        DaemonCodeAnalyzerEx.processHighlights(document, project, null, start2, end, (Processor<? super HighlightInfo>)((Processor)info -> {
            if (!info.needUpdateOnTyping()) {
                return true;
            }
            RangeHighlighterEx highlighter = info.getHighlighter();
            int highlighterStart = highlighter.getStartOffset();
            int highlighterEnd = highlighter.getEndOffset();
            if (info.isAfterEndOfLine()) {
                if (highlighterStart < document.getTextLength()) {
                    ++highlighterStart;
                }
                if (highlighterEnd < document.getTextLength()) {
                    ++highlighterEnd;
                }
            }
            if (!highlighter.isValid() || start2 < highlighterEnd && highlighterStart <= end) {
                toRemove2.add(info);
            }
            return true;
        }));
        for (HighlightInfo info2 : toRemove2) {
            if (info2.getHighlighter().isValid() && !info2.type.equals(HighlightInfoType.WRONG_REF)) continue;
            info2.getHighlighter().dispose();
        }
        UpdateHighlightersUtil.assertMarkupConsistent(markup, project);
        if (!toRemove2.isEmpty()) {
            UpdateHighlightersUtil.disableWhiteSpaceOptimization(document);
        }
    }

    private static void assertMarkupConsistent(@NotNull MarkupModel markup, @NotNull Project project) {
        RangeHighlighter[] allHighlighters;
        if (!RedBlackTree.VERIFY) {
            return;
        }
        Document document = markup.getDocument();
        DaemonCodeAnalyzerEx.processHighlights(document, project, null, 0, document.getTextLength(), (Processor<? super HighlightInfo>)((Processor)info -> {
            assert (((MarkupModelEx)markup).containsHighlighter(info.getHighlighter()));
            return true;
        }));
        for (RangeHighlighter highlighter : allHighlighters = markup.getAllHighlighters()) {
            boolean contains;
            HighlightInfo info2;
            if (!highlighter.isValid() || (info2 = HighlightInfo.fromRangeHighlighter(highlighter)) == null) continue;
            boolean bl = contains = !DaemonCodeAnalyzerEx.processHighlights(document, project, null, info2.getActualStartOffset(), info2.getActualEndOffset(), (Processor<? super HighlightInfo>)((Processor)highlightInfo -> BY_START_OFFSET_NODUPS.compare((HighlightInfo)highlightInfo, info2) != 0));
            assert (contains) : info2;
        }
    }

    private static /* synthetic */ boolean lambda$setHighlightersInRange$7(PsiFile psiFile, DaemonCodeAnalyzerEx codeAnalyzer, Project project, int group, boolean[] changed2, SeverityRegistrar severityRegistrar, TextRange range2, EditorColorsScheme colorsScheme, Document document, MarkupModelEx markup, HighlightersRecycler infosToRemove, Map ranges2markersCache, int offset, HighlightInfo info, boolean atStart, Collection overlappingIntervals) {
        if (!atStart) {
            return true;
        }
        if (info.isFileLevelAnnotation() && psiFile != null) {
            codeAnalyzer.addFileLevelHighlight(project, group, info, psiFile);
            changed2[0] = true;
            return true;
        }
        if (UpdateHighlightersUtil.isWarningCoveredByError(info, overlappingIntervals, severityRegistrar)) {
            return true;
        }
        if (info.getStartOffset() >= range2.getStartOffset() && info.getEndOffset() <= range2.getEndOffset() && psiFile != null) {
            UpdateHighlightersUtil.createOrReuseHighlighterFor(info, colorsScheme, document, group, psiFile, markup, infosToRemove, ranges2markersCache, severityRegistrar);
            changed2[0] = true;
        }
        return true;
    }

    private static /* synthetic */ boolean lambda$setHighlightersOutsideRange$4(Document document, int startOffset, int endOffset, DaemonCodeAnalyzerEx codeAnalyzer, Project project, int group, PsiFile psiFile, boolean[] changed2, SeverityRegistrar severityRegistrar, ProperTextRange priorityRange, EditorColorsScheme colorsScheme, MarkupModel markup, HighlightersRecycler infosToRemove, Map ranges2markersCache, int offset, HighlightInfo info, boolean atStart, Collection overlappingIntervals) {
        if (!atStart) {
            return true;
        }
        if (!(info.isFromInjection() || info.getEndOffset() >= document.getTextLength() || info.getEndOffset() > startOffset && info.getStartOffset() < endOffset)) {
            return true;
        }
        if (info.isFileLevelAnnotation()) {
            codeAnalyzer.addFileLevelHighlight(project, group, info, psiFile);
            changed2[0] = true;
            return true;
        }
        if (UpdateHighlightersUtil.isWarningCoveredByError(info, overlappingIntervals, severityRegistrar)) {
            return true;
        }
        if (info.getStartOffset() < priorityRange.getStartOffset() || info.getEndOffset() > priorityRange.getEndOffset()) {
            UpdateHighlightersUtil.createOrReuseHighlighterFor(info, colorsScheme, document, group, psiFile, (MarkupModelEx)markup, infosToRemove, ranges2markersCache, severityRegistrar);
            changed2[0] = true;
        }
        return true;
    }

    private static /* synthetic */ boolean lambda$setHighlightersOutsideRange$2(int group, Document document, int startOffset, int endOffset, Set infoSet, ProperTextRange priorityRange, HighlightersRecycler infosToRemove, HighlightInfo info) {
        if (info.getGroup() == group) {
            boolean toRemove2;
            RangeHighlighterEx highlighter = info.getHighlighter();
            int hiStart = highlighter.getStartOffset();
            int hiEnd = highlighter.getEndOffset();
            if (!info.isFromInjection() && hiEnd < document.getTextLength() && (hiEnd != 0 && hiEnd <= startOffset || hiStart >= endOffset)) {
                return true;
            }
            boolean bl = toRemove2 = infoSet.contains(info) || !priorityRange.containsRange(hiStart, hiEnd) && (hiEnd != document.getTextLength() || priorityRange.getEndOffset() != document.getTextLength());
            if (toRemove2) {
                infosToRemove.recycleHighlighter(highlighter);
                info.setHighlighter(null);
            }
        }
        return true;
    }
}

