/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.daemon.impl.TrafficLightRenderer;
import com.intellij.codeInsight.daemon.impl.TrafficProgressPanel;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.LineTooltipRenderer;
import com.intellij.codeInsight.hint.TooltipGroup;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorMarkupModelImpl;
import com.intellij.openapi.editor.impl.TrafficTooltipRenderer;
import com.intellij.ui.HintHint;
import com.intellij.ui.HintListener;
import com.intellij.ui.LightweightHint;
import com.intellij.util.ui.update.ComparableObject;
import java.awt.Point;
import java.util.EventObject;
import org.jetbrains.annotations.NotNull;

class TrafficTooltipRendererImpl
extends ComparableObject.Impl
implements TrafficTooltipRenderer {
    private TrafficProgressPanel myPanel;
    private final Runnable onHide;
    private TrafficLightRenderer myTrafficLightRenderer;

    TrafficTooltipRendererImpl(@NotNull Runnable onHide, @NotNull Editor editor) {
        super(new Object[]{editor});
        this.onHide = onHide;
    }

    @Override
    public void repaintTooltipWindow() {
        if (this.myPanel != null) {
            SeverityRegistrar severityRegistrar = this.myTrafficLightRenderer.getSeverityRegistrar();
            TrafficLightRenderer.DaemonCodeAnalyzerStatus status = this.myTrafficLightRenderer.getDaemonCodeAnalyzerStatus(severityRegistrar);
            this.myPanel.updatePanel(status, false);
        }
    }

    @Override
    public LightweightHint show(@NotNull Editor editor, @NotNull Point p, boolean alignToRight, @NotNull TooltipGroup group, @NotNull HintHint hintHint) {
        this.myTrafficLightRenderer = (TrafficLightRenderer)((EditorMarkupModelImpl)editor.getMarkupModel()).getErrorStripeRenderer();
        this.myPanel = new TrafficProgressPanel(this.myTrafficLightRenderer, editor, hintHint);
        this.repaintTooltipWindow();
        LineTooltipRenderer.correctLocation(editor, this.myPanel, p, alignToRight, true, this.myPanel.getMinWidth());
        LightweightHint hint = new LightweightHint(this.myPanel);
        HintManagerImpl hintManager = (HintManagerImpl)HintManager.getInstance();
        hintManager.showEditorHint(hint, editor, p, 58, 0, false, hintHint);
        hint.addHintListener(new HintListener(){

            @Override
            public void hintHidden(@NotNull EventObject event) {
                if (TrafficTooltipRendererImpl.this.myPanel == null) {
                    return;
                }
                TrafficTooltipRendererImpl.this.myPanel = null;
                TrafficTooltipRendererImpl.this.onHide.run();
            }
        });
        return hint;
    }
}

