/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.impl.TextEditorHighlightingPassRegistrarEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiCompiledFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.PsiFileEx;
import com.intellij.util.ArrayUtilRt;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextEditorBackgroundHighlighter
implements BackgroundEditorHighlighter {
    private static final Logger LOG = Logger.getInstance(TextEditorBackgroundHighlighter.class);
    private static final int[] IGNORE_FOR_COMPILED = new int[]{1, 3, 7, 12, 8};
    private final Project myProject;
    private final Editor myEditor;
    private final Document myDocument;

    public TextEditorBackgroundHighlighter(@NotNull Project project, @NotNull Editor editor) {
        this.myProject = project;
        this.myEditor = editor;
        this.myDocument = this.myEditor.getDocument();
    }

    @Nullable
    private PsiFile renewFile() {
        PsiFile file2 = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(this.myDocument);
        if (file2 != null) {
            file2.putUserData(PsiFileEx.BATCH_REFERENCE_PROCESSING, (Object)Boolean.TRUE);
        }
        return file2;
    }

    @NotNull
    List<TextEditorHighlightingPass> getPasses(int @NotNull [] passesToIgnore) {
        if (this.myProject.isDisposed()) {
            return Collections.emptyList();
        }
        LOG.assertTrue(PsiDocumentManager.getInstance((Project)this.myProject).isCommitted(this.myDocument));
        PsiFile file2 = this.renewFile();
        if (file2 == null) {
            return Collections.emptyList();
        }
        boolean compiled = file2 instanceof PsiCompiledFile;
        if (compiled) {
            file2 = ((PsiCompiledFile)file2).getDecompiledPsiFile();
            passesToIgnore = IGNORE_FOR_COMPILED;
        } else if (!DaemonCodeAnalyzer.getInstance((Project)this.myProject).isHighlightingAvailable(file2)) {
            return Collections.emptyList();
        }
        TextEditorHighlightingPassRegistrarEx passRegistrar = TextEditorHighlightingPassRegistrarEx.getInstanceEx(this.myProject);
        return passRegistrar.instantiatePasses(file2, this.myEditor, passesToIgnore);
    }

    public TextEditorHighlightingPass @NotNull [] createPassesForEditor() {
        List<TextEditorHighlightingPass> passes = this.getPasses(ArrayUtilRt.EMPTY_INT_ARRAY);
        return passes.isEmpty() ? TextEditorHighlightingPass.EMPTY_ARRAY : passes.toArray(TextEditorHighlightingPass.EMPTY_ARRAY);
    }
}

