/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl;
import com.intellij.codeInsight.daemon.impl.EditorNotificationActions;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.IntentionActionFilter;
import com.intellij.codeInsight.daemon.impl.IntentionMenuContributor;
import com.intellij.codeInsight.daemon.impl.IntentionsUI;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.IntentionManager;
import com.intellij.codeInsight.intention.impl.CachedIntentions;
import com.intellij.codeInsight.intention.impl.EditIntentionSettingsAction;
import com.intellij.codeInsight.intention.impl.EnableDisableIntentionAction;
import com.intellij.codeInsight.intention.impl.ShowIntentionActionsHandler;
import com.intellij.codeInsight.intention.impl.preview.IntentionPreviewUnsupportedOperationException;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorActivityManager;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Segment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.CommonProcessors;
import com.intellij.util.PairProcessor;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ShowIntentionsPass
extends TextEditorHighlightingPass {
    private final Editor myEditor;
    private final PsiFile myFile;
    private final int myPassIdToShowIntentionsFor;
    private final IntentionsInfo myIntentionsInfo = new IntentionsInfo();
    private final boolean myQueryIntentionActions;
    private volatile CachedIntentions myCachedIntentions;
    private volatile boolean myActionsChanged;

    ShowIntentionsPass(@NotNull Project project, @NotNull Editor editor, boolean queryIntentionActions) {
        super(project, editor.getDocument(), false);
        this.myQueryIntentionActions = queryIntentionActions;
        this.myPassIdToShowIntentionsFor = -1;
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myEditor = editor;
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
        this.myFile = documentManager.getPsiFile(this.myEditor.getDocument());
        assert (this.myFile != null) : FileDocumentManager.getInstance().getFile(this.myEditor.getDocument());
    }

    @NotNull
    public static List<HighlightInfo.IntentionActionDescriptor> getAvailableFixes(@NotNull Editor editor, @NotNull PsiFile file2, int passId, int offset) {
        Project project = file2.getProject();
        ArrayList<HighlightInfo.IntentionActionDescriptor> result2 = new ArrayList<HighlightInfo.IntentionActionDescriptor>();
        DaemonCodeAnalyzerImpl.processHighlightsNearOffset(editor.getDocument(), project, HighlightSeverity.INFORMATION, offset, true, (Processor<? super HighlightInfo>)((Processor)info -> {
            ShowIntentionsPass.addAvailableFixesForGroups(info, editor, file2, result2, passId, offset);
            return true;
        }));
        return result2;
    }

    public static boolean markActionInvoked(@NotNull Project project, @NotNull Editor editor, @NotNull IntentionAction action2) {
        int offset = ((EditorEx)editor).getExpectedCaretOffset();
        ArrayList infos = new ArrayList();
        DaemonCodeAnalyzerImpl.processHighlightsNearOffset(editor.getDocument(), project, HighlightSeverity.INFORMATION, offset, true, (Processor<? super HighlightInfo>)new CommonProcessors.CollectProcessor(infos));
        boolean removed = false;
        for (HighlightInfo info : infos) {
            if (info.quickFixActionMarkers == null) continue;
            for (Pair<HighlightInfo.IntentionActionDescriptor, RangeMarker> pair : info.quickFixActionMarkers) {
                HighlightInfo.IntentionActionDescriptor actionInGroup = (HighlightInfo.IntentionActionDescriptor)pair.first;
                if (actionInGroup.getAction() != action2) continue;
                removed |= info.quickFixActionMarkers.remove(pair);
            }
        }
        return removed;
    }

    private static void addAvailableFixesForGroups(@NotNull HighlightInfo info, @NotNull Editor editor, @NotNull PsiFile file2, @NotNull List<? super HighlightInfo.IntentionActionDescriptor> outList, int group, int offset) {
        if (info.quickFixActionMarkers == null) {
            return;
        }
        if (group != -1 && group != info.getGroup()) {
            return;
        }
        boolean fixRangeIsNotEmpty = !info.getFixTextRange().isEmpty();
        Editor injectedEditor = null;
        PsiFile injectedFile = null;
        ProgressIndicator indicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
        for (Pair<HighlightInfo.IntentionActionDescriptor, RangeMarker> pair : info.quickFixActionMarkers) {
            PsiFile fileToUse;
            Editor editorToUse;
            HighlightInfo.IntentionActionDescriptor actionInGroup = (HighlightInfo.IntentionActionDescriptor)pair.first;
            RangeMarker range2 = (RangeMarker)pair.second;
            if (!range2.isValid() || fixRangeIsNotEmpty && ShowIntentionsPass.isEmpty((Segment)range2) || DumbService.isDumb((Project)file2.getProject()) && !DumbService.isDumbAware((Object)actionInGroup.getAction())) continue;
            int start2 = range2.getStartOffset();
            int end = range2.getEndOffset();
            Project project = file2.getProject();
            if (start2 > offset || offset > end) continue;
            if (info.isFromInjection()) {
                if (injectedEditor == null) {
                    injectedFile = InjectedLanguageUtil.findInjectedPsiNoCommit(file2, offset);
                    injectedEditor = InjectedLanguageUtil.getInjectedEditorForInjectedFile(editor, injectedFile);
                }
                editorToUse = injectedFile == null ? editor : injectedEditor;
                fileToUse = injectedFile == null ? file2 : injectedFile;
            } else {
                editorToUse = editor;
                fileToUse = file2;
            }
            if (indicator != null) {
                indicator.setText(actionInGroup.getDisplayName());
            }
            if (!actionInGroup.getAction().isAvailable(project, editorToUse, fileToUse)) continue;
            outList.add(actionInGroup);
        }
    }

    private static boolean isEmpty(@NotNull Segment segment) {
        return segment.getEndOffset() <= segment.getStartOffset();
    }

    @Override
    public void doCollectInformation(@NotNull ProgressIndicator progress2) {
        if (!EditorActivityManager.getInstance().isFocused(this.myEditor)) {
            return;
        }
        TemplateState state = TemplateManagerImpl.getTemplateState(this.myEditor);
        if (state != null && !state.isFinished()) {
            return;
        }
        ShowIntentionsPass.getActionsToShow(this.myEditor, this.myFile, this.myIntentionsInfo, this.myPassIdToShowIntentionsFor, this.myQueryIntentionActions);
        this.myCachedIntentions = IntentionsUI.getInstance(this.myProject).getCachedIntentions(this.myEditor, this.myFile);
        this.myActionsChanged = this.myCachedIntentions.wrapAndUpdateActions(this.myIntentionsInfo, false);
    }

    @Override
    public void doApplyInformationToEditor() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        CachedIntentions cachedIntentions = this.myCachedIntentions;
        boolean actionsChanged = this.myActionsChanged;
        TemplateState state = TemplateManagerImpl.getTemplateState(this.myEditor);
        if ((state == null || state.isFinished()) && cachedIntentions != null) {
            IntentionsInfo syncInfo = new IntentionsInfo();
            ShowIntentionsPass.getActionsToShowSync(this.myEditor, this.myFile, syncInfo);
            IntentionsUI.getInstance(this.myProject).update(cachedIntentions, actionsChanged |= cachedIntentions.addActions(syncInfo));
        }
    }

    @NotNull
    public static IntentionsInfo getActionsToShow(@NotNull Editor hostEditor, @NotNull PsiFile hostFile, boolean includeSyncActions) {
        IntentionsInfo result2 = new IntentionsInfo();
        ShowIntentionsPass.getActionsToShow(hostEditor, hostFile, result2, -1);
        if (includeSyncActions) {
            ShowIntentionsPass.getActionsToShowSync(hostEditor, hostFile, result2);
        }
        return result2;
    }

    @ApiStatus.Internal
    public static void getActionsToShowSync(@NotNull Editor hostEditor, @NotNull PsiFile hostFile, @NotNull IntentionsInfo intentions) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        EditorNotificationActions.collectActions(hostEditor, intentions);
        intentions.filterActions(hostFile);
    }

    public static void getActionsToShow(@NotNull Editor hostEditor, @NotNull PsiFile hostFile, @NotNull IntentionsInfo intentions, int passIdToShowIntentionsFor) {
        ShowIntentionsPass.getActionsToShow(hostEditor, hostFile, intentions, passIdToShowIntentionsFor, true);
    }

    private static void getActionsToShow(@NotNull Editor hostEditor, @NotNull PsiFile hostFile, @NotNull IntentionsInfo intentions, int passIdToShowIntentionsFor, boolean queryIntentionActions) {
        int offset = hostEditor.getCaretModel().getOffset();
        PsiElement psiElement = hostFile.findElementAt(offset);
        if (psiElement != null) {
            PsiUtilCore.ensureValid((PsiElement)psiElement);
        }
        intentions.setOffset(offset);
        ArrayList fixes = new ArrayList();
        DaemonCodeAnalyzerImpl.HighlightByOffsetProcessor highestPriorityInfoFinder = new DaemonCodeAnalyzerImpl.HighlightByOffsetProcessor(true);
        CommonProcessors.CollectProcessor infos = new CommonProcessors.CollectProcessor();
        DaemonCodeAnalyzerImpl.processHighlightsNearOffset(hostEditor.getDocument(), hostFile.getProject(), HighlightSeverity.INFORMATION, offset, true, (Processor<? super HighlightInfo>)infos);
        for (HighlightInfo info : infos.getResults()) {
            ShowIntentionsPass.addAvailableFixesForGroups(info, hostEditor, hostFile, fixes, passIdToShowIntentionsFor, offset);
            highestPriorityInfoFinder.process(info);
        }
        @Nullable HighlightInfo infoAtCursor = highestPriorityInfoFinder.getResult();
        if (infoAtCursor == null) {
            intentions.errorFixesToShow.addAll(fixes);
        } else {
            ShowIntentionsPass.fillIntentionsInfoForHighlightInfo(infoAtCursor, intentions, fixes);
        }
        ProgressIndicator indicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
        if (queryIntentionActions) {
            PsiFile injectedFile = InjectedLanguageUtil.findInjectedPsiNoCommit(hostFile, offset);
            for (IntentionAction action2 : IntentionManager.getInstance().getAvailableIntentions()) {
                Pair<PsiFile, Editor> place;
                if (indicator != null) {
                    indicator.setText(action2.getFamilyName());
                }
                if ((place = ShowIntentionActionsHandler.chooseBetweenHostAndInjected(hostFile, hostEditor, injectedFile, (PairProcessor<? super PsiFile, ? super Editor>)((PairProcessor)(psiFile, editor) -> ShowIntentionActionsHandler.availableFor(psiFile, editor, action2)))) == null) continue;
                ArrayList<IntentionAction> enableDisableIntentionAction = new ArrayList<IntentionAction>();
                enableDisableIntentionAction.add(new EnableDisableIntentionAction(action2));
                enableDisableIntentionAction.add(new EditIntentionSettingsAction(action2));
                HighlightInfo.IntentionActionDescriptor descriptor2 = new HighlightInfo.IntentionActionDescriptor(action2, enableDisableIntentionAction, null);
                if (fixes.contains(descriptor2)) continue;
                intentions.intentionsToShow.add(descriptor2);
            }
            if (indicator != null) {
                indicator.setText(CodeInsightBundle.message((String)"progress.text.searching.for.additional.intention.actions.quick.fixes", (Object[])new Object[0]));
            }
            for (IntentionMenuContributor extension : IntentionMenuContributor.EP_NAME.getExtensionList()) {
                try {
                    extension.collectActions(hostEditor, hostFile, intentions, passIdToShowIntentionsFor, offset);
                }
                catch (IntentionPreviewUnsupportedOperationException intentionPreviewUnsupportedOperationException) {}
            }
        }
        intentions.filterActions(hostFile);
    }

    public static void fillIntentionsInfoForHighlightInfo(@NotNull HighlightInfo infoAtCursor, @NotNull IntentionsInfo intentions, @NotNull List<? extends HighlightInfo.IntentionActionDescriptor> fixes) {
        boolean isError = infoAtCursor.getSeverity() == HighlightSeverity.ERROR;
        for (HighlightInfo.IntentionActionDescriptor intentionActionDescriptor : fixes) {
            if (intentionActionDescriptor.isError() && isError) {
                intentions.errorFixesToShow.add(intentionActionDescriptor);
                continue;
            }
            if (intentionActionDescriptor.isInformation()) {
                intentions.intentionsToShow.add(intentionActionDescriptor);
                continue;
            }
            intentions.inspectionFixesToShow.add(intentionActionDescriptor);
        }
    }

    public static class IntentionsInfo {
        public final List<HighlightInfo.IntentionActionDescriptor> intentionsToShow = ContainerUtil.createLockFreeCopyOnWriteList();
        public final List<HighlightInfo.IntentionActionDescriptor> errorFixesToShow = ContainerUtil.createLockFreeCopyOnWriteList();
        public final List<HighlightInfo.IntentionActionDescriptor> inspectionFixesToShow = ContainerUtil.createLockFreeCopyOnWriteList();
        public final List<HighlightInfo.IntentionActionDescriptor> guttersToShow = ContainerUtil.createLockFreeCopyOnWriteList();
        public final List<HighlightInfo.IntentionActionDescriptor> notificationActionsToShow = ContainerUtil.createLockFreeCopyOnWriteList();
        private int myOffset;

        public void filterActions(@Nullable PsiFile psiFile) {
            IntentionActionFilter[] filters = (IntentionActionFilter[])IntentionActionFilter.EXTENSION_POINT_NAME.getExtensions();
            IntentionsInfo.filter(this.intentionsToShow, psiFile, filters);
            IntentionsInfo.filter(this.errorFixesToShow, psiFile, filters);
            IntentionsInfo.filter(this.inspectionFixesToShow, psiFile, filters);
            IntentionsInfo.filter(this.guttersToShow, psiFile, filters);
            IntentionsInfo.filter(this.notificationActionsToShow, psiFile, filters);
        }

        public void setOffset(int offset) {
            this.myOffset = offset;
        }

        public int getOffset() {
            return this.myOffset;
        }

        private static void filter(@NotNull List<HighlightInfo.IntentionActionDescriptor> descriptors, @Nullable PsiFile psiFile, IntentionActionFilter @NotNull [] filters) {
            Iterator<HighlightInfo.IntentionActionDescriptor> it = descriptors.iterator();
            block0: while (it.hasNext()) {
                HighlightInfo.IntentionActionDescriptor actionDescriptor = it.next();
                for (IntentionActionFilter filter2 : filters) {
                    if (filter2.accept(actionDescriptor.getAction(), psiFile)) continue;
                    it.remove();
                    continue block0;
                }
            }
        }

        public boolean isEmpty() {
            return this.intentionsToShow.isEmpty() && this.errorFixesToShow.isEmpty() && this.inspectionFixesToShow.isEmpty() && this.guttersToShow.isEmpty() && this.notificationActionsToShow.isEmpty();
        }

        @NonNls
        public String toString() {
            return "Errors: " + this.errorFixesToShow + "; Inspection fixes: " + this.inspectionFixesToShow + "; Intentions: " + this.intentionsToShow + "; Gutters: " + this.guttersToShow + "; Notifications: " + this.notificationActionsToShow;
        }
    }
}

