/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.daemon.DaemonBundle;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettings;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.DaemonListeners;
import com.intellij.codeInsight.daemon.impl.DaemonProgressIndicator;
import com.intellij.codeInsight.daemon.impl.FileStatusMap;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.VisibleHighlightingPassFactory;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.HintAction;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorActivityManager;
import com.intellij.openapi.editor.impl.ImaginaryEditor;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;

public class ShowAutoImportPass
extends TextEditorHighlightingPass {
    private final Editor myEditor;
    private final PsiFile myFile;
    private final int myStartOffset;
    private final int myEndOffset;
    private final boolean hasDirtyTextRange;

    ShowAutoImportPass(@NotNull Project project, @NotNull PsiFile file2, @NotNull Editor editor) {
        super(project, editor.getDocument(), false);
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myEditor = editor;
        ProperTextRange range2 = VisibleHighlightingPassFactory.calculateVisibleRange(this.myEditor);
        this.myStartOffset = range2.getStartOffset();
        this.myEndOffset = range2.getEndOffset();
        this.myFile = file2;
        this.hasDirtyTextRange = FileStatusMap.getDirtyTextRange(editor, 4) != null;
    }

    @Override
    public void doCollectInformation(@NotNull ProgressIndicator progress2) {
    }

    @Override
    public void doApplyInformationToEditor() {
        ApplicationManager.getApplication().invokeLater(this::showImports);
    }

    private void showImports() {
        Application application = ApplicationManager.getApplication();
        application.assertIsDispatchThread();
        if (!EditorActivityManager.getInstance().isFocused(this.myEditor)) {
            return;
        }
        if (DumbService.isDumb((Project)this.myProject) || !this.myFile.isValid()) {
            return;
        }
        if (this.myEditor.isDisposed() || this.myEditor instanceof EditorWindow && !((EditorWindow)this.myEditor).isValid()) {
            return;
        }
        int caretOffset = this.myEditor.getCaretModel().getOffset();
        this.importUnambiguousImports(caretOffset);
        if (this.isImportHintEnabled()) {
            List<HighlightInfo> visibleHighlights = ShowAutoImportPass.getVisibleHighlights(this.myStartOffset, this.myEndOffset, this.myProject, this.myEditor, this.hasDirtyTextRange);
            for (int i2 = visibleHighlights.size() - 1; i2 >= 0; --i2) {
                HighlightInfo info = visibleHighlights.get(i2);
                if (info.startOffset > caretOffset || !this.showAddImportHint(info)) continue;
                return;
            }
            for (HighlightInfo visibleHighlight : visibleHighlights) {
                if (visibleHighlight.startOffset <= caretOffset || !this.showAddImportHint(visibleHighlight)) continue;
                return;
            }
        }
    }

    private void importUnambiguousImports(int caretOffset) {
        Document document = this.myEditor.getDocument();
        ArrayList infos = new ArrayList();
        DaemonCodeAnalyzerEx.processHighlights(document, this.myProject, null, 0, document.getTextLength(), (Processor<? super HighlightInfo>)((Processor)info -> {
            if (info.hasHint() && info.getSeverity() == HighlightSeverity.ERROR && !info.getFixTextRange().containsOffset(caretOffset)) {
                infos.add(info);
            }
            return true;
        }));
        for (HighlightInfo info2 : infos) {
            HintAction action2;
            Iterator<HintAction> iterator2 = ShowAutoImportPass.extractHints(info2).iterator();
            while (!(!iterator2.hasNext() || (action2 = iterator2.next()).isAvailable(this.myProject, this.myEditor, this.myFile) && ShowAutoImportPass.mayAutoImportNow(this.myFile) && action2.fixSilently(this.myEditor))) {
            }
        }
    }

    public static boolean mayAutoImportNow(@NotNull PsiFile psiFile) {
        return ShowAutoImportPass.isAddUnambiguousImportsOnTheFlyEnabled(psiFile) && (ApplicationManager.getApplication().isUnitTestMode() || DaemonListeners.canChangeFileSilently((PsiFileSystemItem)psiFile)) && ShowAutoImportPass.isInModelessContext(psiFile.getProject());
    }

    private static boolean isInModelessContext(@NotNull Project project) {
        return Registry.is((String)"ide.perProjectModality") ? !LaterInvocator.isInModalContextForProject(project) : !LaterInvocator.isInModalContext();
    }

    public static boolean isAddUnambiguousImportsOnTheFlyEnabled(@NotNull PsiFile psiFile) {
        PsiFile templateFile = PsiUtilCore.getTemplateLanguageFile((PsiElement)psiFile);
        if (templateFile == null) {
            return false;
        }
        boolean isJsp = templateFile.getFileType().getName().equals("JSP") || templateFile.getFileType().getName().equals("JSPX");
        return isJsp ? CodeInsightSettings.getInstance().JSP_ADD_UNAMBIGIOUS_IMPORTS_ON_THE_FLY : CodeInsightSettings.getInstance().ADD_UNAMBIGIOUS_IMPORTS_ON_THE_FLY;
    }

    @NotNull
    private static List<HighlightInfo> getVisibleHighlights(int startOffset, int endOffset, @NotNull Project project, @NotNull Editor editor, boolean isDirty) {
        ArrayList<HighlightInfo> highlights = new ArrayList<HighlightInfo>();
        int offset = editor.getCaretModel().getOffset();
        DaemonCodeAnalyzerEx.processHighlights(editor.getDocument(), project, null, startOffset, endOffset, (Processor<? super HighlightInfo>)((Processor)info -> {
            if (!isDirty && !info.getFixTextRange().contains(offset)) {
                return true;
            }
            if (info.hasHint() && !editor.getFoldingModel().isOffsetCollapsed(info.startOffset)) {
                highlights.add((HighlightInfo)info);
            }
            return true;
        }));
        return highlights;
    }

    private boolean showAddImportHint(@NotNull HighlightInfo info) {
        PsiElement element2 = this.myFile.findElementAt(info.startOffset);
        if (element2 == null || !element2.isValid()) {
            return false;
        }
        for (HintAction action2 : ShowAutoImportPass.extractHints(info)) {
            if (!action2.isAvailable(this.myProject, this.myEditor, this.myFile) || !action2.showHint(this.myEditor)) continue;
            return true;
        }
        return false;
    }

    public static void fixAllImportsSilently(@NotNull PsiFile file2, @NotNull List<? extends HintAction> actions) {
        if (actions.isEmpty()) {
            return;
        }
        Document document = PsiDocumentManager.getInstance((Project)file2.getProject()).getDocument(file2);
        if (document == null) {
            return;
        }
        ImaginaryEditor editor = new ImaginaryEditor(file2.getProject(), document);
        for (HintAction hintAction : actions) {
            hintAction.fixSilently((Editor)editor);
        }
    }

    @NotNull
    public static List<HintAction> getImportHints(@NotNull PsiFile file2) {
        if (ApplicationManager.getApplication().isDispatchThread()) {
            return Collections.emptyList();
        }
        Project project = file2.getProject();
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument(file2);
        if (document == null || !ShowAutoImportPass.hasUnresolvedReferences(file2)) {
            return Collections.emptyList();
        }
        DaemonProgressIndicator progress2 = new DaemonProgressIndicator();
        AtomicReference infos = new AtomicReference(Collections.emptyList());
        ((ApplicationImpl)ApplicationManager.getApplication()).executeByImpatientReader(() -> ProgressManager.getInstance().executeProcessUnderProgress(() -> infos.set(DaemonCodeAnalyzerEx.getInstanceEx(project).runMainPasses(file2, document, progress2)), (ProgressIndicator)progress2));
        ArrayList<HintAction> result2 = new ArrayList<HintAction>(infos.get().size());
        for (HighlightInfo info : infos.get()) {
            for (HintAction action2 : ShowAutoImportPass.extractHints(info)) {
                if (!action2.isAvailable(project, null, file2)) continue;
                result2.add(action2);
            }
        }
        return result2;
    }

    private static boolean hasUnresolvedReferences(@NotNull PsiFile file2) {
        final Ref result2 = new Ref((Object)false);
        file2.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

            public void visitElement(@NotNull PsiElement element2) {
                if (element2 instanceof PsiReference && ((PsiReference)element2).resolve() == null) {
                    result2.set((Object)true);
                    this.stopWalking();
                }
                super.visitElement(element2);
            }
        });
        return (Boolean)result2.get();
    }

    private boolean isImportHintEnabled() {
        return DaemonCodeAnalyzerSettings.getInstance().isImportHintEnabled() && DaemonCodeAnalyzer.getInstance((Project)this.myProject).isImportHintsEnabled(this.myFile);
    }

    @NotNull
    private static List<HintAction> extractHints(@NotNull HighlightInfo info) {
        List<Pair<HighlightInfo.IntentionActionDescriptor, TextRange>> list2 = info.quickFixActionRanges;
        if (list2 == null) {
            return Collections.emptyList();
        }
        SmartList hintActions = new SmartList();
        for (Pair<HighlightInfo.IntentionActionDescriptor, TextRange> pair : list2) {
            IntentionAction action2 = ((HighlightInfo.IntentionActionDescriptor)pair.getFirst()).getAction();
            if (!(action2 instanceof HintAction)) continue;
            hintActions.add((HintAction)action2);
        }
        return hintActions;
    }

    @NotNull
    public static String getMessage(boolean multiple, @NotNull String name) {
        String messageKey = multiple ? "import.popup.multiple" : "import.popup.text";
        String hintText = DaemonBundle.message((String)messageKey, (Object[])new Object[]{name});
        hintText = hintText + " " + KeymapUtil.getFirstKeyboardShortcutText((AnAction)ActionManager.getInstance().getAction("ShowIntentionActions"));
        return hintText;
    }
}

