/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.impl.LevelAction$WhenMappings;
import com.intellij.codeInsight.daemon.impl.analysis.FileHighlightingSetting;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightLevelUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightingLevelManager;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.editor.markup.InspectionsLevel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0010H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0016"}, d2={"Lcom/intellij/codeInsight/daemon/impl/LevelAction;", "Lcom/intellij/openapi/actionSystem/ToggleAction;", "level", "Lcom/intellij/openapi/editor/markup/InspectionsLevel;", "provider", "Lcom/intellij/psi/FileViewProvider;", "language", "Lcom/intellij/lang/Language;", "(Lcom/intellij/openapi/editor/markup/InspectionsLevel;Lcom/intellij/psi/FileViewProvider;Lcom/intellij/lang/Language;)V", "getLanguage", "()Lcom/intellij/lang/Language;", "getLevel", "()Lcom/intellij/openapi/editor/markup/InspectionsLevel;", "getProvider", "()Lcom/intellij/psi/FileViewProvider;", "isSelected", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "setSelected", "", "state", "intellij.platform.lang.impl"})
final class LevelAction
extends ToggleAction {
    @NotNull
    private final InspectionsLevel level;
    @NotNull
    private final FileViewProvider provider;
    @NotNull
    private final Language language;

    public boolean isSelected(@NotNull AnActionEvent event) {
        PsiFile psiFile = this.provider.getPsi(this.language);
        if (psiFile == null) {
            return false;
        }
        PsiFile file2 = psiFile;
        HighlightingLevelManager highlightingLevelManager = HighlightingLevelManager.getInstance(file2.getProject());
        if (highlightingLevelManager == null) {
            return false;
        }
        HighlightingLevelManager manager = highlightingLevelManager;
        return this.level == (manager.shouldInspect((PsiElement)file2) ? InspectionsLevel.ALL : (manager.shouldHighlight((PsiElement)file2) ? InspectionsLevel.SYNTAX : InspectionsLevel.NONE));
    }

    public void setSelected(@NotNull AnActionEvent event, boolean state) {
        FileHighlightingSetting fileHighlightingSetting;
        if (!state) {
            return;
        }
        PsiFile psiFile = this.provider.getPsi(this.language);
        if (psiFile == null) {
            return;
        }
        PsiFile file2 = psiFile;
        PsiElement psiElement = (PsiElement)file2;
        switch (LevelAction$WhenMappings.$EnumSwitchMapping$0[this.level.ordinal()]) {
            case 1: {
                fileHighlightingSetting = FileHighlightingSetting.SKIP_HIGHLIGHTING;
                break;
            }
            case 2: {
                fileHighlightingSetting = FileHighlightingSetting.SKIP_INSPECTION;
                break;
            }
            case 3: {
                fileHighlightingSetting = FileHighlightingSetting.FORCE_HIGHLIGHTING;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        HighlightLevelUtil.forceRootHighlighting(psiElement, fileHighlightingSetting);
        InjectedLanguageManager.getInstance((Project)file2.getProject()).dropFileCaches(file2);
        DaemonCodeAnalyzer.getInstance((Project)file2.getProject()).restart();
    }

    @NotNull
    public final InspectionsLevel getLevel() {
        return this.level;
    }

    @NotNull
    public final FileViewProvider getProvider() {
        return this.provider;
    }

    @NotNull
    public final Language getLanguage() {
        return this.language;
    }

    public LevelAction(@NotNull InspectionsLevel level, @NotNull FileViewProvider provider, @NotNull Language language) {
        super(level.toString());
        this.level = level;
        this.provider = provider;
        this.language = language;
    }
}

