/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.MainHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactoryRegistrar;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.daemon.impl.DefaultHighlightInfoProcessor;
import com.intellij.codeInsight.daemon.impl.FileStatusMap;
import com.intellij.codeInsight.daemon.impl.HighlightInfoProcessor;
import com.intellij.codeInsight.daemon.impl.InjectedGeneralHighlightingPass;
import com.intellij.codeInsight.daemon.impl.ProgressableTextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.impl.TextEditorHighlightingPassRegistrarImpl;
import com.intellij.codeInsight.daemon.impl.VisibleHighlightingPassFactory;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;

public final class InjectedGeneralHighlightingPassFactory
implements MainHighlightingPassFactory,
TextEditorHighlightingPassFactoryRegistrar {
    @Override
    public void registerHighlightingPassFactory(@NotNull TextEditorHighlightingPassRegistrar registrar, @NotNull Project project) {
        boolean serialized = Registry.is((String)"editor.injected.highlighting.serialization.allowed") && ((TextEditorHighlightingPassRegistrarImpl)registrar).isSerializeCodeInsightPasses();
        int[] ghl = new int[]{4};
        registrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)this, (int[])(serialized ? ghl : null), serialized ? null : ghl, false, -1);
    }

    @Override
    @NotNull
    public TextEditorHighlightingPass createHighlightingPass(@NotNull PsiFile file2, @NotNull Editor editor) {
        Project project = file2.getProject();
        TextRange textRange = FileStatusMap.getDirtyTextRange(editor, 4);
        if (textRange == null) {
            return new ProgressableTextEditorHighlightingPass.EmptyPass(project, editor.getDocument());
        }
        ProperTextRange visibleRange = VisibleHighlightingPassFactory.calculateVisibleRange(editor);
        return new InjectedGeneralHighlightingPass(project, file2, editor.getDocument(), textRange.getStartOffset(), textRange.getEndOffset(), true, visibleRange, editor, new DefaultHighlightInfoProcessor());
    }

    @Override
    public TextEditorHighlightingPass createMainHighlightingPass(@NotNull PsiFile file2, @NotNull Document document, @NotNull HighlightInfoProcessor highlightInfoProcessor) {
        return new InjectedGeneralHighlightingPass(file2.getProject(), file2, document, 0, document.getTextLength(), true, new ProperTextRange(0, document.getTextLength()), null, highlightInfoProcessor);
    }
}

