/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoFilter;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.lang.annotation.AnnotationSession;
import com.intellij.openapi.editor.colors.TextAttributesScheme;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CheckLevelHighlightInfoHolder
extends HighlightInfoHolder {
    private final HighlightInfoHolder myHolder;
    private PsiElement myLevel;

    public CheckLevelHighlightInfoHolder(@NotNull PsiFile file2, @NotNull HighlightInfoHolder holder) {
        super(file2, new HighlightInfoFilter[0]);
        this.myHolder = holder;
    }

    @Override
    @NotNull
    public TextAttributesScheme getColorsScheme() {
        return this.myHolder.getColorsScheme();
    }

    @Override
    @NotNull
    public PsiFile getContextFile() {
        return this.myHolder.getContextFile();
    }

    @Override
    @NotNull
    public Project getProject() {
        return this.myHolder.getProject();
    }

    @Override
    public boolean hasErrorResults() {
        return this.myHolder.hasErrorResults();
    }

    @Override
    public boolean add(@Nullable HighlightInfo info) {
        if (info == null) {
            return false;
        }
        PsiElement psiElement = info.psiElement;
        if (psiElement != null && !PsiTreeUtil.isAncestor((PsiElement)this.myLevel, (PsiElement)psiElement, (boolean)false)) {
            throw new RuntimeException("Info: '" + info + "' reported for the element '" + psiElement + "'; but it was at the level " + this.myLevel);
        }
        return this.myHolder.add(info);
    }

    @Override
    public void clear() {
        this.myHolder.clear();
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends HighlightInfo> highlightInfos) {
        return this.myHolder.addAll(highlightInfos);
    }

    @Override
    public int size() {
        return this.myHolder.size();
    }

    @Override
    @NotNull
    public HighlightInfo get(int i2) {
        return this.myHolder.get(i2);
    }

    @Override
    @NotNull
    public AnnotationSession getAnnotationSession() {
        return this.myHolder.getAnnotationSession();
    }

    public void enterLevel(PsiElement element2) {
        this.myLevel = element2;
    }
}

