/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.AnnotationHolderImpl;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAsIntentionAdapter;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationBuilder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.annotation.ProblemGroup;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.objectTree.ThrowableInterner;
import com.intellij.psi.PsiElement;
import com.intellij.xml.util.XmlStringUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class B
implements AnnotationBuilder {
    @NotNull
    private final AnnotationHolderImpl myHolder;
    private final String message;
    @NotNull
    private final PsiElement myCurrentElement;
    @NotNull
    private final HighlightSeverity severity;
    private TextRange range;
    private Boolean afterEndOfLine;
    private Boolean fileLevel;
    private GutterIconRenderer gutterIconRenderer;
    private ProblemGroup problemGroup;
    private TextAttributes enforcedAttributes;
    private TextAttributesKey textAttributes;
    private ProblemHighlightType highlightType;
    private Boolean needsUpdateOnTyping;
    private String tooltip;
    private List<FixB> fixes;
    private boolean created;
    private final Throwable myDebugCreationPlace;

    B(@NotNull AnnotationHolderImpl holder, @NotNull HighlightSeverity severity, String message, @NotNull PsiElement currentElement) {
        this.myHolder = holder;
        this.severity = severity;
        this.message = message;
        this.myCurrentElement = currentElement;
        holder.annotationBuilderCreated(this);
        Application app = ApplicationManager.getApplication();
        this.myDebugCreationPlace = app.isUnitTestMode() && !ApplicationInfoImpl.isInStressTest() || app.isInternal() ? ThrowableInterner.intern((Throwable)new Throwable()) : null;
    }

    private void assertNotSet(Object o, String description) {
        if (o != null) {
            this.markNotAbandoned();
            throw new IllegalStateException(description + " was set already");
        }
    }

    private void markNotAbandoned() {
        this.created = true;
    }

    @NotNull
    public AnnotationBuilder withFix(@NotNull IntentionAction fix) {
        return this.newFix(fix).registerFix();
    }

    @NotNull
    public AnnotationBuilder.FixBuilder newFix(@NotNull IntentionAction fix) {
        return new FixB(fix);
    }

    @NotNull
    public AnnotationBuilder.FixBuilder newLocalQuickFix(@NotNull LocalQuickFix fix, @NotNull ProblemDescriptor problemDescriptor) {
        return new FixB((IntentionAction)new LocalQuickFixAsIntentionAdapter(fix, problemDescriptor));
    }

    @NotNull
    public AnnotationBuilder range(@NotNull TextRange range2) {
        this.assertNotSet(this.range, "range");
        TextRange currentElementRange = this.myCurrentElement.getTextRange();
        if (!currentElementRange.contains(range2)) {
            this.markNotAbandoned();
            throw new IllegalArgumentException("Range must be inside element being annotated: " + currentElementRange + "; but got: " + range2);
        }
        this.range = range2;
        return this;
    }

    @NotNull
    public AnnotationBuilder range(@NotNull ASTNode element2) {
        return this.range(element2.getTextRange());
    }

    @NotNull
    public AnnotationBuilder range(@NotNull PsiElement element2) {
        return this.range(element2.getTextRange());
    }

    @NotNull
    public AnnotationBuilder afterEndOfLine() {
        this.assertNotSet(this.afterEndOfLine, "afterEndOfLine");
        this.afterEndOfLine = true;
        return this;
    }

    @NotNull
    public AnnotationBuilder fileLevel() {
        this.assertNotSet(this.fileLevel, "fileLevel");
        this.fileLevel = true;
        return this;
    }

    @NotNull
    public AnnotationBuilder gutterIconRenderer(@NotNull GutterIconRenderer gutterIconRenderer) {
        this.assertNotSet(this.gutterIconRenderer, "gutterIconRenderer");
        this.gutterIconRenderer = gutterIconRenderer;
        return this;
    }

    @NotNull
    public AnnotationBuilder problemGroup(@NotNull ProblemGroup problemGroup) {
        this.assertNotSet(this.problemGroup, "problemGroup");
        this.problemGroup = problemGroup;
        return this;
    }

    @NotNull
    public AnnotationBuilder enforcedTextAttributes(@NotNull TextAttributes enforcedAttributes) {
        this.assertNotSet(this.enforcedAttributes, "enforcedAttributes");
        this.enforcedAttributes = enforcedAttributes;
        return this;
    }

    @NotNull
    public AnnotationBuilder textAttributes(@NotNull TextAttributesKey textAttributes) {
        this.assertNotSet(this.textAttributes, "textAttributes");
        this.textAttributes = textAttributes;
        return this;
    }

    @NotNull
    public AnnotationBuilder highlightType(@NotNull ProblemHighlightType highlightType) {
        this.assertNotSet(this.highlightType, "highlightType");
        this.highlightType = highlightType;
        return this;
    }

    @NotNull
    public AnnotationBuilder needsUpdateOnTyping() {
        return this.needsUpdateOnTyping(true);
    }

    @NotNull
    public AnnotationBuilder needsUpdateOnTyping(boolean value2) {
        this.assertNotSet(this.needsUpdateOnTyping, "needsUpdateOnTyping");
        this.needsUpdateOnTyping = value2;
        return this;
    }

    @NotNull
    public AnnotationBuilder tooltip(@NotNull String tooltip) {
        this.assertNotSet(this.tooltip, "tooltip");
        this.tooltip = tooltip;
        return this;
    }

    public void create() {
        if (this.created) {
            throw new IllegalStateException("Must not call .create() twice");
        }
        this.created = true;
        if (this.range == null) {
            this.range = this.myCurrentElement.getTextRange();
        }
        if (this.tooltip == null && this.message != null) {
            this.tooltip = XmlStringUtil.wrapInHtml((CharSequence)XmlStringUtil.escapeString((String)this.message));
        }
        Annotation annotation = new Annotation(this.range.getStartOffset(), this.range.getEndOffset(), this.severity, this.message, this.tooltip);
        if (this.needsUpdateOnTyping != null) {
            annotation.setNeedsUpdateOnTyping(this.needsUpdateOnTyping.booleanValue());
        }
        if (this.highlightType != null) {
            annotation.setHighlightType(this.highlightType);
        }
        if (this.textAttributes != null) {
            annotation.setTextAttributes(this.textAttributes);
        }
        if (this.enforcedAttributes != null) {
            annotation.setEnforcedTextAttributes(this.enforcedAttributes);
        }
        if (this.problemGroup != null) {
            annotation.setProblemGroup(this.problemGroup);
        }
        if (this.gutterIconRenderer != null) {
            annotation.setGutterIconRenderer(this.gutterIconRenderer);
        }
        if (this.fileLevel != null) {
            annotation.setFileLevelAnnotation(this.fileLevel.booleanValue());
        }
        if (this.afterEndOfLine != null) {
            annotation.setAfterEndOfLine(this.afterEndOfLine.booleanValue());
        }
        if (this.fixes != null) {
            for (FixB fb : this.fixes) {
                TextRange finalRange;
                IntentionAction fix = fb.fix;
                TextRange textRange = finalRange = fb.range == null ? this.range : fb.range;
                if (fb.batch != null && fb.batch.booleanValue()) {
                    B.registerBatchFix(annotation, fix, finalRange, fb.key);
                    continue;
                }
                if (fb.universal != null && fb.universal.booleanValue()) {
                    B.registerBatchFix(annotation, fix, finalRange, fb.key);
                    annotation.registerFix(fix, finalRange, fb.key);
                    continue;
                }
                annotation.registerFix(fix, finalRange, fb.key);
            }
        }
        this.myHolder.add(annotation);
        this.myHolder.queueToUpdateIncrementally();
        this.myHolder.annotationCreatedFrom(this);
    }

    private static <T extends IntentionAction & LocalQuickFix> void registerBatchFix(@NotNull Annotation annotation, @NotNull Object fix, @NotNull TextRange range2, HighlightDisplayKey key) {
        annotation.registerBatchFix((IntentionAction)fix, range2, key);
    }

    void assertAnnotationCreated() {
        if (!this.created) {
            throw new IllegalStateException("Abandoned AnnotationBuilder - its 'create()' method was never called: " + this + (this.myDebugCreationPlace == null ? "" : "\nSee cause for the AnnotationBuilder creation stacktrace"), this.myDebugCreationPlace);
        }
    }

    private static String omitIfEmpty(Object o, String name) {
        return o == null ? "" : ", " + name + "=" + o;
    }

    public String toString() {
        return "Builder{message='" + this.message + '\'' + ", myCurrentElement=" + this.myCurrentElement + ", severity=" + this.severity + ", range=" + (this.range == null ? "(implicit)" + this.myCurrentElement.getTextRange() : this.range) + B.omitIfEmpty(this.afterEndOfLine, "afterEndOfLine") + B.omitIfEmpty(this.fileLevel, "fileLevel") + B.omitIfEmpty(this.gutterIconRenderer, "gutterIconRenderer") + B.omitIfEmpty(this.problemGroup, "problemGroup") + B.omitIfEmpty(this.enforcedAttributes, "enforcedAttributes") + B.omitIfEmpty(this.textAttributes, "textAttributes") + B.omitIfEmpty(this.highlightType, "highlightType") + B.omitIfEmpty(this.needsUpdateOnTyping, "needsUpdateOnTyping") + B.omitIfEmpty(this.tooltip, "tooltip") + B.omitIfEmpty(this.fixes, "fixes") + '}';
    }

    class FixB
    implements AnnotationBuilder.FixBuilder {
        @NotNull
        IntentionAction fix;
        TextRange range;
        HighlightDisplayKey key;
        Boolean batch;
        Boolean universal;

        FixB(IntentionAction fix) {
            this.fix = fix;
        }

        @NotNull
        public AnnotationBuilder.FixBuilder range(@NotNull TextRange range2) {
            B.this.assertNotSet(this.range, "range");
            this.range = range2;
            return this;
        }

        @NotNull
        public AnnotationBuilder.FixBuilder key(@NotNull HighlightDisplayKey key) {
            B.this.assertNotSet(this.key, "key");
            this.key = key;
            return this;
        }

        @NotNull
        public AnnotationBuilder.FixBuilder batch() {
            B.this.assertNotSet(this.universal, "universal");
            B.this.assertNotSet(this.batch, "batch");
            this.assertLQF();
            this.batch = true;
            return this;
        }

        private void assertLQF() {
            if (!(this.fix instanceof LocalQuickFix) && !(this.fix instanceof LocalQuickFixAsIntentionAdapter)) {
                B.this.markNotAbandoned();
                throw new IllegalArgumentException("Fix " + this.fix + " must be instance of LocalQuickFix to be registered as batch");
            }
        }

        @NotNull
        public AnnotationBuilder.FixBuilder universal() {
            B.this.assertNotSet(this.universal, "universal");
            B.this.assertNotSet(this.batch, "batch");
            this.assertLQF();
            this.universal = true;
            return this;
        }

        @NotNull
        public AnnotationBuilder registerFix() {
            if (B.this.fixes == null) {
                B.this.fixes = new ArrayList();
            }
            B.this.fixes.add(this);
            return B.this;
        }

        public String toString() {
            return this.fix + (this.range == null ? "" : " at " + this.range) + (this.batch == null ? "" : " batch") + (this.universal == null ? "" : " universal");
        }
    }
}

