/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon;

import com.intellij.codeHighlighting.RainbowHighlighter;
import com.intellij.codeInsight.daemon.UsedColors;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightVisitor;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RainbowVisitor
implements HighlightVisitor {
    private HighlightInfoHolder myHolder;
    private RainbowHighlighter myRainbowHighlighter;

    @Override
    @NotNull
    public abstract HighlightVisitor clone();

    @NotNull
    protected RainbowHighlighter getHighlighter() {
        return this.myRainbowHighlighter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean analyze(@NotNull PsiFile file2, boolean updateWholeFile, @NotNull HighlightInfoHolder holder, @NotNull Runnable action2) {
        this.myHolder = holder;
        this.myRainbowHighlighter = new RainbowHighlighter(this.myHolder.getColorsScheme());
        try {
            action2.run();
        }
        finally {
            this.myHolder = null;
            this.myRainbowHighlighter = null;
        }
        return true;
    }

    protected void addInfo(@Nullable HighlightInfo highlightInfo) {
        this.myHolder.add(highlightInfo);
    }

    protected HighlightInfo getInfo(@NotNull PsiElement context, @NotNull PsiElement rainbowElement, @NotNull String name, @Nullable TextAttributesKey colorKey) {
        int colorIndex = UsedColors.getOrAddColorIndex((UserDataHolderEx)context, name, this.getHighlighter().getColorsCount());
        return this.getHighlighter().getInfo(colorIndex, rainbowElement, colorKey);
    }
}

