/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion.impl;

import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.lookup.Classifier;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.util.Pair;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FilteringIterator;
import com.intellij.util.containers.FlatteningIterator;
import com.intellij.util.containers.MultiMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LiftShorterItemsClassifier
extends Classifier<LookupElement> {
    private final TreeSet<String> mySortedStrings = new TreeSet();
    private final MultiMap<String, LookupElement> myElements = LiftShorterItemsClassifier.createMultiMap(false);
    private final MultiMap<LookupElement, LookupElement> myToLift = LiftShorterItemsClassifier.createMultiMap(true);
    private final MultiMap<LookupElement, LookupElement> myReversedToLift = LiftShorterItemsClassifier.createMultiMap(true);
    private final LiftingCondition myCondition;
    private final boolean myLiftBefore;
    private int myCount = 0;

    public LiftShorterItemsClassifier(String name, Classifier<LookupElement> next, LiftingCondition condition, boolean liftBefore) {
        super(next, name);
        this.myCondition = condition;
        this.myLiftBefore = liftBefore;
    }

    @Override
    public void addElement(@NotNull LookupElement added, @NotNull ProcessingContext context) {
        ++this.myCount;
        for (String string : CompletionUtil.iterateLookupStrings(added)) {
            if (string.length() == 0) continue;
            this.myElements.putValue((Object)string, (Object)added);
            this.mySortedStrings.add(string);
            NavigableSet<String> after2 = this.mySortedStrings.tailSet(string, false);
            for (String s : after2) {
                if (!s.startsWith(string)) break;
                for (LookupElement longer : this.myElements.get((Object)s)) {
                    this.updateLongerItem(added, longer);
                }
            }
        }
        super.addElement(added, context);
        this.calculateToLift(added);
    }

    private void updateLongerItem(LookupElement shorter, LookupElement longer) {
        if (this.myCondition.shouldLift(shorter, longer)) {
            this.myToLift.putValue((Object)longer, (Object)shorter);
            this.myReversedToLift.putValue((Object)shorter, (Object)longer);
        }
    }

    private void calculateToLift(LookupElement element2) {
        for (String string : CompletionUtil.iterateLookupStrings(element2)) {
            for (int len = 1; len < string.length(); ++len) {
                String prefix = string.substring(0, len);
                for (LookupElement shorterElement : this.myElements.get((Object)prefix)) {
                    if (!this.myCondition.shouldLift(shorterElement, element2)) continue;
                    this.myToLift.putValue((Object)element2, (Object)shorterElement);
                    this.myReversedToLift.putValue((Object)shorterElement, (Object)element2);
                }
            }
        }
    }

    @Override
    @NotNull
    public Iterable<LookupElement> classify(@NotNull Iterable<? extends LookupElement> source, @NotNull ProcessingContext context) {
        return this.liftShorterElements(source, null, context);
    }

    private Iterable<LookupElement> liftShorterElements(Iterable<? extends LookupElement> source, @Nullable Set<? super LookupElement> lifted, ProcessingContext context) {
        ReferenceOpenHashSet srcSet = new ReferenceOpenHashSet(source instanceof Collection ? ((Collection)source).size() : this.myCount);
        ContainerUtil.addAll((Collection)srcSet, source);
        if (srcSet.size() < 2) {
            return this.myNext.classify(source, context);
        }
        return new LiftingIterable((Set<LookupElement>)srcSet, context, source, lifted);
    }

    @Override
    @NotNull
    public List<Pair<LookupElement, Object>> getSortingWeights(@NotNull Iterable<? extends LookupElement> items, @NotNull ProcessingContext context) {
        ReferenceOpenHashSet lifted = new ReferenceOpenHashSet();
        Iterable<LookupElement> iterable = this.liftShorterElements(ContainerUtil.newArrayList(items), (Set<? super LookupElement>)lifted, context);
        return ContainerUtil.map(iterable, arg_0 -> LiftShorterItemsClassifier.lambda$getSortingWeights$0((Set)lifted, arg_0));
    }

    @Override
    public void removeElement(@NotNull LookupElement element2, @NotNull ProcessingContext context) {
        for (String s : CompletionUtil.iterateLookupStrings(element2)) {
            this.myElements.remove((Object)s, (Object)element2);
            if (!this.myElements.get((Object)s).isEmpty()) continue;
            this.mySortedStrings.remove(s);
        }
        LiftShorterItemsClassifier.removeFromMap(element2, this.myToLift, this.myReversedToLift);
        LiftShorterItemsClassifier.removeFromMap(element2, this.myReversedToLift, this.myToLift);
        super.removeElement(element2, context);
    }

    private static void removeFromMap(LookupElement key, MultiMap<LookupElement, LookupElement> mainMap, MultiMap<LookupElement, LookupElement> inverseMap) {
        Collection removed = mainMap.remove((Object)key);
        if (removed == null) {
            return;
        }
        for (LookupElement reference2 : new ArrayList(removed)) {
            inverseMap.remove((Object)reference2, (Object)key);
        }
    }

    @NotNull
    private static <K, V> MultiMap<K, V> createMultiMap(boolean identityKeys) {
        return new MultiMap<K, V>((Map)(identityKeys ? new Reference2ObjectOpenHashMap() : new Object2ObjectOpenHashMap())){

            public boolean remove(K key, V value2) {
                List elements2 = (List)this.get(key);
                int i2 = ContainerUtil.indexOfIdentity((List)elements2, value2);
                if (i2 >= 0) {
                    elements2.remove(i2);
                    if (elements2.isEmpty()) {
                        this.remove(key);
                    }
                    return true;
                }
                return false;
            }
        };
    }

    private static /* synthetic */ Pair lambda$getSortingWeights$0(Set lifted, LookupElement element2) {
        return new Pair((Object)element2, (Object)lifted.contains(element2));
    }

    private class LiftingIterable
    implements Iterable<LookupElement> {
        private final Set<LookupElement> mySrcSet;
        private final ProcessingContext myContext;
        private final Iterable<? extends LookupElement> mySource;
        private final Set<? super LookupElement> myLifted;

        LiftingIterable(Set<LookupElement> srcSet, ProcessingContext context, Iterable<? extends LookupElement> source, Set<? super LookupElement> lifted) {
            this.mySrcSet = srcSet;
            this.myContext = context;
            this.mySource = source;
            this.myLifted = lifted;
        }

        @Override
        public Iterator<LookupElement> iterator() {
            ReferenceOpenHashSet processed2 = new ReferenceOpenHashSet(this.mySrcSet.size());
            ReferenceOpenHashSet arraysProcessed = new ReferenceOpenHashSet();
            Iterable<? extends LookupElement> next = LiftShorterItemsClassifier.this.myNext.classify(this.mySource, this.myContext);
            Iterator base = FilteringIterator.create(next.iterator(), arg_0 -> LiftingIterable.lambda$iterator$0((Set)processed2, arg_0));
            return new FlatteningIterator<LookupElement, LookupElement>(base, (Set)arraysProcessed, (Set)processed2){
                final /* synthetic */ Set val$arraysProcessed;
                final /* synthetic */ Set val$processed;
                {
                    this.val$arraysProcessed = set;
                    this.val$processed = set2;
                    super(x0);
                }

                protected Iterator<LookupElement> createValueIterator(LookupElement element2) {
                    List<LookupElement> shorter = this.addShorterElements(LiftShorterItemsClassifier.this.myToLift.get((Object)element2));
                    List<LookupElement> singleton = Collections.singletonList(element2);
                    if (shorter != null) {
                        if (LiftingIterable.this.myLifted != null) {
                            LiftingIterable.this.myLifted.addAll(shorter);
                        }
                        Iterable<LookupElement> lifted = LiftShorterItemsClassifier.this.myNext.classify(shorter, LiftingIterable.this.myContext);
                        return (LiftShorterItemsClassifier.this.myLiftBefore ? ContainerUtil.concat(lifted, singleton) : ContainerUtil.concat(singleton, lifted)).iterator();
                    }
                    return singleton.iterator();
                }

                @Nullable
                private List<LookupElement> addShorterElements(@Nullable Collection<LookupElement> from) {
                    ArrayList<LookupElement> toLift = null;
                    if (from == null) {
                        return null;
                    }
                    if (this.val$arraysProcessed.add(from)) {
                        for (LookupElement shorterElement : from) {
                            if (!LiftingIterable.this.mySrcSet.contains(shorterElement) || !this.val$processed.add(shorterElement)) continue;
                            if (toLift == null) {
                                toLift = new ArrayList<LookupElement>();
                            }
                            toLift.add(shorterElement);
                        }
                    }
                    return toLift;
                }
            };
        }

        private static /* synthetic */ boolean lambda$iterator$0(Set processed2, LookupElement element2) {
            return processed2.add(element2);
        }
    }

    public static class LiftingCondition {
        public boolean shouldLift(LookupElement shorterElement, LookupElement longerElement) {
            return true;
        }
    }
}

