/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion.impl;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.util.containers.FList;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CamelHumpMatcher
extends PrefixMatcher {
    private final MinusculeMatcher myMatcher;
    private final MinusculeMatcher myCaseInsensitiveMatcher;
    private final boolean myCaseSensitive;
    private static boolean ourForceStartMatching;
    private final boolean myTypoTolerant;

    public CamelHumpMatcher(@NotNull String prefix) {
        this(prefix, true);
    }

    public CamelHumpMatcher(String prefix, boolean caseSensitive) {
        this(prefix, caseSensitive, false);
    }

    @ApiStatus.Internal
    public CamelHumpMatcher(String prefix, boolean caseSensitive, boolean typoTolerant) {
        super(prefix);
        this.myCaseSensitive = caseSensitive;
        this.myTypoTolerant = typoTolerant;
        this.myMatcher = this.createMatcher(this.myCaseSensitive);
        this.myCaseInsensitiveMatcher = this.createMatcher(false);
    }

    public boolean isStartMatch(String name) {
        return this.myMatcher.isStartMatch(name);
    }

    public boolean isStartMatch(LookupElement element2) {
        for (String s : CompletionUtil.iterateLookupStrings(element2)) {
            FList ranges = this.myCaseInsensitiveMatcher.matchingFragments(s);
            if (ranges == null || !ranges.isEmpty() && CamelHumpMatcher.skipUnderscores(s) < ((TextRange)ranges.get(0)).getStartOffset()) continue;
            return true;
        }
        return false;
    }

    @ApiStatus.Internal
    public boolean isTypoTolerant() {
        return this.myTypoTolerant;
    }

    private static int skipUnderscores(@NotNull String name) {
        return CharArrayUtil.shiftForward((CharSequence)name, (int)0, (String)"_");
    }

    public boolean prefixMatches(@NotNull String name) {
        if (name.startsWith("_") && CodeInsightSettings.getInstance().getCompletionCaseSensitive() == 3 && this.firstLetterCaseDiffers(name)) {
            return false;
        }
        return this.myMatcher.matches(name);
    }

    private boolean firstLetterCaseDiffers(String name) {
        int nameFirst = CamelHumpMatcher.skipUnderscores(name);
        int prefixFirst = CamelHumpMatcher.skipUnderscores(this.myPrefix);
        return nameFirst < name.length() && prefixFirst < this.myPrefix.length() && CamelHumpMatcher.caseDiffers(name.charAt(nameFirst), this.myPrefix.charAt(prefixFirst));
    }

    private static boolean caseDiffers(char c1, char c2) {
        return Character.isLowerCase(c1) != Character.isLowerCase(c2) || Character.isUpperCase(c1) != Character.isUpperCase(c2);
    }

    public boolean prefixMatches(@NotNull LookupElement element2) {
        return this.prefixMatchersInternal(element2, !element2.isCaseSensitive());
    }

    private boolean prefixMatchersInternal(LookupElement element2, boolean itemCaseInsensitive) {
        for (String name : element2.getAllLookupStrings()) {
            if (itemCaseInsensitive && StringUtil.startsWithIgnoreCase((String)name, (String)this.myPrefix) || this.prefixMatches(name)) {
                return true;
            }
            if (!itemCaseInsensitive || 1 == CodeInsightSettings.getInstance().getCompletionCaseSensitive() || !this.myCaseInsensitiveMatcher.matches(name)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public PrefixMatcher cloneWithPrefix(@NotNull String prefix) {
        if (prefix.equals(this.myPrefix)) {
            return this;
        }
        return new CamelHumpMatcher(prefix, this.myCaseSensitive, this.myTypoTolerant);
    }

    private MinusculeMatcher createMatcher(boolean caseSensitive) {
        String prefix = CamelHumpMatcher.applyMiddleMatching(this.myPrefix);
        NameUtil.MatcherBuilder builder2 = NameUtil.buildMatcher((String)prefix);
        if (caseSensitive) {
            int setting = CodeInsightSettings.getInstance().getCompletionCaseSensitive();
            if (setting == 3) {
                builder2 = builder2.withCaseSensitivity(NameUtil.MatchingCaseSensitivity.FIRST_LETTER);
            } else if (setting == 1) {
                builder2 = builder2.withCaseSensitivity(NameUtil.MatchingCaseSensitivity.ALL);
            }
        }
        if (this.myTypoTolerant) {
            builder2 = builder2.typoTolerant();
        }
        return builder2.build();
    }

    public static String applyMiddleMatching(String prefix) {
        if (Registry.is((String)"ide.completion.middle.matching") && !prefix.isEmpty() && !ourForceStartMatching) {
            return "*" + StringUtil.replace((String)prefix, (String)".", (String)". ").trim();
        }
        return prefix;
    }

    public String toString() {
        return this.myPrefix;
    }

    @Deprecated
    public static void forceStartMatching(Disposable parent) {
        ourForceStartMatching = true;
        Disposer.register((Disposable)parent, (Disposable)new Disposable(){

            public void dispose() {
                ourForceStartMatching = false;
            }
        });
    }

    public int matchingDegree(String string) {
        return this.matchingDegree(string, this.matchingFragments(string));
    }

    @Nullable
    public FList<TextRange> matchingFragments(String string) {
        return this.myMatcher.matchingFragments(string);
    }

    public int matchingDegree(String string, @Nullable FList<? extends TextRange> fragments) {
        int matchStart;
        FList ciRanges;
        int underscoreEnd = CamelHumpMatcher.skipUnderscores(string);
        if (underscoreEnd > 0 && (ciRanges = this.myCaseInsensitiveMatcher.matchingFragments(string)) != null && !ciRanges.isEmpty() && (matchStart = ((TextRange)ciRanges.get(0)).getStartOffset()) > 0 && matchStart <= underscoreEnd) {
            return this.myCaseInsensitiveMatcher.matchingDegree(string.substring(matchStart), true) - 1;
        }
        return this.myMatcher.matchingDegree(string, true, fragments);
    }
}

