/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.BaseCompletionLookupArranger;
import com.intellij.codeInsight.completion.CompletionProcessEx;
import com.intellij.codeInsight.completion.CompletionService;
import com.intellij.codeInsight.completion.StatisticsWeigher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.WeighingContext;
import com.intellij.codeInsight.lookup.impl.AsyncRendering;
import com.intellij.codeInsight.template.impl.LiveTemplateLookupElement;
import com.intellij.ide.ui.UISettings;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CompletionLookupArrangerImpl
extends BaseCompletionLookupArranger {
    private static final UISettings ourUISettings = UISettings.getInstance();

    public CompletionLookupArrangerImpl(CompletionProcessEx process2) {
        super(process2);
    }

    @Override
    public synchronized void addElement(@NotNull LookupElement element2, @NotNull LookupElementPresentation presentation2) {
        StatisticsWeigher.clearBaseStatisticsInfo(element2);
        super.addElement(element2, presentation2);
    }

    @Override
    protected boolean isAlphaSorted() {
        return ourUISettings.getSortLookupElementsLexicographically();
    }

    @Override
    @NotNull
    protected List<LookupElement> getExactMatches(List<? extends LookupElement> items) {
        String selectedText = InjectedLanguageUtil.getTopLevelEditor(this.myProcess.getParameters().getEditor()).getSelectionModel().getSelectedText();
        SmartList exactMatches = new SmartList();
        for (int i2 = 0; i2 < items.size(); ++i2) {
            LookupElement item = items.get(i2);
            boolean isSuddenLiveTemplate = CompletionLookupArrangerImpl.isSuddenLiveTemplate(item);
            if (this.isPrefixItem(item, true) && !isSuddenLiveTemplate || item.getLookupString().equals(selectedText)) {
                if (item instanceof LiveTemplateLookupElement) {
                    return Collections.singletonList(item);
                }
                exactMatches.add(item);
                continue;
            }
            if (i2 != 0 || !isSuddenLiveTemplate || items.size() <= 1 || CompletionService.isStartMatch((LookupElement)items.get(1), (WeighingContext)this)) continue;
            return Collections.singletonList(item);
        }
        return exactMatches;
    }

    @Override
    protected void removeItem(@NotNull LookupElement element2, @NotNull ProcessingContext context) {
        super.removeItem(element2, context);
        AsyncRendering.cancelRendering(element2);
    }

    private static boolean isSuddenLiveTemplate(LookupElement element2) {
        return element2 instanceof LiveTemplateLookupElement && ((LiveTemplateLookupElement)element2).sudden;
    }
}

