/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.build.progress;

import com.intellij.build.BuildDescriptor;
import com.intellij.build.BuildProgressListener;
import com.intellij.build.FilePosition;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.EventResult;
import com.intellij.build.events.MessageEvent;
import com.intellij.build.events.StartEvent;
import com.intellij.build.events.impl.FailureResultImpl;
import com.intellij.build.events.impl.FileMessageEventImpl;
import com.intellij.build.events.impl.FinishEventImpl;
import com.intellij.build.events.impl.MessageEventImpl;
import com.intellij.build.events.impl.OutputBuildEventImpl;
import com.intellij.build.events.impl.ProgressBuildEventImpl;
import com.intellij.build.events.impl.SkippedResultImpl;
import com.intellij.build.events.impl.StartEventImpl;
import com.intellij.build.events.impl.SuccessResultImpl;
import com.intellij.build.progress.BuildProgress;
import com.intellij.build.progress.BuildProgressDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.pom.Navigatable;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
class BuildProgressImpl
implements BuildProgress<BuildProgressDescriptor> {
    private final Object myId = new Object();
    private final BuildProgressListener myListener;
    @Nullable
    private final BuildProgress<BuildProgressDescriptor> myParentProgress;
    private BuildProgressDescriptor myDescriptor;

    BuildProgressImpl(BuildProgressListener listener2, @Nullable BuildProgress<BuildProgressDescriptor> parentProgress) {
        this.myListener = listener2;
        this.myParentProgress = parentProgress;
    }

    protected Object getBuildId() {
        return this.myDescriptor.getBuildDescriptor().getId();
    }

    @Override
    @NotNull
    public Object getId() {
        return this.myId;
    }

    @Override
    @NotNull
    public BuildProgress<BuildProgressDescriptor> start(@NotNull BuildProgressDescriptor descriptor2) {
        this.myDescriptor = descriptor2;
        StartEvent event = this.createStartEvent(descriptor2);
        this.myListener.onEvent(this.getBuildId(), (BuildEvent)event);
        return this;
    }

    @NotNull
    protected StartEvent createStartEvent(BuildProgressDescriptor descriptor2) {
        assert (this.myParentProgress != null);
        return new StartEventImpl(this.getId(), this.myParentProgress.getId(), System.currentTimeMillis(), descriptor2.getTitle());
    }

    @Override
    @NotNull
    public BuildProgress<BuildProgressDescriptor> startChildProgress(final @NotNull String title) {
        final BuildDescriptor buildDescriptor = this.myDescriptor.getBuildDescriptor();
        return new BuildProgressImpl(this.myListener, this).start(new BuildProgressDescriptor(){

            @Override
            @NotNull
            public String getTitle() {
                return title;
            }

            @Override
            @NotNull
            public BuildDescriptor getBuildDescriptor() {
                return buildDescriptor;
            }
        });
    }

    @Override
    @NotNull
    public BuildProgress<BuildProgressDescriptor> progress(@NotNull String title) {
        return this.progress(title, -1L, -1L, "");
    }

    @Override
    @NotNull
    public BuildProgress<BuildProgressDescriptor> progress(@NotNull String title, long total, long progress2, String unit) {
        Object parentId = this.myParentProgress != null ? this.myParentProgress.getId() : null;
        this.myListener.onEvent(this.getBuildId(), (BuildEvent)new ProgressBuildEventImpl(this.getId(), parentId, System.currentTimeMillis(), title, total, progress2, unit));
        return this;
    }

    @Override
    @NotNull
    public BuildProgress<BuildProgressDescriptor> output(@NotNull String text, boolean stdOut) {
        this.myListener.onEvent(this.getBuildId(), (BuildEvent)new OutputBuildEventImpl(this.getId(), text, stdOut));
        return this;
    }

    @Override
    @NotNull
    public BuildProgress<BuildProgressDescriptor> fileMessage(@NotNull String title, @NotNull String message, @NotNull MessageEvent.Kind kind, @NotNull FilePosition filePosition) {
        StringBuilder fileLink = new StringBuilder(filePosition.getFile().getPath());
        if (filePosition.getStartLine() > 0) {
            fileLink.append(":").append(filePosition.getStartLine() + 1);
            if (filePosition.getStartColumn() > 0) {
                fileLink.append(":").append(filePosition.getStartColumn() + 1);
            }
        }
        String detailedMessage = fileLink.toString() + '\n' + message;
        FileMessageEventImpl event = new FileMessageEventImpl(this.getId(), kind, null, title, detailedMessage, filePosition);
        this.myListener.onEvent(this.getBuildId(), (BuildEvent)event);
        return this;
    }

    @Override
    @NotNull
    public BuildProgress<BuildProgressDescriptor> message(@NotNull String title, @NotNull String message, @NotNull MessageEvent.Kind kind, final @Nullable Navigatable navigatable) {
        MessageEventImpl event = new MessageEventImpl(this.getId(), kind, null, title, message){

            @Override
            @Nullable
            public Navigatable getNavigatable(@NotNull Project project) {
                return navigatable;
            }
        };
        this.myListener.onEvent(this.getBuildId(), (BuildEvent)event);
        return this;
    }

    @Override
    @NotNull
    public BuildProgress<BuildProgressDescriptor> finish() {
        return this.finish(false);
    }

    @Override
    @NotNull
    public BuildProgress<BuildProgressDescriptor> finish(boolean isUpToDate) {
        return this.finish(System.currentTimeMillis(), isUpToDate, this.myDescriptor.getTitle());
    }

    @Override
    @NotNull
    public BuildProgress<BuildProgressDescriptor> finish(long timeStamp) {
        return this.finish(timeStamp, false, this.myDescriptor.getTitle());
    }

    @Override
    @NotNull
    public BuildProgress<BuildProgressDescriptor> finish(long timeStamp, boolean isUpToDate, @NotNull String message) {
        this.assertStarted();
        assert (this.myParentProgress != null);
        SuccessResultImpl result2 = new SuccessResultImpl(isUpToDate);
        FinishEventImpl event = new FinishEventImpl(this.getId(), this.myParentProgress.getId(), timeStamp, message, (EventResult)result2);
        this.myListener.onEvent(this.getBuildId(), (BuildEvent)event);
        return this.myParentProgress;
    }

    @Override
    @NotNull
    public BuildProgress<BuildProgressDescriptor> fail() {
        return this.fail(System.currentTimeMillis(), this.myDescriptor.getTitle());
    }

    @Override
    @NotNull
    public BuildProgress<BuildProgressDescriptor> fail(long timeStamp, @NotNull String message) {
        this.assertStarted();
        assert (this.myParentProgress != null);
        FinishEventImpl event = new FinishEventImpl(this.getId(), this.myParentProgress.getId(), timeStamp, message, (EventResult)new FailureResultImpl());
        this.myListener.onEvent(this.getBuildId(), (BuildEvent)event);
        return this.myParentProgress;
    }

    @Override
    @NotNull
    public BuildProgress<BuildProgressDescriptor> cancel() {
        return this.cancel(System.currentTimeMillis(), this.myDescriptor.getTitle());
    }

    @Override
    @NotNull
    public BuildProgress<BuildProgressDescriptor> cancel(long timeStamp, @NotNull String message) {
        this.assertStarted();
        assert (this.myParentProgress != null);
        FinishEventImpl event = new FinishEventImpl(this.getId(), this.myParentProgress.getId(), timeStamp, message, (EventResult)new SkippedResultImpl());
        this.myListener.onEvent(this.getBuildId(), (BuildEvent)event);
        return this.myParentProgress;
    }

    protected void assertStarted() {
        if (this.myDescriptor == null) {
            throw new IllegalStateException("The start event was not triggered yet.");
        }
    }
}

