/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.build.events.impl;

import com.intellij.build.FileNavigatable;
import com.intellij.build.FilePosition;
import com.intellij.build.events.BuildEventsNls;
import com.intellij.build.events.FileMessageEvent;
import com.intellij.build.events.FileMessageEventResult;
import com.intellij.build.events.MessageEvent;
import com.intellij.build.events.impl.MessageEventImpl;
import com.intellij.openapi.project.Project;
import com.intellij.pom.Navigatable;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileMessageEventImpl
extends MessageEventImpl
implements FileMessageEvent {
    private final FilePosition myFilePosition;

    public FileMessageEventImpl(@NotNull Object parentId, @NotNull MessageEvent.Kind kind, @Nullable @BuildEventsNls.Title String group, @NotNull @BuildEventsNls.Message String message, @Nullable @BuildEventsNls.Description String detailedMessage, @NotNull FilePosition filePosition) {
        super(parentId, kind, group, message, detailedMessage);
        this.myFilePosition = filePosition;
    }

    public FileMessageEventResult getResult() {
        return new FileMessageEventResult(){

            public FilePosition getFilePosition() {
                return FileMessageEventImpl.this.myFilePosition;
            }

            public MessageEvent.Kind getKind() {
                return FileMessageEventImpl.this.getKind();
            }

            @Nullable
            public String getDetails() {
                return FileMessageEventImpl.this.getDescription();
            }
        };
    }

    public FilePosition getFilePosition() {
        return this.myFilePosition;
    }

    @Override
    @Nullable
    public String getHint() {
        String hint = super.getHint();
        if (hint == null && this.myFilePosition.getStartLine() >= 0) {
            hint = ":" + (this.myFilePosition.getStartLine() + 1);
        }
        return hint;
    }

    @Override
    @Nullable
    public Navigatable getNavigatable(@NotNull Project project) {
        return new FileNavigatable(project, this.myFilePosition);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FileMessageEventImpl event = (FileMessageEventImpl)o;
        return Objects.equals(this.myFilePosition, event.myFilePosition);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.myFilePosition);
    }
}

