/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.build;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.ui.ComponentContainer;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import java.awt.CardLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public class CompositeView<T extends ComponentContainer>
extends JPanel
implements ComponentContainer,
DataProvider {
    private final Map<String, T> myViewMap = new ConcurrentHashMap<String, T>();
    private final String mySelectionStateKey;
    private final AtomicReference<String> myVisibleViewRef = new AtomicReference();
    @NotNull
    private final SwitchViewAction mySwitchViewAction;

    public CompositeView(String selectionStateKey) {
        super(new CardLayout());
        this.mySelectionStateKey = selectionStateKey;
        this.mySwitchViewAction = new SwitchViewAction();
    }

    public void addView(@NotNull T view, @NotNull String viewName) {
        T oldView = this.getView(viewName);
        if (oldView != null) {
            this.remove(oldView.getComponent());
            Disposer.dispose(oldView);
        }
        this.myViewMap.put(viewName, view);
        this.add((Component)view.getComponent(), viewName);
        Disposer.register((Disposable)this, view);
    }

    public void addViewAndShowIfNeeded(@NotNull T view, @NotNull String viewName, boolean showByDefault) {
        this.addView(view, viewName);
        String storedState = this.getStoredState();
        if (storedState != null && storedState.equals(viewName) || storedState == null && showByDefault) {
            this.showView(viewName);
        }
    }

    public void showView(@NotNull String viewName) {
        this.showView(viewName, true);
        this.setStoredState(viewName);
    }

    public void showView(@NotNull String viewName, boolean requestFocus) {
        if (!StringUtil.equals((CharSequence)viewName, (CharSequence)this.myVisibleViewRef.get())) {
            this.myVisibleViewRef.set(viewName);
            CardLayout cl = (CardLayout)this.getLayout();
            cl.show(this, viewName);
        }
        if (requestFocus) {
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> {
                T view = this.getView(viewName);
                if (view != null) {
                    IdeFocusManager.getGlobalInstance().requestFocus((Component)view.getPreferredFocusableComponent(), true);
                }
            });
        }
    }

    public boolean isViewVisible(String viewName) {
        return StringUtil.equals((CharSequence)this.myVisibleViewRef.get(), (CharSequence)viewName);
    }

    public T getView(@NotNull String viewName) {
        return (T)((ComponentContainer)this.myViewMap.get(viewName));
    }

    @Nullable
    public <U> U getView(@NotNull String viewName, @NotNull Class<U> viewClass) {
        T view = this.getView(viewName);
        return viewClass.isInstance(view) ? (U)viewClass.cast(view) : null;
    }

    public AnAction @NotNull [] createConsoleActions() {
        return AnAction.EMPTY_ARRAY;
    }

    public AnAction @NotNull [] getSwitchActions() {
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        actionGroup.addSeparator();
        actionGroup.add((AnAction)this.mySwitchViewAction);
        return new AnAction[]{actionGroup};
    }

    @NotNull
    public JComponent getComponent() {
        return this;
    }

    public JComponent getPreferredFocusableComponent() {
        return this;
    }

    public void dispose() {
    }

    @Nullable
    public Object getData(@NotNull @NonNls String dataId) {
        Object data2;
        T visibleView;
        String visibleViewName = this.myVisibleViewRef.get();
        if (visibleViewName != null && (visibleView = this.getView(visibleViewName)) instanceof DataProvider && (data2 = ((DataProvider)visibleView).getData(dataId)) != null) {
            return data2;
        }
        return null;
    }

    private void setStoredState(String viewName) {
        if (this.mySelectionStateKey != null) {
            PropertiesComponent.getInstance().setValue(this.mySelectionStateKey, viewName);
        }
    }

    @Nullable
    private String getStoredState() {
        return this.mySelectionStateKey == null ? null : PropertiesComponent.getInstance().getValue(this.mySelectionStateKey);
    }

    private final class SwitchViewAction
    extends ToggleAction
    implements DumbAware {
        SwitchViewAction() {
            super(IdeBundle.messagePointer((String)"action.ToggleAction.text.toggle.view", (Object[])new Object[0]), Presentation.NULL_STRING, AllIcons.Actions.ChangeView);
        }

        public void update(@NotNull AnActionEvent e) {
            Presentation presentation2 = e.getPresentation();
            if (CompositeView.this.myViewMap.size() <= 1) {
                presentation2.setEnabledAndVisible(false);
            } else {
                presentation2.setEnabledAndVisible(true);
                Toggleable.setSelected((Presentation)presentation2, (boolean)this.isSelected(e));
            }
        }

        public boolean isSelected(@NotNull AnActionEvent event) {
            String visibleViewName = (String)CompositeView.this.myVisibleViewRef.get();
            if (visibleViewName == null) {
                return true;
            }
            Set viewNames = CompositeView.this.myViewMap.keySet();
            return viewNames.isEmpty() || visibleViewName.equals(viewNames.iterator().next());
        }

        public void setSelected(@NotNull AnActionEvent event, boolean flag) {
            if (CompositeView.this.myViewMap.size() > 1) {
                ArrayList names2 = new ArrayList(CompositeView.this.myViewMap.keySet());
                String viewName = flag ? (String)names2.get(0) : (String)names2.get(1);
                CompositeView.this.showView(viewName);
                ApplicationManager.getApplication().invokeLater(() -> this.update(event));
            }
        }
    }
}

