/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.schemes;

import com.intellij.configurationStore.SerializableScheme;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SchemeExporter;
import com.intellij.openapi.project.Project;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SerializableSchemeExporter
extends SchemeExporter<Scheme> {
    public void exportScheme(@Nullable Project project, @NotNull Scheme scheme, @NotNull OutputStream outputStream) throws Exception {
        this.exportScheme(scheme, outputStream);
    }

    @Deprecated
    public void exportScheme(@NotNull Scheme scheme, @NotNull OutputStream outputStream) throws Exception {
        assert (scheme instanceof SerializableScheme);
        SerializableSchemeExporter.writeToStream((SerializableScheme)scheme, outputStream);
    }

    public static void writeToStream(@NotNull SerializableScheme scheme, @NotNull OutputStream outputStream) throws IOException {
        SerializableSchemeExporter.writeToStream(outputStream, scheme.writeScheme());
    }

    public String getExtension() {
        return "xml";
    }

    private static void writeToStream(@NotNull OutputStream outputStream, @NotNull Element element2) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(outputStream, StandardCharsets.UTF_8);
        Format format = Format.getPrettyFormat();
        format.setLineSeparator("\n");
        new XMLOutputter(format).output(element2, (Writer)writer);
    }
}

