/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.schemes;

import com.intellij.application.options.schemes.AbstractSchemesPanel;
import com.intellij.application.options.schemes.DescriptionAwareSchemeActions;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.ui.AbstractPainter;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Painter;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeGlassPaneUtil;
import com.intellij.ui.ClickListener;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.GraphicsUtil;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractDescriptionAwareSchemesPanel<T extends Scheme>
extends AbstractSchemesPanel<T, JPanel>
implements Disposable {
    private static final String SHOW_DESCRIPTION_CARD = "show.description.card";
    private static final String EDIT_DESCRIPTION_CARD = "edit.description.card";
    private static final String ERROR_CARD = "error.card";
    private static final KeyStroke ESC_KEY_STROKE = KeyStroke.getKeyStroke(27, 0, false);
    private static final KeyStroke ENTER_KEY_STROKE = KeyStroke.getKeyStroke(10, 0, false);
    private DescriptionLabel myDescriptionLabel;
    private JLabel myWarningLabel;
    private JBTextField myDescriptionTextField;
    private CardLayout myLayout;
    private AbstractPainter myPainter;

    protected AbstractDescriptionAwareSchemesPanel() {
        super(0);
    }

    @Override
    @NotNull
    protected JPanel createInfoComponent() {
        JPanel panel2 = new JPanel();
        this.myLayout = new CardLayout();
        panel2.setLayout(this.myLayout);
        this.myDescriptionTextField = new JBTextField();
        this.myDescriptionTextField.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                AbstractDescriptionAwareSchemesPanel.this.showDescription(AbstractDescriptionAwareSchemesPanel.this.getSelectedScheme());
            }
        });
        this.myDescriptionTextField.registerKeyboardAction(__ -> {
            this.showDescription(this.getSelectedScheme());
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.getConfigurableFocusComponent(), true));
        }, ESC_KEY_STROKE, 0);
        this.myDescriptionTextField.registerKeyboardAction(__ -> {
            this.applyDescription();
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.getConfigurableFocusComponent(), true));
        }, ENTER_KEY_STROKE, 0);
        this.myDescriptionLabel = new DescriptionLabel();
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent event, int clickCount) {
                if (clickCount != 2) {
                    return false;
                }
                AbstractDescriptionAwareSchemesPanel.this.editDescription(AbstractDescriptionAwareSchemesPanel.this.myDescriptionLabel.getText());
                return true;
            }
        }.installOn((Component)((Object)this.myDescriptionLabel));
        this.myWarningLabel = new JLabel();
        panel2.add((Component)this.myDescriptionTextField, EDIT_DESCRIPTION_CARD);
        panel2.add((Component)((Object)this.myDescriptionLabel), SHOW_DESCRIPTION_CARD);
        panel2.add((Component)this.myWarningLabel, ERROR_CARD);
        this.myLayout.show(panel2, ERROR_CARD);
        this.myPainter = new AbstractPainter(){

            public boolean needsRepaint() {
                return true;
            }

            public void executePaint(Component component2, Graphics2D g) {
                if (AbstractDescriptionAwareSchemesPanel.this.myDescriptionTextField.isShowing()) {
                    GraphicsUtil.setupAntialiasing((Graphics)g);
                    g.setColor((Color)JBColor.GRAY);
                    g.drawString("Enter to save, Esc to cancel", 0, -JBUIScale.scale((int)5));
                }
            }
        };
        IdeGlassPaneUtil.installPainter((JComponent)panel2, (Painter)this.myPainter, (Disposable)this);
        return panel2;
    }

    @Override
    public final void showMessage(@Nullable String message, @NotNull MessageType messageType) {
        AbstractDescriptionAwareSchemesPanel.showMessage(message, messageType, this.myWarningLabel);
        this.myLayout.show(this.myInfoComponent, ERROR_CARD);
    }

    @Override
    public void selectScheme(@Nullable T scheme) {
        super.selectScheme(scheme);
        if (scheme != null) {
            this.showDescription(scheme);
        }
    }

    @Override
    public final void clearMessage() {
        this.myLayout.show(this.myInfoComponent, SHOW_DESCRIPTION_CARD);
    }

    void showDescription(@NotNull T scheme) {
        String newDescription = ((DescriptionAwareSchemeActions)this.getActions()).getDescription(scheme);
        this.myDescriptionLabel.setAllText(StringUtil.notNullize((String)newDescription));
        this.myLayout.show(this.myInfoComponent, SHOW_DESCRIPTION_CARD);
        this.myPainter.setNeedsRepaint(true);
    }

    void editDescription(@Nullable String startValue) {
        this.myLayout.show(this.myInfoComponent, EDIT_DESCRIPTION_CARD);
        this.myDescriptionTextField.setText(StringUtil.notNullize((String)startValue));
        SwingUtilities.invokeLater(() -> IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.myDescriptionTextField, true)));
        this.myPainter.setNeedsRepaint(true);
    }

    @NotNull
    protected abstract JComponent getConfigurableFocusComponent();

    private void applyDescription() {
        Object scheme = this.getSelectedScheme();
        ((DescriptionAwareSchemeActions)this.getActions()).setDescription(scheme, this.myDescriptionTextField.getText());
        this.showDescription(scheme);
    }

    public void dispose() {
    }

    private static class DescriptionLabel
    extends JBLabel {
        private String myAllText = "";

        DescriptionLabel() {
            this.setForeground((Color)JBColor.GRAY);
            this.setVerticalAlignment(0);
            this.setHorizontalAlignment(2);
            this.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    this.calculateText();
                }
            });
        }

        public void setAllText(String allText) {
            this.myAllText = allText;
            this.calculateText();
            this.revalidate();
            this.repaint();
        }

        private void calculateText() {
            FontMetrics metrics = this.getFontMetrics(this.getFont());
            int width = this.getSize().width - metrics.stringWidth("...");
            if (width <= 0) {
                this.setText("...");
                this.setToolTipText(this.myAllText);
            }
            char[] text = this.myAllText.toCharArray();
            int[] charsWidth = new int[text.length];
            for (int i2 = 0; i2 < text.length; ++i2) {
                int w = metrics.charWidth(text[i2]);
                for (int j = 0; j <= i2; ++j) {
                    int n = i2;
                    charsWidth[n] = charsWidth[n] + w;
                }
            }
            int idx = Arrays.binarySearch(charsWidth, 0, charsWidth.length, width);
            if (idx < 0) {
                idx = -idx - 1;
            }
            if (idx < this.myAllText.length()) {
                this.setText(this.myAllText.substring(0, idx) + "...");
                this.setToolTipText(this.myAllText.substring(idx));
            } else {
                this.setText(this.myAllText.substring(0, idx));
            }
        }
    }
}

