/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.colors.highlighting;

import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.markup.TextAttributes;
import java.awt.Graphics;
import java.awt.Rectangle;
import org.jetbrains.annotations.NotNull;

public class RendererWrapper
implements EditorCustomElementRenderer {
    private final EditorCustomElementRenderer myDelegate;
    private boolean myDrawBorder;

    public RendererWrapper(EditorCustomElementRenderer delegate, boolean drawBorder) {
        this.myDelegate = delegate;
        this.myDrawBorder = drawBorder;
    }

    public int calcWidthInPixels(@NotNull Inlay inlay) {
        return this.myDelegate.calcWidthInPixels(inlay);
    }

    public int calcHeightInPixels(@NotNull Inlay inlay) {
        return this.myDelegate.calcHeightInPixels(inlay);
    }

    public void paint(@NotNull Inlay inlay, @NotNull Graphics g, @NotNull Rectangle r, @NotNull TextAttributes textAttributes) {
        TextAttributes attributes;
        this.myDelegate.paint(inlay, g, r, textAttributes);
        if (this.myDrawBorder && (attributes = inlay.getEditor().getColorsScheme().getAttributes(CodeInsightColors.BLINKING_HIGHLIGHTS_ATTRIBUTES)) != null && attributes.getEffectColor() != null) {
            g.setColor(attributes.getEffectColor());
            g.drawRect(r.x, r.y, r.width, r.height);
        }
    }
}

