/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.colors.highlighting;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HighlightData {
    private final int myStartOffset;
    private int myEndOffset;
    private final TextAttributesKey myHighlightType;
    private final ColorKey myAdditionalColorKey;

    public HighlightData(int startOffset, TextAttributesKey highlightType, @Nullable ColorKey additionalColorKey) {
        this.myStartOffset = startOffset;
        this.myHighlightType = highlightType;
        this.myAdditionalColorKey = additionalColorKey;
    }

    public HighlightData(int startOffset, int endOffset, TextAttributesKey highlightType) {
        this(startOffset, endOffset, highlightType, null);
    }

    public HighlightData(int startOffset, int endOffset, TextAttributesKey highlightType, @Nullable ColorKey additionalColorKey) {
        this.myStartOffset = startOffset;
        this.myEndOffset = endOffset;
        this.myHighlightType = highlightType;
        this.myAdditionalColorKey = additionalColorKey;
    }

    public void addToCollection(@NotNull Collection<? super HighlightData> list2, boolean highlighted) {
        list2.add(this);
        if (highlighted) {
            list2.add(new HighlightData(this.getStartOffset(), this.getEndOffset(), CodeInsightColors.BLINKING_HIGHLIGHTS_ATTRIBUTES, this.getAdditionalColorKey()));
        }
    }

    public void addHighlToView(Editor view, EditorColorsScheme scheme, Map<TextAttributesKey, String> displayText) {
        if (HighlighterColors.BAD_CHARACTER.equals((Object)this.myHighlightType)) {
            return;
        }
        TextAttributes attr = scheme.getAttributes(this.myHighlightType);
        if (attr != null) {
            UIUtil.invokeAndWaitIfNeeded(() -> {
                try {
                    RangeHighlighter erasedHighlighter = view.getMarkupModel().addRangeHighlighter(this.myHighlightType, this.myStartOffset, this.myEndOffset, 3000, HighlighterTargetArea.EXACT_RANGE);
                    if (erasedHighlighter instanceof RangeHighlighterEx) {
                        ((RangeHighlighterEx)erasedHighlighter).setTextAttributes(TextAttributes.ERASE_MARKER);
                    }
                    RangeHighlighter highlighter = view.getMarkupModel().addRangeHighlighter(this.myHighlightType, this.myStartOffset, this.myEndOffset, 3000, HighlighterTargetArea.EXACT_RANGE);
                    Color errorStripeColor = attr.getErrorStripeColor();
                    highlighter.setErrorStripeMarkColor(errorStripeColor);
                    String tooltip = (String)displayText.get(this.myHighlightType);
                    highlighter.setErrorStripeTooltip((Object)tooltip);
                    if (highlighter instanceof RangeHighlighterEx) {
                        ((RangeHighlighterEx)highlighter).setVisibleIfFolded(true);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
        }
    }

    public int getStartOffset() {
        return this.myStartOffset;
    }

    public int getEndOffset() {
        return this.myEndOffset;
    }

    public void setEndOffset(int endOffset) {
        this.myEndOffset = endOffset;
    }

    public String getHighlightType() {
        return this.myHighlightType.getExternalName();
    }

    public TextAttributesKey getHighlightKey() {
        return this.myHighlightType;
    }

    public ColorKey getAdditionalColorKey() {
        return this.myAdditionalColorKey;
    }
}

