/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.colors;

import com.intellij.codeHighlighting.RainbowHighlighter;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.colors.TextAttributesScheme;
import com.intellij.openapi.options.SchemeMetaInfo;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RainbowColorsInSchemeState {
    private final EditorColorsScheme myEditedScheme;
    private final EditorColorsScheme myOriginalScheme;

    public RainbowColorsInSchemeState(@NotNull EditorColorsScheme editedScheme, @NotNull EditorColorsScheme originalScheme) {
        this.myEditedScheme = editedScheme;
        this.myOriginalScheme = originalScheme;
    }

    public void apply(@Nullable EditorColorsScheme scheme) {
        if (scheme != null && scheme != this.myEditedScheme) {
            RainbowHighlighter.transferRainbowState((SchemeMetaInfo)scheme, (SchemeMetaInfo)this.myEditedScheme);
            for (TextAttributesKey key : RainbowHighlighter.RAINBOW_COLOR_KEYS) {
                Color color = this.myEditedScheme.getAttributes(key).getForegroundColor();
                if (color.equals(scheme.getAttributes(key).getForegroundColor())) continue;
                scheme.setAttributes(key, RainbowHighlighter.createRainbowAttribute(color));
            }
            RainbowColorsInSchemeState.updateRainbowMarkup();
        }
    }

    private static void updateRainbowMarkup() {
        Editor[] allEditors;
        for (Editor editor : allEditors = EditorFactory.getInstance().getAllEditors()) {
            PsiFile file2;
            Project project = editor.getProject();
            if (project == null || (file2 = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument())) == null) continue;
            DaemonCodeAnalyzer.getInstance((Project)project).restart(file2);
        }
    }

    public boolean isModified(@Nullable Language language) {
        return language == null && this.isRainbowColorsModified() || RainbowHighlighter.isRainbowEnabled((TextAttributesScheme)this.myEditedScheme, language) != RainbowHighlighter.isRainbowEnabled((TextAttributesScheme)this.myOriginalScheme, language);
    }

    private boolean isRainbowColorsModified() {
        for (TextAttributesKey key : RainbowHighlighter.RAINBOW_COLOR_KEYS) {
            if (this.myEditedScheme.getAttributes(key).equals((Object)this.myOriginalScheme.getAttributes(key))) continue;
            return true;
        }
        return false;
    }
}

