/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle.arrangement.match.tokens;

import com.intellij.application.options.codeStyle.arrangement.color.ArrangementColorsProvider;
import com.intellij.application.options.codeStyle.arrangement.match.ArrangementMatchingRulesControl;
import com.intellij.application.options.codeStyle.arrangement.match.tokens.ArrangementRuleAliasControl;
import com.intellij.application.options.codeStyle.arrangement.util.TitleWithToolbar;
import com.intellij.ide.ui.customization.CustomizationUtil;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.psi.codeStyle.arrangement.match.StdArrangementMatchRule;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementStandardSettingsManager;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.GridBag;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JViewport;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArrangementRuleAliasesPanel
extends JPanel
implements DataProvider {
    @NotNull
    protected final ArrangementRuleAliasControl myControl;

    public ArrangementRuleAliasesPanel(@NotNull ArrangementStandardSettingsManager settingsManager, @NotNull ArrangementColorsProvider colorsProvider) {
        super(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 5));
        JBScrollPane scrollPane = new JBScrollPane();
        final JViewport viewport = scrollPane.getViewport();
        ArrangementMatchingRulesControl.RepresentationCallback callback2 = new ArrangementMatchingRulesControl.RepresentationCallback(){

            @Override
            public void ensureVisible(@NotNull Rectangle r) {
                Rectangle visibleRect = viewport.getViewRect();
                if (r.y <= visibleRect.y) {
                    return;
                }
                int excessiveHeight = r.y + r.height - (visibleRect.y + visibleRect.height);
                if (excessiveHeight <= 0) {
                    return;
                }
                int verticalShift = Math.min(r.y - visibleRect.y, excessiveHeight);
                if (verticalShift > 0) {
                    viewport.setViewPosition(new Point(visibleRect.x, visibleRect.y + verticalShift));
                }
            }
        };
        this.myControl = new ArrangementRuleAliasControl(settingsManager, colorsProvider, callback2);
        scrollPane.setViewportView((Component)((Object)this.myControl));
        CustomizationUtil.installPopupHandler((JComponent)((Object)this.myControl), "Arrangement.Alias.Rule.Context.Menu", "Arrangement.Alias.Rule.Control.Place");
        TitleWithToolbar top = new TitleWithToolbar(ApplicationBundle.message((String)"arrangement.settings.section.rule.sequence", (Object[])new Object[0]), "Arrangement.Alias.Rule.ToolBar", "Arrangement.Alias.Rule.ToolBar.Place", (JComponent)((Object)this.myControl));
        this.add((Component)top, new GridBag().coverLine().fillCellHorizontally().weightx(1.0));
        this.add((Component)scrollPane, new GridBag().fillCell().weightx(1.0).weighty(1.0).insets(0, 8, 0, 0));
    }

    @NotNull
    public List<StdArrangementMatchRule> getRuleSequences() {
        return this.myControl.getRuleSequences();
    }

    public void setRuleSequences(@Nullable Collection<? extends StdArrangementMatchRule> rules) {
        this.myControl.setRuleSequences(rules);
    }

    @Nullable
    public Object getData(@NotNull @NonNls String dataId) {
        if (ArrangementRuleAliasControl.KEY.is(dataId)) {
            return this.myControl;
        }
        return null;
    }
}

