/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle.arrangement.match;

import com.intellij.application.options.codeStyle.arrangement.color.ArrangementColorsProvider;
import com.intellij.application.options.codeStyle.arrangement.match.ArrangementMatchingRuleEditor;
import com.intellij.application.options.codeStyle.arrangement.match.ArrangementSectionRulesControl;
import com.intellij.lang.Commenter;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageCommenters;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.arrangement.ArrangementUtil;
import com.intellij.psi.codeStyle.arrangement.match.StdArrangementEntryMatcher;
import com.intellij.psi.codeStyle.arrangement.match.StdArrangementMatchRule;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementAtomMatchCondition;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementCompositeMatchCondition;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementMatchCondition;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementMatchConditionVisitor;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementStandardSettingsManager;
import com.intellij.psi.codeStyle.arrangement.std.CompositeArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementTokens;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArrangementSectionRuleManager {
    private static final Set<ArrangementSettingsToken> MUTEXES = ContainerUtil.newHashSet((Object[])new ArrangementSettingsToken[]{StdArrangementTokens.Section.START_SECTION, StdArrangementTokens.Section.END_SECTION});
    private static final Set<ArrangementSettingsToken> TOKENS = ContainerUtil.newHashSet((Object[])new ArrangementSettingsToken[]{StdArrangementTokens.Section.START_SECTION, StdArrangementTokens.Section.END_SECTION, StdArrangementTokens.Regexp.TEXT});
    private final Commenter myCommenter;
    private final ArrangementSectionRulesControl myControl;
    private final ArrangementMatchingRuleEditor myEditor;

    @Nullable
    public static ArrangementSectionRuleManager getInstance(@NotNull Language language, @NotNull ArrangementStandardSettingsManager settingsManager, @NotNull ArrangementColorsProvider colorsProvider, @NotNull ArrangementSectionRulesControl control) {
        if (settingsManager.isSectionRulesSupported()) {
            return new ArrangementSectionRuleManager(language, settingsManager, colorsProvider, control);
        }
        return null;
    }

    private ArrangementSectionRuleManager(@NotNull Language language, @NotNull ArrangementStandardSettingsManager settingsManager, @NotNull ArrangementColorsProvider colorsProvider, @NotNull ArrangementSectionRulesControl control) {
        this.myCommenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage(language);
        this.myControl = control;
        ArrayList<CompositeArrangementSettingsToken> tokens = new ArrayList<CompositeArrangementSettingsToken>();
        tokens.add(new CompositeArrangementSettingsToken(StdArrangementTokens.General.TYPE, (Collection)ContainerUtil.newArrayList((Object[])new ArrangementSettingsToken[]{StdArrangementTokens.Section.START_SECTION, StdArrangementTokens.Section.END_SECTION})));
        tokens.add(new CompositeArrangementSettingsToken((ArrangementSettingsToken)StdArrangementTokens.Regexp.TEXT));
        this.myEditor = new ArrangementMatchingRuleEditor(settingsManager, tokens, colorsProvider, control);
    }

    public ArrangementMatchingRuleEditor getEditor() {
        return this.myEditor;
    }

    @NotNull
    public static Set<ArrangementSettingsToken> getSectionMutexes() {
        return MUTEXES;
    }

    public static boolean isEnabled(@NotNull ArrangementSettingsToken token) {
        return TOKENS.contains(token);
    }

    public void showEditor(int rowToEdit) {
        this.myControl.showEditor(this.myEditor, rowToEdit);
    }

    public boolean isSectionRule(@Nullable Object element2) {
        return element2 instanceof StdArrangementMatchRule && this.getSectionRuleData((StdArrangementMatchRule)element2) != null;
    }

    @Nullable
    public ArrangementSectionRuleData getSectionRuleData(@NotNull StdArrangementMatchRule element2) {
        ArrangementMatchCondition condition = element2.getMatcher().getCondition();
        return this.getSectionRuleData(condition);
    }

    @Nullable
    public ArrangementSectionRuleData getSectionRuleData(@NotNull ArrangementMatchCondition condition) {
        final Ref isStart = new Ref();
        final Ref text = new Ref();
        condition.invite(new ArrangementMatchConditionVisitor(){

            public void visit(@NotNull ArrangementAtomMatchCondition condition) {
                ArrangementSettingsToken type = condition.getType();
                if (type.equals((Object)StdArrangementTokens.Section.START_SECTION)) {
                    isStart.set((Object)true);
                } else if (type.equals((Object)StdArrangementTokens.Section.END_SECTION)) {
                    isStart.set((Object)false);
                } else if (type.equals((Object)StdArrangementTokens.Regexp.TEXT)) {
                    text.set((Object)condition.getValue().toString());
                }
            }

            public void visit(@NotNull ArrangementCompositeMatchCondition condition) {
                for (ArrangementMatchCondition c : condition.getOperands()) {
                    c.invite((ArrangementMatchConditionVisitor)this);
                    if (text.isNull() || isStart.isNull()) continue;
                    return;
                }
            }
        });
        if (isStart.isNull()) {
            return null;
        }
        return new ArrangementSectionRuleData(this.processSectionText(StringUtil.notNullize((String)((String)text.get()))), (Boolean)isStart.get());
    }

    @NotNull
    public StdArrangementMatchRule createDefaultSectionRule() {
        ArrangementAtomMatchCondition type = new ArrangementAtomMatchCondition(StdArrangementTokens.Section.START_SECTION);
        ArrangementAtomMatchCondition text = new ArrangementAtomMatchCondition((ArrangementSettingsToken)StdArrangementTokens.Regexp.TEXT, (Object)this.createDefaultSectionText());
        ArrangementMatchCondition condition = ArrangementUtil.combine((ArrangementMatchCondition[])new ArrangementMatchCondition[]{type, text});
        return new StdArrangementMatchRule(new StdArrangementEntryMatcher(condition));
    }

    @NotNull
    private String processSectionText(@NotNull String text) {
        String lineCommentPrefix = this.myCommenter.getLineCommentPrefix();
        if (lineCommentPrefix != null && text.startsWith(lineCommentPrefix)) {
            return text;
        }
        String prefix = this.myCommenter.getBlockCommentPrefix();
        String suffix = this.myCommenter.getBlockCommentSuffix();
        if (prefix != null && suffix != null && text.length() >= prefix.length() + suffix.length() && text.startsWith(prefix) && text.endsWith(suffix)) {
            return text;
        }
        return lineCommentPrefix != null ? ArrangementSectionRuleManager.wrapIntoLineComment(lineCommentPrefix, text) : (prefix != null && suffix != null ? ArrangementSectionRuleManager.wrapIntoBlockComment(prefix, suffix, text) : "");
    }

    @NotNull
    private String createDefaultSectionText() {
        if (this.myCommenter != null) {
            String lineCommentPrefix = this.myCommenter.getLineCommentPrefix();
            if (StringUtil.isNotEmpty((String)lineCommentPrefix)) {
                return ArrangementSectionRuleManager.wrapIntoLineComment(lineCommentPrefix, "");
            }
            String prefix = this.myCommenter.getBlockCommentPrefix();
            String suffix = this.myCommenter.getBlockCommentSuffix();
            if (StringUtil.isNotEmpty((String)prefix) && StringUtil.isNotEmpty((String)suffix)) {
                return ArrangementSectionRuleManager.wrapIntoBlockComment(prefix, suffix, " ");
            }
        }
        return "";
    }

    private static String wrapIntoBlockComment(@NotNull String prefix, @NotNull String suffix, @NotNull String text) {
        return prefix + text + suffix;
    }

    private static String wrapIntoLineComment(@NotNull String lineCommentPrefix, @NotNull String text) {
        return lineCommentPrefix + text;
    }

    public static class ArrangementSectionRuleData {
        private final boolean myIsSectionStart;
        private final String myText;

        private ArrangementSectionRuleData(@NotNull String text, boolean isStart) {
            this.myText = text;
            this.myIsSectionStart = isStart;
        }

        public boolean isSectionStart() {
            return this.myIsSectionStart;
        }

        @NotNull
        public String getText() {
            return this.myText;
        }
    }
}

