/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle;

import com.intellij.application.options.codeStyle.CodeStyleSchemesActions;
import com.intellij.application.options.codeStyle.CodeStyleSchemesModel;
import com.intellij.application.options.schemes.AbstractSchemeActions;
import com.intellij.application.options.schemes.SchemesModel;
import com.intellij.application.options.schemes.SimpleSchemesPanel;
import com.intellij.icons.AllIcons;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.codeStyle.CodeStyleScheme;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.modifier.CodeStyleSettingsModifier;
import com.intellij.psi.impl.source.codeStyle.CodeStyleSchemeImpl;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.labels.LinkListener;
import com.intellij.util.ui.JBDimension;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.util.ArrayList;
import java.util.function.Consumer;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeStyleSchemesPanel
extends SimpleSchemesPanel<CodeStyleScheme> {
    private final CodeStyleSchemesModel myModel;
    private boolean myIsReset;
    private JLabel myBottomLabel;
    private JPanel myBottomPanel;

    public CodeStyleSchemesPanel(CodeStyleSchemesModel model, int vGap) {
        super(vGap);
        this.myModel = model;
    }

    CodeStyleSchemesPanel(CodeStyleSchemesModel model) {
        super(8);
        this.myModel = model;
        this.showOverridingMessage(this.myModel.getOverridingStatus());
    }

    private void onCombo() {
        CodeStyleScheme selected2 = (CodeStyleScheme)this.getSelectedScheme();
        if (selected2 != null) {
            this.myModel.selectScheme(selected2, this);
        }
    }

    public void resetSchemesCombo() {
        this.myIsReset = true;
        try {
            ArrayList<CodeStyleScheme> schemes = new ArrayList<CodeStyleScheme>(this.myModel.getAllSortedSchemes());
            this.resetSchemes(schemes);
            this.selectScheme(this.myModel.getSelectedScheme());
        }
        finally {
            this.myIsReset = false;
        }
    }

    public void onSelectedSchemeChanged() {
        this.myIsReset = true;
        try {
            this.selectScheme(this.myModel.getSelectedScheme());
        }
        finally {
            this.myIsReset = false;
        }
    }

    @Override
    @NotNull
    protected AbstractSchemeActions<CodeStyleScheme> createSchemeActions() {
        return new CodeStyleSchemesActions(this){

            @Override
            protected void onSchemeChanged(@Nullable CodeStyleScheme scheme) {
                if (!CodeStyleSchemesPanel.this.myIsReset) {
                    ApplicationManager.getApplication().invokeLater(() -> CodeStyleSchemesPanel.this.onCombo());
                }
            }

            @Override
            protected void renameScheme(@NotNull CodeStyleScheme scheme, @NotNull String newName) {
                CodeStyleSchemeImpl newScheme = new CodeStyleSchemeImpl(newName, false, scheme);
                CodeStyleSchemesPanel.this.myModel.addScheme(newScheme, false);
                CodeStyleSchemesPanel.this.myModel.removeScheme(scheme);
                CodeStyleSchemesPanel.this.myModel.selectScheme(newScheme, null);
            }
        };
    }

    @Override
    @NotNull
    public SchemesModel<CodeStyleScheme> getModel() {
        return this.myModel;
    }

    @Override
    protected boolean supportsProjectSchemes() {
        return true;
    }

    @Override
    protected boolean highlightNonDefaultSchemes() {
        return true;
    }

    @Override
    public boolean useBoldForNonRemovableSchemes() {
        return true;
    }

    @Override
    @Nullable
    protected JComponent createBottomComponent() {
        this.myBottomPanel = new JPanel(new FlowLayout(0));
        JLabel iconLabel = new JLabel();
        iconLabel.setIcon(AllIcons.General.Warning);
        this.myBottomPanel.add(iconLabel);
        this.myBottomPanel.add(Box.createRigidArea((Dimension)new JBDimension(5, 0)));
        this.myBottomLabel = new JLabel();
        this.myBottomPanel.add(this.myBottomLabel);
        LinkLabel disableHyperLink = new LinkLabel(LangBundle.message((String)"action.link.disable", (Object[])new Object[0]), null, (LinkListener)new LinkListener<Object>(){

            public void linkSelected(LinkLabel<Object> aSource, Object aLinkData) {
                CodeStyleSchemesPanel.this.disableOverriding();
            }
        });
        this.myBottomPanel.add((Component)disableHyperLink);
        this.myBottomPanel.setVisible(false);
        return this.myBottomPanel;
    }

    private void disableOverriding() {
        CodeStyleSchemesModel.OverridingStatus status = this.myModel.getOverridingStatus();
        if (status != null) {
            CodeStyleScheme currScheme = (CodeStyleScheme)this.getSelectedScheme();
            CodeStyleSettings currSettings = currScheme.getCodeStyleSettings();
            CodeStyleSettings modelSettings = this.myModel.getCloneSettings(currScheme);
            for (CodeStyleSettingsModifier modifier : status.getModifiers()) {
                Consumer disablingFunction = modifier.getDisablingFunction();
                if (disablingFunction == null) continue;
                disablingFunction.accept(currSettings);
                CodeStyleSettingsManager.getInstance((Project)this.myModel.getProject()).notifyCodeStyleSettingsChanged();
                disablingFunction.accept(modelSettings);
            }
            this.myModel.updateOverridingStatus();
            this.myModel.fireModelSettingsChanged(modelSettings);
        } else {
            this.myBottomPanel.setVisible(false);
        }
    }

    public final void updateOverridingMessage() {
        this.showOverridingMessage(this.myModel.getOverridingStatus());
    }

    private void showOverridingMessage(@Nullable CodeStyleSchemesModel.OverridingStatus overridingStatus) {
        if (overridingStatus != null) {
            CodeStyleSettingsModifier[] modifiers = overridingStatus.getModifiers();
            this.myBottomLabel.setText(CodeStyleSchemesPanel.getMessage(modifiers));
            this.myBottomPanel.setVisible(true);
            return;
        }
        this.myBottomPanel.setVisible(false);
    }

    private static String getMessage(CodeStyleSettingsModifier @NotNull [] modifiers) {
        StringBuilder messageBuilder = new StringBuilder();
        messageBuilder.append("Settings may be overridden by ");
        boolean isList = false;
        for (CodeStyleSettingsModifier modifier : modifiers) {
            if (isList) {
                messageBuilder.append(", ");
            }
            messageBuilder.append(modifier.getName());
            isList = true;
        }
        messageBuilder.append('.');
        return messageBuilder.toString();
    }
}

