/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis.problemsView.toolWindow;

import com.intellij.analysis.problemsView.toolWindow.HighlightingPanel;
import com.intellij.analysis.problemsView.toolWindow.ProblemsViewPanel;
import com.intellij.analysis.problemsView.toolWindow.ProblemsViewState;
import com.intellij.analysis.problemsView.toolWindow.ProjectErrorsPanel;
import com.intellij.ide.actions.ToggleToolbarAction;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Experiments;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowFactory;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ProblemsView
implements DumbAware,
ToolWindowFactory {
    private static final String ID = "Problems View";
    private static final int CURRENT_FILE_INDEX = 0;

    @Nullable
    public static ToolWindow getToolWindow(@Nullable Project project) {
        return project == null || project.isDisposed() ? null : ToolWindowManager.getInstance((Project)project).getToolWindow(ID);
    }

    public static void toggleCurrentFileProblems(@NotNull Project project) {
        ToolWindow window = ProblemsView.getToolWindow(project);
        if (window == null) {
            return;
        }
        ContentManager manager = window.getContentManager();
        if (window.isVisible() && manager.getSelectedContent() == manager.getContent(0)) {
            window.hide();
        } else {
            ProblemsView.selectContent(manager, 0);
            window.setAvailable(true, null);
            window.activate(null, true);
        }
    }

    public static void selectHighlighterIfVisible(@NotNull Project project, @NotNull RangeHighlighterEx highlighter) {
        HighlightingPanel panel2 = ProblemsView.get(HighlightingPanel.class, ProblemsView.getSelectedContent(project));
        if (panel2 != null && panel2.isShowing()) {
            panel2.selectHighlighter(highlighter);
        }
    }

    @Nullable
    static Document getDocument(@Nullable Project project, @NotNull VirtualFile file2) {
        PsiFileSystemItem item = file2.isDirectory() ? null : PsiUtilCore.findFileSystemItem((Project)project, (VirtualFile)file2);
        return item instanceof PsiFile ? PsiDocumentManager.getInstance((Project)project).getDocument((PsiFile)item) : null;
    }

    @Nullable
    static ProblemsViewPanel getSelectedPanel(@Nullable Project project) {
        return ProblemsView.get(ProblemsViewPanel.class, ProblemsView.getSelectedContent(project));
    }

    @Nullable
    private static Content getSelectedContent(@Nullable Project project) {
        ToolWindow window = ProblemsView.getToolWindow(project);
        ContentManager manager = window == null ? null : window.getContentManagerIfCreated();
        return manager == null ? null : manager.getSelectedContent();
    }

    private static void createContent(@NotNull ContentManager manager, @NotNull ProblemsViewPanel panel2) {
        Content content2 = manager.getFactory().createContent((JComponent)((Object)panel2), panel2.getDisplayName(), false);
        content2.setCloseable(false);
        manager.addContent(content2);
    }

    private static void selectContent(@NotNull ContentManager manager, int index) {
        Content content2 = manager.getContent(index);
        if (content2 != null) {
            manager.setSelectedContent(content2);
        }
    }

    private static void selectionChanged(boolean selected2, @Nullable Content content2) {
        ProblemsViewPanel panel2 = ProblemsView.get(ProblemsViewPanel.class, content2);
        if (panel2 != null) {
            panel2.selectionChangedTo(selected2);
        }
    }

    @Nullable
    private static <T> T get(@NotNull Class<T> type, @Nullable Content content2) {
        JComponent component2 = content2 == null ? null : content2.getComponent();
        return (T)(type.isInstance(component2) ? component2 : null);
    }

    public void createToolWindowContent(@NotNull Project project, @NotNull ToolWindow window) {
        final ProblemsViewState state = ProblemsViewState.getInstance(project);
        state.setShowToolbar(ToggleToolbarAction.isToolbarVisible(window, PropertiesComponent.getInstance((Project)project)));
        ContentManager manager = window.getContentManager();
        ProblemsView.createContent(manager, new HighlightingPanel(project, state));
        if (Experiments.getInstance().isFeatureEnabled("problems.view.project.errors.enabled")) {
            ProblemsView.createContent(manager, new ProjectErrorsPanel(project, state));
        }
        ProblemsView.selectContent(manager, state.getSelectedIndex());
        ProblemsView.selectionChanged(true, manager.getSelectedContent());
        manager.addContentManagerListener(new ContentManagerListener(){

            public void selectionChanged(@NotNull ContentManagerEvent event) {
                boolean selected2 = ContentManagerEvent.ContentOperation.add == event.getOperation();
                ProblemsView.selectionChanged(selected2, event.getContent());
                if (selected2) {
                    state.setSelectedIndex(event.getIndex());
                }
            }
        });
        project.getMessageBus().connect((Disposable)manager).subscribe(ToolWindowManagerListener.TOPIC, (Object)ProblemsView.createListener());
    }

    @NotNull
    private static ToolWindowManagerListener createListener() {
        return new ToolWindowManagerListener(){
            private final AtomicBoolean orientation = new AtomicBoolean();

            @Override
            public void stateChanged(@NotNull ToolWindowManager manager) {
                boolean vertical;
                ToolWindow window = manager.getToolWindow(ProblemsView.ID);
                if (window == null || window.isDisposed()) {
                    return;
                }
                boolean bl = vertical = !window.getAnchor().isHorizontal();
                if (vertical != this.orientation.getAndSet(vertical)) {
                    for (Content content2 : window.getContentManager().getContents()) {
                        ProblemsViewPanel panel2 = (ProblemsViewPanel)((Object)ProblemsView.get(ProblemsViewPanel.class, content2));
                        if (panel2 == null) continue;
                        panel2.orientationChangedTo(vertical);
                    }
                }
            }
        };
    }
}

