/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.okhttp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.grpc.ChannelLogger;
import io.grpc.ExperimentalApi;
import io.grpc.Internal;
import io.grpc.internal.AbstractManagedChannelImplBuilder;
import io.grpc.internal.AtomicBackoff;
import io.grpc.internal.ClientTransportFactory;
import io.grpc.internal.ConnectionClientTransport;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.KeepAliveManager;
import io.grpc.internal.SharedResourceHolder;
import io.grpc.internal.TransportTracer;
import io.grpc.okhttp.OkHttpClientTransport;
import io.grpc.okhttp.Utils;
import io.grpc.okhttp.internal.CipherSuite;
import io.grpc.okhttp.internal.ConnectionSpec;
import io.grpc.okhttp.internal.Platform;
import io.grpc.okhttp.internal.TlsVersion;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.net.SocketFactory;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/1785")
public class OkHttpChannelBuilder
extends AbstractManagedChannelImplBuilder<OkHttpChannelBuilder> {
    public static final int DEFAULT_FLOW_CONTROL_WINDOW = 65535;
    @VisibleForTesting
    static final ConnectionSpec INTERNAL_DEFAULT_CONNECTION_SPEC = new ConnectionSpec.Builder(ConnectionSpec.MODERN_TLS).cipherSuites(CipherSuite.TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384, CipherSuite.TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256, CipherSuite.TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384, CipherSuite.TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256, CipherSuite.TLS_DHE_RSA_WITH_AES_128_GCM_SHA256, CipherSuite.TLS_DHE_DSS_WITH_AES_128_GCM_SHA256, CipherSuite.TLS_DHE_RSA_WITH_AES_256_GCM_SHA384, CipherSuite.TLS_DHE_DSS_WITH_AES_256_GCM_SHA384).tlsVersions(TlsVersion.TLS_1_2).supportsTlsExtensions(true).build();
    private static final long AS_LARGE_AS_INFINITE = TimeUnit.DAYS.toNanos(1000L);
    private static final SharedResourceHolder.Resource<Executor> SHARED_EXECUTOR = new SharedResourceHolder.Resource<Executor>(){

        @Override
        public Executor create() {
            return Executors.newCachedThreadPool(GrpcUtil.getThreadFactory("grpc-okhttp-%d", true));
        }

        @Override
        public void close(Executor executor) {
            ((ExecutorService)executor).shutdown();
        }
    };
    private Executor transportExecutor;
    private ScheduledExecutorService scheduledExecutorService;
    private SocketFactory socketFactory;
    private SSLSocketFactory sslSocketFactory;
    private HostnameVerifier hostnameVerifier;
    private ConnectionSpec connectionSpec = INTERNAL_DEFAULT_CONNECTION_SPEC;
    private NegotiationType negotiationType = NegotiationType.TLS;
    private long keepAliveTimeNanos = Long.MAX_VALUE;
    private long keepAliveTimeoutNanos = GrpcUtil.DEFAULT_KEEPALIVE_TIMEOUT_NANOS;
    private int flowControlWindow = 65535;
    private boolean keepAliveWithoutCalls;
    private int maxInboundMetadataSize = Integer.MAX_VALUE;

    public static OkHttpChannelBuilder forAddress(String host, int port) {
        return new OkHttpChannelBuilder(host, port);
    }

    public static OkHttpChannelBuilder forTarget(String target) {
        return new OkHttpChannelBuilder(target);
    }

    protected OkHttpChannelBuilder(String host, int port) {
        this(GrpcUtil.authorityFromHostAndPort(host, port));
    }

    private OkHttpChannelBuilder(String target) {
        super(target);
    }

    @VisibleForTesting
    final OkHttpChannelBuilder setTransportTracerFactory(TransportTracer.Factory transportTracerFactory) {
        this.transportTracerFactory = transportTracerFactory;
        return this;
    }

    public final OkHttpChannelBuilder transportExecutor(@Nullable Executor transportExecutor) {
        this.transportExecutor = transportExecutor;
        return this;
    }

    public final OkHttpChannelBuilder socketFactory(@Nullable SocketFactory socketFactory) {
        this.socketFactory = socketFactory;
        return this;
    }

    @Deprecated
    public final OkHttpChannelBuilder negotiationType(io.grpc.okhttp.NegotiationType type) {
        Preconditions.checkNotNull((Object)((Object)type), (Object)"type");
        switch (type) {
            case TLS: {
                this.negotiationType = NegotiationType.TLS;
                break;
            }
            case PLAINTEXT: {
                this.negotiationType = NegotiationType.PLAINTEXT;
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown negotiation type: " + (Object)((Object)type)));
            }
        }
        return this;
    }

    @Deprecated
    public final OkHttpChannelBuilder enableKeepAlive(boolean enable) {
        if (enable) {
            return this.keepAliveTime(GrpcUtil.DEFAULT_KEEPALIVE_TIME_NANOS, TimeUnit.NANOSECONDS);
        }
        return this.keepAliveTime(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
    }

    @Deprecated
    public final OkHttpChannelBuilder enableKeepAlive(boolean enable, long keepAliveTime, TimeUnit delayUnit, long keepAliveTimeout, TimeUnit timeoutUnit) {
        if (enable) {
            return this.keepAliveTime(keepAliveTime, delayUnit).keepAliveTimeout(keepAliveTimeout, timeoutUnit);
        }
        return this.keepAliveTime(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
    }

    @Override
    public OkHttpChannelBuilder keepAliveTime(long keepAliveTime, TimeUnit timeUnit) {
        Preconditions.checkArgument((keepAliveTime > 0L ? 1 : 0) != 0, (Object)"keepalive time must be positive");
        this.keepAliveTimeNanos = timeUnit.toNanos(keepAliveTime);
        this.keepAliveTimeNanos = KeepAliveManager.clampKeepAliveTimeInNanos(this.keepAliveTimeNanos);
        if (this.keepAliveTimeNanos >= AS_LARGE_AS_INFINITE) {
            this.keepAliveTimeNanos = Long.MAX_VALUE;
        }
        return this;
    }

    @Override
    public OkHttpChannelBuilder keepAliveTimeout(long keepAliveTimeout, TimeUnit timeUnit) {
        Preconditions.checkArgument((keepAliveTimeout > 0L ? 1 : 0) != 0, (Object)"keepalive timeout must be positive");
        this.keepAliveTimeoutNanos = timeUnit.toNanos(keepAliveTimeout);
        this.keepAliveTimeoutNanos = KeepAliveManager.clampKeepAliveTimeoutInNanos(this.keepAliveTimeoutNanos);
        return this;
    }

    public OkHttpChannelBuilder flowControlWindow(int flowControlWindow) {
        Preconditions.checkState((flowControlWindow > 0 ? 1 : 0) != 0, (Object)"flowControlWindow must be positive");
        this.flowControlWindow = flowControlWindow;
        return this;
    }

    @Override
    public OkHttpChannelBuilder keepAliveWithoutCalls(boolean enable) {
        this.keepAliveWithoutCalls = enable;
        return this;
    }

    public final OkHttpChannelBuilder sslSocketFactory(SSLSocketFactory factory) {
        this.sslSocketFactory = factory;
        this.negotiationType = NegotiationType.TLS;
        return this;
    }

    public final OkHttpChannelBuilder hostnameVerifier(@Nullable HostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
        return this;
    }

    public final OkHttpChannelBuilder connectionSpec(com.squareup.okhttp.ConnectionSpec connectionSpec) {
        Preconditions.checkArgument((boolean)connectionSpec.isTls(), (Object)"plaintext ConnectionSpec is not accepted");
        this.connectionSpec = Utils.convertSpec(connectionSpec);
        return this;
    }

    @Override
    @Deprecated
    public final OkHttpChannelBuilder usePlaintext(boolean skipNegotiation) {
        if (!skipNegotiation) {
            throw new IllegalArgumentException("Plaintext negotiation not currently supported");
        }
        this.negotiationType(io.grpc.okhttp.NegotiationType.PLAINTEXT);
        return this;
    }

    @Override
    public final OkHttpChannelBuilder usePlaintext() {
        this.negotiationType = NegotiationType.PLAINTEXT;
        return this;
    }

    @Override
    public final OkHttpChannelBuilder useTransportSecurity() {
        this.negotiationType = NegotiationType.TLS;
        return this;
    }

    public final OkHttpChannelBuilder scheduledExecutorService(ScheduledExecutorService scheduledExecutorService) {
        this.scheduledExecutorService = (ScheduledExecutorService)Preconditions.checkNotNull((Object)scheduledExecutorService, (Object)"scheduledExecutorService");
        return this;
    }

    @Override
    public OkHttpChannelBuilder maxInboundMetadataSize(int bytes) {
        Preconditions.checkArgument((bytes > 0 ? 1 : 0) != 0, (Object)"maxInboundMetadataSize must be > 0");
        this.maxInboundMetadataSize = bytes;
        return this;
    }

    @Override
    @Internal
    protected final ClientTransportFactory buildTransportFactory() {
        boolean enableKeepAlive = this.keepAliveTimeNanos != Long.MAX_VALUE;
        return new OkHttpTransportFactory(this.transportExecutor, this.scheduledExecutorService, this.socketFactory, this.createSslSocketFactory(), this.hostnameVerifier, this.connectionSpec, this.maxInboundMessageSize(), enableKeepAlive, this.keepAliveTimeNanos, this.keepAliveTimeoutNanos, this.flowControlWindow, this.keepAliveWithoutCalls, this.maxInboundMetadataSize, this.transportTracerFactory);
    }

    @Override
    protected int getDefaultPort() {
        switch (this.negotiationType) {
            case PLAINTEXT: {
                return 80;
            }
            case TLS: {
                return 443;
            }
        }
        throw new AssertionError((Object)((Object)((Object)this.negotiationType) + " not handled"));
    }

    @Nullable
    @VisibleForTesting
    SSLSocketFactory createSslSocketFactory() {
        switch (this.negotiationType) {
            case TLS: {
                try {
                    if (this.sslSocketFactory == null) {
                        SSLContext sslContext;
                        if (GrpcUtil.IS_RESTRICTED_APPENGINE) {
                            sslContext = SSLContext.getInstance("TLS", Platform.get().getProvider());
                            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                            trustManagerFactory.init((KeyStore)null);
                            sslContext.init(null, trustManagerFactory.getTrustManagers(), SecureRandom.getInstance("SHA1PRNG", Platform.get().getProvider()));
                        } else {
                            sslContext = SSLContext.getInstance("Default", Platform.get().getProvider());
                        }
                        this.sslSocketFactory = sslContext.getSocketFactory();
                    }
                    return this.sslSocketFactory;
                }
                catch (GeneralSecurityException gse) {
                    throw new RuntimeException("TLS Provider failure", gse);
                }
            }
            case PLAINTEXT: {
                return null;
            }
        }
        throw new RuntimeException("Unknown negotiation type: " + (Object)((Object)this.negotiationType));
    }

    @Internal
    static final class OkHttpTransportFactory
    implements ClientTransportFactory {
        private final Executor executor;
        private final boolean usingSharedExecutor;
        private final boolean usingSharedScheduler;
        private final TransportTracer.Factory transportTracerFactory;
        private final SocketFactory socketFactory;
        @Nullable
        private final SSLSocketFactory sslSocketFactory;
        @Nullable
        private final HostnameVerifier hostnameVerifier;
        private final ConnectionSpec connectionSpec;
        private final int maxMessageSize;
        private final boolean enableKeepAlive;
        private final AtomicBackoff keepAliveTimeNanos;
        private final long keepAliveTimeoutNanos;
        private final int flowControlWindow;
        private final boolean keepAliveWithoutCalls;
        private final int maxInboundMetadataSize;
        private final ScheduledExecutorService timeoutService;
        private boolean closed;

        private OkHttpTransportFactory(Executor executor, @Nullable ScheduledExecutorService timeoutService, @Nullable SocketFactory socketFactory, @Nullable SSLSocketFactory sslSocketFactory, @Nullable HostnameVerifier hostnameVerifier, ConnectionSpec connectionSpec, int maxMessageSize, boolean enableKeepAlive, long keepAliveTimeNanos, long keepAliveTimeoutNanos, int flowControlWindow, boolean keepAliveWithoutCalls, int maxInboundMetadataSize, TransportTracer.Factory transportTracerFactory) {
            this.usingSharedScheduler = timeoutService == null;
            this.timeoutService = this.usingSharedScheduler ? SharedResourceHolder.get(GrpcUtil.TIMER_SERVICE) : timeoutService;
            this.socketFactory = socketFactory;
            this.sslSocketFactory = sslSocketFactory;
            this.hostnameVerifier = hostnameVerifier;
            this.connectionSpec = connectionSpec;
            this.maxMessageSize = maxMessageSize;
            this.enableKeepAlive = enableKeepAlive;
            this.keepAliveTimeNanos = new AtomicBackoff("keepalive time nanos", keepAliveTimeNanos);
            this.keepAliveTimeoutNanos = keepAliveTimeoutNanos;
            this.flowControlWindow = flowControlWindow;
            this.keepAliveWithoutCalls = keepAliveWithoutCalls;
            this.maxInboundMetadataSize = maxInboundMetadataSize;
            this.usingSharedExecutor = executor == null;
            this.transportTracerFactory = (TransportTracer.Factory)Preconditions.checkNotNull((Object)transportTracerFactory, (Object)"transportTracerFactory");
            this.executor = this.usingSharedExecutor ? (Executor)SharedResourceHolder.get(SHARED_EXECUTOR) : executor;
        }

        @Override
        public ConnectionClientTransport newClientTransport(SocketAddress addr, ClientTransportFactory.ClientTransportOptions options, ChannelLogger channelLogger) {
            if (this.closed) {
                throw new IllegalStateException("The transport factory is closed.");
            }
            final AtomicBackoff.State keepAliveTimeNanosState = this.keepAliveTimeNanos.getState();
            Runnable tooManyPingsRunnable = new Runnable(){

                @Override
                public void run() {
                    keepAliveTimeNanosState.backoff();
                }
            };
            InetSocketAddress inetSocketAddr = (InetSocketAddress)addr;
            OkHttpClientTransport transport = new OkHttpClientTransport(inetSocketAddr, options.getAuthority(), options.getUserAgent(), options.getEagAttributes(), this.executor, this.socketFactory, this.sslSocketFactory, this.hostnameVerifier, this.connectionSpec, this.maxMessageSize, this.flowControlWindow, options.getHttpConnectProxiedSocketAddress(), tooManyPingsRunnable, this.maxInboundMetadataSize, this.transportTracerFactory.create());
            if (this.enableKeepAlive) {
                transport.enableKeepAlive(true, keepAliveTimeNanosState.get(), this.keepAliveTimeoutNanos, this.keepAliveWithoutCalls);
            }
            return transport;
        }

        @Override
        public ScheduledExecutorService getScheduledExecutorService() {
            return this.timeoutService;
        }

        @Override
        public void close() {
            if (this.closed) {
                return;
            }
            this.closed = true;
            if (this.usingSharedScheduler) {
                SharedResourceHolder.release(GrpcUtil.TIMER_SERVICE, this.timeoutService);
            }
            if (this.usingSharedExecutor) {
                SharedResourceHolder.release(SHARED_EXECUTOR, this.executor);
            }
        }
    }

    private static enum NegotiationType {
        TLS,
        PLAINTEXT;

    }
}

